/*
 * Decompiled with CFR 0.152.
 */
package com.dsjdf.jtx;

import com.dsjdf.db.ConnectionContext;
import com.dsjdf.jtx.CommitException;
import com.dsjdf.jtx.RollbackException;
import com.dsjdf.jtx.UserTransaction;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Vector;

public class MultipleUserTransaction
implements UserTransaction {
    private Vector connContexts = new Vector();

    public MultipleUserTransaction(ConnectionContext connCtx) {
        this.connContexts.addElement(connCtx);
        this.setAutoCommit(false);
    }

    public void commit() throws CommitException {
        try {
            Enumeration ctxs = this.connContexts.elements();
            while (ctxs.hasMoreElements()) {
                ConnectionContext ctx = (ConnectionContext)ctxs.nextElement();
                Connection conn = ctx.getConnection();
                conn.commit();
            }
        }
        catch (Exception e) {
            throw new CommitException(e.getMessage());
        }
    }

    public Vector getConnectionContexts() {
        return this.connContexts;
    }

    public void join(UserTransaction utx) {
        try {
            Enumeration ctxs = utx.getConnectionContexts().elements();
            while (ctxs.hasMoreElements()) {
                ConnectionContext ctx = (ConnectionContext)ctxs.nextElement();
                if (this.connContexts.contains(ctx)) continue;
                this.connContexts.addElement(ctx);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("can not join a transaction:" + e.getMessage());
        }
    }

    public void rollback() throws RollbackException {
        try {
            Enumeration ctxs = this.connContexts.elements();
            while (ctxs.hasMoreElements()) {
                ConnectionContext ctx = (ConnectionContext)ctxs.nextElement();
                Connection conn = ctx.getConnection();
                conn.rollback();
            }
        }
        catch (Exception e) {
            throw new RollbackException(e.getMessage());
        }
    }

    public void setAutoCommit(boolean autoCommit) {
        try {
            Enumeration ctxs = this.connContexts.elements();
            while (ctxs.hasMoreElements()) {
                ConnectionContext ctx = (ConnectionContext)ctxs.nextElement();
                Connection conn = ctx.getConnection();
                conn.setAutoCommit(autoCommit);
            }
        }
        catch (Exception e) {
            String err = e.getMessage();
            if (err == null) {
                err = "one of connections is not assigned";
            }
            throw new IllegalStateException(err);
        }
    }
}

