/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.io;

import com.gpki.secureweb.GPKIKeyInfo;
import com.gpki.secureweb.GPKISecureWEBException;
import com.gpki.util.CryptoTagFinder;
import java.io.IOException;
import java.util.List;
import javax.servlet.jsp.JspWriter;

public class GPKIJspWriter
extends JspWriter {
    JspWriter out = null;
    private CryptoTagFinder finder;
    static String lineSeparator = System.getProperty("line.separator");

    public GPKIJspWriter(int arg0, boolean arg1) {
        super(arg0, arg1);
    }

    public GPKIJspWriter(JspWriter out) throws Exception {
        super(out.getBufferSize(), out.isAutoFlush());
        this.out = out;
        this.finder = new CryptoTagFinder();
    }

    public GPKIJspWriter(JspWriter out, GPKIKeyInfo keyinfo) throws Exception {
        super(out.getBufferSize(), out.isAutoFlush());
        this.out = out;
        this.finder = new CryptoTagFinder(keyinfo);
    }

    public void newLine() throws IOException {
        this.write(lineSeparator, 0, lineSeparator.length());
    }

    public void print(boolean arg0) throws IOException {
        this.print(String.valueOf(arg0));
    }

    public void print(char arg0) throws IOException {
        this.print(String.valueOf(arg0));
    }

    public void print(int arg0) throws IOException {
        this.print(String.valueOf(arg0));
    }

    public void print(long arg0) throws IOException {
        this.print(String.valueOf(arg0));
    }

    public void print(float arg0) throws IOException {
        this.print(String.valueOf(arg0));
    }

    public void print(double arg0) throws IOException {
        this.print(String.valueOf(arg0));
    }

    public void print(char[] arg0) throws IOException {
        this.print(String.valueOf(arg0));
    }

    public void print(String src) throws IOException {
        List ret;
        try {
            ret = this.finder.getDelimStringForEncrypt(src);
        }
        catch (GPKISecureWEBException e) {
            throw new IOException(e.getMessage());
        }
        int i = 0;
        while (i < ret.size()) {
            String retString = (String)ret.get(i);
            this.out.write(retString.toCharArray());
            ++i;
        }
    }

    public void print(Object arg0) throws IOException {
        this.print(String.valueOf(arg0));
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void println(boolean arg0) throws IOException {
        this.println(String.valueOf(arg0));
        this.println();
    }

    public void println(char arg0) throws IOException {
        this.println(String.valueOf(arg0));
        this.println();
    }

    public void println(int arg0) throws IOException {
        this.println(String.valueOf(arg0));
        this.println();
    }

    public void println(long arg0) throws IOException {
        this.println(String.valueOf(arg0));
        this.println();
    }

    public void println(float arg0) throws IOException {
        this.println(String.valueOf(arg0));
        this.println();
    }

    public void println(double arg0) throws IOException {
        this.println(String.valueOf(arg0));
        this.println();
    }

    public void println(char[] arg0) throws IOException {
        this.println(String.valueOf(arg0));
        this.println();
    }

    public void println(String src) throws IOException {
        List ret;
        try {
            ret = this.finder.getDelimStringForEncrypt(src);
        }
        catch (GPKISecureWEBException e) {
            throw new IOException(e.getMessage());
        }
        int i = 0;
        while (i < ret.size()) {
            String retString = (String)ret.get(i);
            this.out.write(retString.toCharArray());
            ++i;
        }
    }

    public void println(Object arg0) throws IOException {
        this.println(String.valueOf(arg0));
        this.println();
    }

    public void clear() throws IOException {
        this.out.clear();
    }

    public void clearBuffer() throws IOException {
        this.out.clearBuffer();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public int getRemaining() {
        return this.out.getRemaining();
    }

    public void write(char[] arg0, int arg1, int arg2) throws IOException {
        List ret;
        String src = new String(arg0);
        src = src.substring(arg1, arg2);
        try {
            ret = this.finder.getDelimStringForEncrypt(src);
        }
        catch (GPKISecureWEBException e) {
            throw new IOException(e.getMessage());
        }
        int i = 0;
        while (i < ret.size()) {
            String retString = (String)ret.get(i);
            this.out.write(retString.toCharArray());
            ++i;
        }
    }
}

