/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.servlet;

import com.dsjdf.jdf.Logger;
import com.dsjdf.jdf.Utility;
import com.gpki.gpkiapi.GpkiApi;
import com.gpki.gpkiapi.cert.X509Certificate;
import com.gpki.gpkiapi.cms.SignedContent;
import com.gpki.gpkiapi.cms.SignedData;
import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi.ivs.VerifyCert;
import com.gpki.gpkiapi.util.Dump;
import com.gpki.secureweb.Base64ContentInfo;
import com.gpki.secureweb.EncryptedData;
import com.gpki.secureweb.EnvelopData;
import com.gpki.secureweb.GPKIKeyInfo;
import com.gpki.secureweb.GPKISecureWEBConfig;
import com.gpki.secureweb.GPKISecureWEBDefine;
import com.gpki.secureweb.GPKISecureWEBException;
import com.gpki.secureweb.KDF;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class GPKIHttpServletRequest
implements HttpServletRequest,
GPKISecureWEBDefine {
    HttpServletRequest request;
    Hashtable paramMap;
    int message_type;
    byte[] signData;
    byte[] privatekey_random;
    String decryptData = "";
    X509Certificate signer_cert = null;

    public GPKIHttpServletRequest(HttpServletRequest request) throws Exception {
        this.request = request;
        this.init();
    }

    private void init() throws GPKISecureWEBException {
        block37: {
            this.paramMap = new Hashtable(20);
            GPKIKeyInfo keyinfo = null;
            try {
                SignedData signdata;
                KDF kdf;
                SignedData signdata2;
                EncryptedData encdata;
                GPKISecureWEBConfig conf = GPKISecureWEBConfig.getInstance();
                GpkiApi.init((String)GPKISecureWEBConfig.getGPKIAPIConfFilePath());
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] GpkiApi.init() : " + GPKISecureWEBConfig.getGPKIAPIConfFilePath());
                String query = this.request.getParameter("encryptedData");
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] query : " + query);
                if (query == null) {
                    return;
                }
                Base64ContentInfo base64info = new Base64ContentInfo(query);
                byte cType = base64info.getContentType();
                this.message_type = cType;
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] message_type : " + this.message_type);
                HttpSession httpsession = null;
                if (this.message_type != 20 && this.message_type != 30) {
                    httpsession = this.request.getSession(false);
                    Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] GPKIHttpServletRequest SessionID(session) : " + httpsession.getId());
                    Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] GPKIHttpServletRequest SessionID(request) : " + this.request.getSession().getId());
                    Logger.debug.println(this, "AttributeNames \ubfcc\ub9ac\uae30 \uc2dc\uc791");
                    Enumeration e1 = httpsession.getAttributeNames();
                    while (e1.hasMoreElements()) {
                        String attVale = (String)e1.nextElement();
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] GPKIHttpServletRequest AttributeNames : " + attVale);
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] GPKIHttpServletRequest AttributeValue : " + httpsession.getAttribute(attVale));
                    }
                    Logger.debug.println(this, "AttributeNames \ubfcc\ub9ac\uae30 \ub05d");
                    if (httpsession == null) {
                        throw new GPKISecureWEBException("Session Not Found!");
                    }
                    keyinfo = (GPKIKeyInfo)httpsession.getAttribute("GPKISession");
                }
                if (this.message_type == 0) {
                    try {
                        encdata = new EncryptedData(query);
                        encdata.setKey(keyinfo.getAlgo(), keyinfo.getClientKey(), keyinfo.getClientIV());
                        this.decryptData = new String(encdata.decrypt());
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] \uc6d0\ubcf8 \uba54\uc2dc\uc9c0 : " + Dump.toHexString((byte[])this.decryptData.getBytes(), (long)0L, (long)this.decryptData.getBytes().length));
                        this.setDecrytData2Query(this.decryptData);
                        break block37;
                    }
                    catch (Exception e) {
                        Logger.err.println(this, "[" + Thread.currentThread().getName() + "] ENCRYPTED_DATA Error : " + e.getMessage());
                        throw new GPKISecureWEBException(e);
                    }
                }
                if (this.message_type == 1) {
                    try {
                        encdata = new EncryptedData(query);
                        encdata.setKey(keyinfo.getAlgo(), keyinfo.getClientKey(), keyinfo.getClientIV());
                        this.signData = encdata.decrypt();
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] signData : " + Dump.toHexString((byte[])this.signData, (long)0L, (long)this.signData.length));
                        signdata2 = new SignedData();
                        signdata2.verify(this.signData);
                        this.decryptData = new String(signdata2.getMessage());
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] \uc6d0\ubcf8 \uba54\uc2dc\uc9c0 : " + Dump.toHexString((byte[])this.decryptData.getBytes(), (long)0L, (long)this.decryptData.getBytes().length));
                        this.setDecrytData2Query(this.decryptData);
                        int signer_cnt = signdata2.getSignerCnt();
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] signer_cnt : " + signer_cnt);
                        if (signer_cnt > 0) {
                            this.signer_cert = signdata2.getSignerCert(signer_cnt - 1);
                            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] \ud074\ub77c\uc774\uc5b8\ud2b8 \uc778\uc99d\uc11c DN : " + this.signer_cert.getSubjectDN());
                            this.checkPolicy(this.signer_cert);
                            this.verifyCert(this.signer_cert);
                            Logger.info.println(this, "[" + Thread.currentThread().getName() + "] \uc778\uc99d\uc11c \uac80\uc99d \uc644\ub8cc  : DN  [" + this.signer_cert.getSubjectDN() + "]");
                        }
                        break block37;
                    }
                    catch (Exception e) {
                        Logger.err.println(this, "[" + Thread.currentThread().getName() + "] ENCRYPTED_SIGNDATA Error : " + e.getMessage());
                        throw new GPKISecureWEBException(e);
                    }
                }
                if (this.message_type == 2) {
                    try {
                        encdata = new EncryptedData(query);
                        encdata.setKey(keyinfo.getAlgo(), keyinfo.getClientKey(), keyinfo.getClientIV());
                        this.signData = encdata.decrypt();
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] signData : " + Dump.toHexString((byte[])this.signData, (long)0L, (long)this.signData.length));
                        SignedContent signedcontent = new SignedContent();
                        signedcontent.verify(this.signData);
                        this.decryptData = new String(signedcontent.getMessage());
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] \uc6d0\ubcf8 \uba54\uc2dc\uc9c0 : " + Dump.toHexString((byte[])this.decryptData.getBytes(), (long)0L, (long)this.decryptData.getBytes().length));
                        this.setDecrytData2Query(this.decryptData);
                        this.signer_cert = signedcontent.getSignerCert();
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] signer_cert : " + this.signer_cert);
                        this.checkPolicy(this.signer_cert);
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] checkPolicy \uc644\ub8cc");
                        this.verifyCert(this.signer_cert);
                        Logger.info.println(this, "[" + Thread.currentThread().getName() + "] \uc778\uc99d\uc11c \uac80\uc99d \uc644\ub8cc  : DN  [" + this.signer_cert.getSubjectDN() + "]");
                        break block37;
                    }
                    catch (Exception e) {
                        Logger.err.println(this, "[" + Thread.currentThread().getName() + "] ENCRYPTED_SIGNDATA Error : " + e.getMessage());
                        throw new GPKISecureWEBException(e);
                    }
                }
                if (this.message_type == 21 || this.message_type == 31) {
                    try {
                        EnvelopData envelop_data = new EnvelopData(query);
                        this.decryptData = new String(envelop_data.decrypt());
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] \uc6d0\ubcf8 \uba54\uc2dc\uc9c0 : " + Dump.toHexString((byte[])this.decryptData.getBytes(), (long)0L, (long)this.decryptData.getBytes().length));
                        this.setDecrytData2Query(this.decryptData);
                        this.checkChallenge(keyinfo);
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] ENVELOP_DATA checkChallenge \uc644\ub8cc ");
                        keyinfo.setChallenge("");
                        httpsession.setAttribute("GPKISession", (Object)keyinfo);
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] ENVELOP_DATA challenge \ucd08\uae30\ud654 \uc644\ub8cc ");
                        KDF kdf2 = new KDF();
                        kdf2.setBaseKey(envelop_data.secretkey, envelop_data.getContentInfo());
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] ENVELOP_DATA setBaseKey \ucd08\uae30\ud654 \uc644\ub8cc ");
                        httpsession.setAttribute("GPKISession", (Object)kdf2.getGPKIKeyInfo());
                        break block37;
                    }
                    catch (Exception e) {
                        Logger.err.println(this, "[" + Thread.currentThread().getName() + "] ENVELOP_DATA, WAP_ENVELOP_DATA Error : " + e.getMessage());
                        throw new GPKISecureWEBException(e);
                    }
                }
                if (this.message_type == 23) {
                    try {
                        kdf = this.processEnvelopData(query);
                        signdata2 = new SignedData();
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] \uc11c\uba85\uac80\uc99d \ub4e4\uc5b4\uac00\uae30 \uc804 signData(23) : " + Dump.toHexString((byte[])this.signData, (long)0L, (long)this.signData.length));
                        signdata2.verify(this.signData);
                        this.decryptData = new String(signdata2.getMessage());
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] \ub85c\uae34\uc2dc(23) \uc6d0\ubcf8 \uba54\uc2dc\uc9c0 : " + Dump.toHexString((byte[])this.decryptData.getBytes(), (long)0L, (long)this.decryptData.getBytes().length));
                        this.setDecrytData2Query(this.decryptData);
                        this.checkChallenge(keyinfo);
                        keyinfo.setChallenge("");
                        httpsession.setAttribute("GPKISession", (Object)keyinfo);
                        this.signer_cert = signdata2.getSignerCert(0);
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] \ud074\ub77c\uc774\uc5b8\ud2b8 \uc778\uc99d\uc11c DN : " + this.signer_cert.getSubjectDN());
                        this.checkPolicy(this.signer_cert);
                        this.verifyCert(this.signer_cert);
                        Logger.info.println(this, "[" + Thread.currentThread().getName() + "] \uc778\uc99d\uc11c \uac80\uc99d \uc644\ub8cc  : DN  [" + this.signer_cert.getSubjectDN() + "]");
                        keyinfo.setSignerCert(this.signer_cert);
                        keyinfo.setAuthType(true);
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] \uc138\uc158\uc5d0 \uc778\uc99d\uc11c \uc815\ubcf4 \uc138\ud305 ");
                        httpsession.setAttribute("GPKISession", (Object)kdf.getGPKIKeyInfo());
                        break block37;
                    }
                    catch (Exception e) {
                        Logger.err.println(this, "[" + Thread.currentThread().getName() + "] LOGIN_ENVELOP_SIGN_DATA Error : " + e.getMessage());
                        throw new GPKISecureWEBException(e);
                    }
                }
                if (this.message_type == 22) {
                    try {
                        kdf = this.processEnvelopData(query);
                        signdata2 = new SignedData();
                        signdata2.verify(this.signData);
                        this.decryptData = new String(signdata2.getMessage());
                        Logger.debug.println(this, "\uc6d0\ubcf8 \uba54\uc2dc\uc9c0 : " + Dump.toHexString((byte[])this.decryptData.getBytes(), (long)0L, (long)this.decryptData.getBytes().length));
                        this.setDecrytData2Query(this.decryptData);
                        this.checkChallenge(keyinfo);
                        keyinfo.setChallenge("");
                        httpsession.setAttribute("GPKISession", (Object)keyinfo);
                        int signer_cnt = signdata2.getSignerCnt();
                        if (signer_cnt > 0) {
                            this.signer_cert = signdata2.getSignerCert(signer_cnt - 1);
                            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] signer_cert : " + this.signer_cert);
                            this.checkPolicy(this.signer_cert);
                            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] checkPolicy \uc644\ub8cc");
                            this.verifyCert(this.signer_cert);
                            Logger.info.println(this, "[" + Thread.currentThread().getName() + "] \uc778\uc99d\uc11c \uac80\uc99d \uc644\ub8cc  : DN  [" + this.signer_cert.getSubjectDN() + "]");
                        }
                        httpsession.setAttribute("GPKISession", (Object)kdf.getGPKIKeyInfo());
                        break block37;
                    }
                    catch (Exception e) {
                        Logger.err.println(this, "[" + Thread.currentThread().getName() + "] ENVELOP_SIGNDATA Error : " + e.getMessage());
                        throw new GPKISecureWEBException(e);
                    }
                }
                if (this.message_type == 33 || this.message_type == 32) {
                    try {
                        kdf = this.processEnvelopData(query);
                        signdata2 = new SignedContent();
                        signdata2.verify(this.signData);
                        this.decryptData = new String(signdata2.getMessage());
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] \uc6d0\ubcf8 \uba54\uc2dc\uc9c0 : " + Dump.toHexString((byte[])this.decryptData.getBytes(), (long)0L, (long)this.decryptData.getBytes().length));
                        this.setDecrytData2Query(this.decryptData);
                        this.checkChallenge(keyinfo);
                        keyinfo.setChallenge("");
                        httpsession.setAttribute("GPKISession", (Object)keyinfo);
                        this.signer_cert = signdata2.getSignerCert();
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] signer_cert : " + this.signer_cert);
                        this.checkPolicy(this.signer_cert);
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] checkPolicy \uc644\ub8cc");
                        this.verifyCert(this.signer_cert);
                        Logger.info.println(this, "[" + Thread.currentThread().getName() + "] \uc778\uc99d\uc11c \uac80\uc99d \uc644\ub8cc  : DN  [" + this.signer_cert.getSubjectDN() + "]");
                        if (this.message_type == 33) {
                            keyinfo.setSignerCert(this.signer_cert);
                            keyinfo.setAuthType(true);
                        }
                        httpsession.setAttribute("GPKISession", (Object)kdf.getGPKIKeyInfo());
                        break block37;
                    }
                    catch (Exception e) {
                        Logger.err.println(this, "][" + Thread.currentThread().getName() + "] LOGIN_ENVELOP_WAPSIGN_DATA, ENVELOP_WAPSIGN_DATA Error : " + e.getMessage());
                        throw new GPKISecureWEBException(e);
                    }
                }
                if (this.message_type == 20) {
                    try {
                        this.signData = base64info.getContentInfo();
                        signdata = new SignedData();
                        signdata.verify(this.signData);
                        this.decryptData = new String(signdata.getMessage());
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] \uc6d0\ubcf8 \uba54\uc2dc\uc9c0 : " + Dump.toHexString((byte[])this.decryptData.getBytes(), (long)0L, (long)this.decryptData.getBytes().length));
                        int signer_cnt = signdata.getSignerCnt();
                        if (signer_cnt > 0) {
                            this.signer_cert = signdata.getSignerCert(signer_cnt - 1);
                            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] signer_cert : " + this.signer_cert);
                            this.checkPolicy(this.signer_cert);
                            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] checkPolicy \uc644\ub8cc");
                            this.verifyCert(this.signer_cert);
                            Logger.info.println(this, "[" + Thread.currentThread().getName() + "] \uc778\uc99d\uc11c \uac80\uc99d \uc644\ub8cc  : DN  [" + this.signer_cert.getSubjectDN() + "]");
                        }
                        break block37;
                    }
                    catch (Exception e) {
                        Logger.err.println(this, "[" + Thread.currentThread().getName() + "] SIGNED_DATA Error : " + e.getMessage());
                        throw new GPKISecureWEBException(e);
                    }
                }
                if (this.message_type == 30) {
                    try {
                        this.signData = base64info.getContentInfo();
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] signData : " + Dump.toHexString((byte[])this.signData, (long)0L, (long)this.signData.length));
                        signdata = new SignedContent();
                        signdata.verify(this.signData);
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] signData \uac80\uc99d \uc644\ub8cc");
                        this.decryptData = new String(signdata.getMessage());
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] \uc6d0\ubcf8 \uba54\uc2dc\uc9c0 : " + Dump.toHexString((byte[])this.decryptData.getBytes(), (long)0L, (long)this.decryptData.getBytes().length));
                        this.signer_cert = signdata.getSignerCert();
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] signer_cert : " + this.signer_cert);
                        this.checkPolicy(this.signer_cert);
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] checkPolicy \uc644\ub8cc");
                        this.verifyCert(this.signer_cert);
                        Logger.info.println(this, "[" + Thread.currentThread().getName() + "] \uc778\uc99d\uc11c \uac80\uc99d \uc644\ub8cc  : DN  [" + this.signer_cert.getSubjectDN() + "]");
                        break block37;
                    }
                    catch (Exception e) {
                        Logger.err.println(this, "[" + Thread.currentThread().getName() + "] SIGNED_CONTENT Error : " + e.getMessage());
                        throw new GPKISecureWEBException(e);
                    }
                }
                throw new GPKISecureWEBException("Not GPKI Encrypt Message Type[" + this.message_type + "]");
            }
            catch (Exception e) {
                Logger.err.println(this, Utility.getStackTrace(e));
                throw new GPKISecureWEBException(e);
            }
        }
    }

    private void checkChallenge(GPKIKeyInfo keyinfo) throws GPKISecureWEBException {
        try {
            GPKISecureWEBConfig conf = GPKISecureWEBConfig.getInstance();
            if (GPKISecureWEBConfig.getCheckChallenge().equals("yes")) {
                String challenge = this.getChallenge();
                if (this.message_type == 0 || this.message_type == 21 || this.message_type == 31) {
                    challenge = challenge.substring(0, 28);
                }
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] client challenge : " + challenge);
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] session challenge : " + keyinfo.getChallenge());
                if (keyinfo == null) {
                    throw new GPKISecureWEBException("session keyinfo challege is null, need client page reload");
                }
                Logger.debug.println(this, "checkChallenge1");
                if (keyinfo.equals("") || challenge == null || keyinfo.getChallenge() == null || keyinfo.getChallenge().equals("")) {
                    throw new GPKISecureWEBException("Replay check -> challenge is null or empty : client challenge =  " + challenge + "- server challenge = " + keyinfo.getChallenge());
                }
                Logger.debug.println(this, "checkChallenge2");
                if (!keyinfo.getChallenge().equals(challenge)) {
                    throw new GPKISecureWEBException("Replay attack..client challenge = " + challenge + " - server challenge = " + keyinfo.getChallenge());
                }
            }
        }
        catch (Exception e) {
            Logger.err.println(this, "[" + Thread.currentThread().getName() + "] checkChallenge() Error : " + e.getMessage());
            throw new GPKISecureWEBException(e);
        }
    }

    private String getChallenge() throws GPKISecureWEBException {
        String challenge = "";
        try {
            List list = (List)this.paramMap.get("challenge");
            challenge = (String)list.get(0);
        }
        catch (Exception e) {
            Logger.err.println(this, "[" + Thread.currentThread().getName() + "] getChallenge() Error : " + e.getMessage());
            throw new GPKISecureWEBException("Challenge Acquisition Failure!");
        }
        return challenge;
    }

    private KDF processEnvelopData(String s) throws GPKISecureWEBException {
        try {
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] query : " + s);
            EnvelopData envelop_data = new EnvelopData(s);
            this.signData = envelop_data.decrypt();
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] signData : " + Dump.toHexString((byte[])this.signData, (long)0L, (long)this.signData.length));
            this.privatekey_random = envelop_data.getPrivateKeyRandom();
            KDF kdf = new KDF();
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] processEnvelopData() envelop_data.secretkey : " + envelop_data.secretkey);
            kdf.setBaseKey(envelop_data.secretkey, envelop_data.getContentInfo());
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] key\uac12 \uc138\ud305 \uc644\ub8cc");
            return kdf;
        }
        catch (Exception e) {
            Logger.err.println(this, "[" + Thread.currentThread().getName() + "] processEnvelopData() Error : " + e.getMessage());
            throw new GPKISecureWEBException(e);
        }
    }

    private void checkPolicy(X509Certificate signer_cert) throws GPKISecureWEBException {
        try {
            if (GPKISecureWEBConfig.getAnyPolicy().equals("yes")) {
                String signer_policies = signer_cert.getCertPolicy();
                String config_policies = GPKISecureWEBConfig.getPolicies();
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] signer_policies : " + signer_policies + " ::: " + "config_policies : " + config_policies);
                ArrayList<String> confPolicyList = new ArrayList<String>(4);
                StringTokenizer signer_policies_token = new StringTokenizer(signer_policies, ",");
                StringTokenizer conf_policies_token = new StringTokenizer(config_policies, ",");
                while (conf_policies_token.hasMoreTokens()) {
                    confPolicyList.add(conf_policies_token.nextToken());
                }
                String oid = "";
                while (signer_policies_token.hasMoreTokens()) {
                    String token = signer_policies_token.nextToken();
                    if (!confPolicyList.contains(token)) continue;
                    oid = token;
                    break;
                }
                if (oid.equals("")) {
                    Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] \uc815\ucc45\uac80\uc99d \uc5d0\ub7ec - " + "client cert policies : " + signer_policies + "- config_policies : " + config_policies);
                    throw new GPKISecureWEBException("CheckPolicy Error - client cert policy : " + signer_policies + " - Server GPKISecureWeb.properties File Check!!");
                }
            }
        }
        catch (Exception e) {
            Logger.err.println(this, "[" + Thread.currentThread().getName() + "] checkPolicy() Error : " + e.getMessage());
            throw new GPKISecureWEBException(e);
        }
    }

    private void verifyCert(X509Certificate signer_cert) throws GPKISecureWEBException {
        try {
            VerifyCert vcert = new VerifyCert(String.valueOf(GPKISecureWEBConfig.getGPKIAPIConfFilePath()) + "/gpkiapi.conf");
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] VerifyCert(" + GPKISecureWEBConfig.getGPKIAPIConfFilePath() + ")");
            vcert.setMyCert(GPKISecureWEBConfig.getServerCert());
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] setMyCert \uc644\ub8cc");
            vcert.verify(signer_cert);
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] signer_cert DN : " + signer_cert.getSubjectDN());
        }
        catch (Exception e) {
            try {
                Logger.err.println(this, "[" + Thread.currentThread().getName() + "] \uc778\uc99d\uc11c \uac80\uc99d \uc2e4\ud328  : DN - [" + signer_cert.getSubjectDN() + "]");
            }
            catch (GpkiApiException e1) {
                e1.printStackTrace();
            }
            Logger.err.println(this, "[" + Thread.currentThread().getName() + "] verifyCert() Error : " + e.getStackTrace());
            throw new GPKISecureWEBException(e);
        }
    }

    private void setDecrytData2Query(String decryptData) throws GPKISecureWEBException {
        try {
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] setDecrytData2Query start");
            if (decryptData != null || !decryptData.equals("")) {
                StringTokenizer st = new StringTokenizer(decryptData, "&");
                while (st.hasMoreElements()) {
                    String stValue = (String)st.nextElement();
                    String key = stValue.substring(0, stValue.indexOf(61));
                    String value = stValue.substring(stValue.indexOf(61) + 1);
                    List<String> list = null;
                    list = this.paramMap.containsKey(key) ? (List)this.paramMap.get(key) : new ArrayList<String>();
                    list.add(value);
                    this.paramMap.put(key, list);
                }
            }
        }
        catch (Exception e) {
            Logger.err.println(this, "[" + Thread.currentThread().getName() + "] setDecrytData2Query() Error : " + e.getMessage());
            throw new GPKISecureWEBException(e);
        }
        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] setDecrytData2Query end");
    }

    public int getRequestMessageType() {
        return this.message_type;
    }

    public String getSignType() {
        String signType = "";
        if (this.message_type == 1 || this.message_type == 23 || this.message_type == 22 || this.message_type == 20) {
            signType = "WIRE";
        } else if (this.message_type == 33 || this.message_type == 32 || this.message_type == 30) {
            signType = "WIRELESS";
        }
        return signType;
    }

    public byte[] getSignedData() {
        return this.signData;
    }

    public byte[] getSignerRValue() {
        return this.privatekey_random;
    }

    public X509Certificate getSignerCert() {
        return this.signer_cert;
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public Cookie[] getCookies() {
        return this.request.getCookies();
    }

    public long getDateHeader(String arg0) {
        return this.request.getDateHeader(arg0);
    }

    public String getHeader(String arg0) {
        return this.request.getHeader(arg0);
    }

    public Enumeration getHeaders(String arg0) {
        return this.request.getHeaders(arg0);
    }

    public Enumeration getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public int getIntHeader(String arg0) {
        return this.request.getIntHeader(arg0);
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    public String getPathTranslated() {
        return this.request.getPathTranslated();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getQueryString() {
        return this.decryptData;
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public boolean isUserInRole(String arg0) {
        return this.request.isUserInRole(arg0);
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this.request.getRequestURL();
    }

    public String getServletPath() {
        return this.request.getServletPath();
    }

    public HttpSession getSession(boolean arg0) {
        return this.request.getSession(arg0);
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public Object getAttribute(String arg0) {
        return this.request.getAttribute(arg0);
    }

    public Enumeration getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(arg0);
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public String getParameter(String arg0) {
        List list = (List)this.paramMap.get(arg0);
        return (String)list.get(0);
    }

    public Enumeration getParameterNames() {
        return this.paramMap.keys();
    }

    public String[] getParameterValues(String arg0) {
        List list = (List)this.paramMap.get(arg0);
        String[] ret = new String[list.size()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = (String)list.get(i);
            ++i;
        }
        return ret;
    }

    public Map getParameterMap() {
        return this.paramMap;
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        return this.request.getReader();
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public void setAttribute(String arg0, Object arg1) {
        this.request.setAttribute(arg0, arg1);
    }

    public void removeAttribute(String arg0) {
        this.request.removeAttribute(arg0);
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Enumeration getLocales() {
        return this.request.getLocales();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return this.request.getRequestDispatcher(arg0);
    }

    public String getRealPath(String arg0) {
        return this.request.getRealPath(arg0);
    }
}

