/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.util;

import com.dsjdf.jdf.Configuration;
import com.dsjdf.jdf.ConfigurationException;
import com.dsjdf.jdf.Logger;
import com.dsjdf.jdf.Utility;
import com.gpki.gpkiapi.util.Dump;
import com.gpki.secureweb.EncryptedData;
import com.gpki.secureweb.GPKIKeyInfo;
import com.gpki.secureweb.GPKISecureWEBException;
import java.util.ArrayList;
import java.util.List;

public class CryptoTagFinder {
    boolean isEncrypt = false;
    private StringBuffer encBuffer = new StringBuffer();
    public static String startDelim;
    public static String endDelim;
    private String algorithm;
    private GPKIKeyInfo keyinfo;
    String srcHeadTmp = "";
    String srcTailTmp = "";

    public CryptoTagFinder() throws ConfigurationException {
        Configuration conf = new Configuration();
        startDelim = conf.getString("GPKISecureWeb.crypto.startTag");
        endDelim = conf.getString("GPKISecureWeb.crypto.endTag");
    }

    public CryptoTagFinder(GPKIKeyInfo keyinfo) throws ConfigurationException {
        this();
        this.keyinfo = keyinfo;
    }

    public List getDelimStringForEncrypt(String src) throws GPKISecureWEBException {
        ArrayList<String> ret = new ArrayList<String>();
        String srcTmp = src;
        try {
            while (true) {
                if (!this.isEncrypt) {
                    int startIdx = srcTmp.indexOf(startDelim);
                    if (startIdx == -1) {
                        ret.add(srcTmp);
                        break;
                    }
                    this.srcHeadTmp = srcTmp.substring(0, startIdx);
                    srcTmp = srcTmp.substring(startIdx + startDelim.length());
                    this.isEncrypt = true;
                    continue;
                }
                int idx = -1;
                int endIdx = srcTmp.indexOf(endDelim);
                if (endIdx == -1) {
                    this.encBuffer.append(srcTmp);
                    break;
                }
                String srcTmp2 = srcTmp.substring(0, endIdx);
                this.encBuffer.append(srcTmp2);
                this.srcTailTmp = srcTmp.substring(endIdx + 1);
                String encData = this.encrypt(this.encBuffer.toString());
                ret.add(this.srcHeadTmp);
                ret.add(encData);
                this.encBuffer.delete(0, this.encBuffer.length());
                this.srcHeadTmp = "";
                srcTmp = srcTmp.substring(endIdx + endDelim.length());
                this.isEncrypt = false;
            }
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
        return ret;
    }

    private String encrypt(String src) throws GPKISecureWEBException {
        String encData = null;
        EncryptedData enc = null;
        try {
            if (this.keyinfo == null || this.keyinfo.getAlgo() == null || this.keyinfo.getServerKey() == null || this.keyinfo.getServerIV() == null || this.keyinfo.equals("") || this.keyinfo.getAlgo().equals("") || this.keyinfo.getServerIV().equals("") || this.keyinfo.getServerKey().equals("")) {
                throw new GPKISecureWEBException("session key info is null");
            }
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] Algo = " + this.keyinfo.getAlgo());
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] ServerKey = " + Dump.toHexString((byte[])this.keyinfo.getServerKey(), (long)0L, (long)this.keyinfo.getServerKey().length));
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] ServerIV = " + Dump.toHexString((byte[])this.keyinfo.getServerIV(), (long)0L, (long)this.keyinfo.getServerIV().length));
            enc = new EncryptedData();
            if (this.keyinfo == null) {
                throw new GPKISecureWEBException("Server KeyInfo Not Found!");
            }
            enc.setKey(this.keyinfo.getAlgo(), this.keyinfo.getServerKey(), this.keyinfo.getServerIV());
            encData = enc.encrypt(src);
        }
        catch (Exception e) {
            Logger.err.println(this, "[" + Thread.currentThread().getName() + "] CryptoTagFinder = " + Utility.getStackTrace(e));
            throw new GPKISecureWEBException(e);
        }
        return encData;
    }
}

