/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.gpkiapi.cert;

import com.gpki.gpkiapi.cert.X509Certificate;
import com.gpki.gpkiapi.crypto.PrivateKey;
import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi_jni;
import java.util.Calendar;
import java.util.Date;

public class CertPathValidator {
    public static final int CERT_SIGN = 1;
    public static final int CERT_KM = 2;
    public static final int CERT_OCSP = 3;
    public static final int CERT_TSA = 4;
    public static final int CERT_VERIFY_FULL_PATH = 1;
    public static final int CERT_VERIFY_ROOT2CA = 2;
    public static final int CERT_VERIFY_ONLY_USER = 4;
    public static final int REVOKE_CHECK_NONE = 0;
    public static final int REVOKE_CHECK_ARL = 1;
    public static final int REVOKE_CHECK_CRL = 2;
    public static final int REVOKE_CHECK_OCSP = 4;
    public static final int REVOKE_CHECK_ALL = 7;
    private int verifyRange = 0;
    private int revokationCheck = 0;
    private boolean useCache = true;
    private byte[] myCert = null;
    private byte[] myPriKey = null;
    private String passwd = "";
    private String confFilePath = "";
    private String ips = "";
    private String validTime = "";
    private gpkiapi_jni gpkiapi = new gpkiapi_jni();

    public CertPathValidator(String string) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The confFilePath is empty. You must input a value for it.");
        }
        this.confFilePath = string;
        this.verifyRange = gpkiapi_jni.CERT_VERIFY_FULL_PATH;
        this.revokationCheck = gpkiapi_jni.CERT_REV_CHECK_ALL;
        this.useCache = true;
    }

    public CertPathValidator(String string, int n, int n2, boolean bl) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The confFilePath is empty. You must input a value for it.");
        }
        this.confFilePath = string;
        this.useCache = bl;
        this.setVerifyRange(n);
        this.setRevokationCheck(n2);
    }

    public void setVerifyRange(int n) {
        switch (n) {
            case 1: {
                this.verifyRange = gpkiapi_jni.CERT_VERIFY_FULL_PATH;
                break;
            }
            case 2: {
                this.verifyRange = gpkiapi_jni.CERT_VERIFY_CA_CERT;
                break;
            }
            case 4: {
                this.verifyRange = gpkiapi_jni.CERT_VERIFY_USER_CERT;
            }
        }
    }

    public void setRevokationCheck(int n) {
        if (n == 7) {
            this.revokationCheck = gpkiapi_jni.CERT_REV_CHECK_ALL;
        } else if (n == 0) {
            this.revokationCheck = gpkiapi_jni.CERT_REV_CHECK_NONE;
        } else {
            if ((n & 1) != 0) {
                this.revokationCheck |= gpkiapi_jni.CERT_REV_CHECK_ARL;
            }
            if ((n & 2) != 0) {
                this.revokationCheck |= gpkiapi_jni.CERT_REV_CHECK_CRL;
            }
            if ((n & 4) != 0) {
                this.revokationCheck |= gpkiapi_jni.CERT_REV_CHECK_OCSP;
            }
        }
    }

    public void useCache(boolean bl) {
        this.useCache = bl;
    }

    public void setUserPolicySet(String string) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The ips is empty. You must input a value for it.");
        }
        this.ips = string;
    }

    public void addTrustedRootCert(X509Certificate x509Certificate) throws GpkiApiException {
        if (x509Certificate == null) {
            throw new GpkiApiException("The rootCert is empty. You must input a value for it.");
        }
        this.gpkiapi.CERT_AddTrustedCert(x509Certificate.getCert());
    }

    public void setValidationTime(Date date) throws GpkiApiException {
        if (date == null) {
            throw new GpkiApiException("The time is null. You must input a value for it.");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.validTime = this.validTime + calendar.get(1);
        switch (calendar.get(2)) {
            case 0: {
                this.validTime = this.validTime + "01";
                break;
            }
            case 1: {
                this.validTime = this.validTime + "02";
                break;
            }
            case 2: {
                this.validTime = this.validTime + "03";
                break;
            }
            case 3: {
                this.validTime = this.validTime + "04";
                break;
            }
            case 4: {
                this.validTime = this.validTime + "05";
                break;
            }
            case 5: {
                this.validTime = this.validTime + "06";
                break;
            }
            case 6: {
                this.validTime = this.validTime + "07";
                break;
            }
            case 7: {
                this.validTime = this.validTime + "08";
                break;
            }
            case 8: {
                this.validTime = this.validTime + "09";
                break;
            }
            case 9: {
                this.validTime = this.validTime + "10";
                break;
            }
            case 10: {
                this.validTime = this.validTime + "11";
                break;
            }
            case 11: {
                this.validTime = this.validTime + "12";
            }
        }
        int n = calendar.get(5);
        if (n < 10) {
            this.validTime = this.validTime + "0";
        }
        this.validTime = this.validTime + n;
        int n2 = calendar.get(11);
        if (n2 < 10) {
            this.validTime = this.validTime + "0";
        }
        this.validTime = this.validTime + n2;
        int n3 = calendar.get(12);
        if (n3 < 10) {
            this.validTime = this.validTime + "0";
        }
        this.validTime = this.validTime + n3;
        int n4 = calendar.get(13);
        if (n4 < 10) {
            this.validTime = this.validTime + "0";
        }
        this.validTime = this.validTime + n4;
    }

    public void setMyCert(X509Certificate x509Certificate, PrivateKey privateKey) throws GpkiApiException {
        if (x509Certificate == null) {
            throw new GpkiApiException("The cert is empty. You must input a value for it.");
        }
        if (privateKey == null) {
            throw new GpkiApiException("The priKey is empty. You must input a value for it.");
        }
        this.myCert = x509Certificate.getCert();
        this.myPriKey = privateKey.getKey();
    }

    public void validate(int n, X509Certificate x509Certificate) throws GpkiApiException {
        if (x509Certificate == null) {
            throw new GpkiApiException("The cert is hull. You must input a value for it.");
        }
        boolean bl = false;
        if (this.myCert != null && this.myPriKey != null && this.myCert.length > 0 && this.myPriKey.length > 0) {
            bl = true;
        }
        if (this.gpkiapi.CERT_SetVerifyEnv(this.verifyRange, this.revokationCheck, this.useCache, this.validTime, "") > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        if (this.gpkiapi.CERT_Verify(x509Certificate.getCert(), n, this.ips, this.confFilePath, bl, this.myCert, this.myPriKey) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
    }
}

