/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.gpkiapi.cms;

import com.gpki.gpkiapi.cert.X509Certificate;
import com.gpki.gpkiapi.crypto.Algorithm;
import com.gpki.gpkiapi.crypto.PrivateKey;
import com.gpki.gpkiapi.crypto.SecretKey;
import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi_jni;

public class SignedAndEnvelopedData {
    private int algCode = 0;
    private byte[] myCert = null;
    private byte[] myPrikey = null;
    private byte[] outBuff = null;
    private byte[] signerBuff = null;
    private String errBuff = "";
    private gpkiapi_jni gpkiapi = new gpkiapi_jni();

    public SignedAndEnvelopedData() throws GpkiApiException {
        this.algCode = Algorithm.getSecretKeyAlg("SEED");
    }

    public SignedAndEnvelopedData(String string) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The algorithm is empty. You must input a value for it.");
        }
        this.algCode = Algorithm.getSecretKeyAlg(string);
    }

    public void setMyCert(X509Certificate x509Certificate, PrivateKey privateKey) throws GpkiApiException {
        if (x509Certificate == null) {
            throw new GpkiApiException("The cert is empty. You must input a value for it.");
        }
        if (privateKey == null) {
            throw new GpkiApiException("The priKey is empty. You must input a value for it.");
        }
        this.myCert = x509Certificate.getCert();
        this.myPrikey = privateKey.getKey();
    }

    public byte[] generate(X509Certificate x509Certificate, byte[] byArray) throws GpkiApiException {
        if (byArray == null) {
            throw new GpkiApiException("The msg is null. You must input a value for it.");
        }
        if (x509Certificate == null) {
            throw new GpkiApiException("The recCert is empty. You must input a value for it.");
        }
        if (this.gpkiapi.CMS_MakeSignedAndEnvData(this.myCert, this.myPrikey, x509Certificate.getCert(), byArray, Algorithm.code2id(this.algCode)) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        return this.gpkiapi.baReturnArray;
    }

    public byte[] process(byte[] byArray) throws GpkiApiException {
        if (byArray == null) {
            throw new GpkiApiException("The signedAndEnvData is null. You must input a value for it.");
        }
        if (this.gpkiapi.CMS_ProcessSignedAndEnvData(this.myCert, this.myPrikey, byArray) > 0) {
            throw new GpkiApiException(this.errBuff);
        }
        this.signerBuff = this.gpkiapi.baSignerCert;
        return this.gpkiapi.baData;
    }

    public X509Certificate getSignerCert() throws GpkiApiException {
        X509Certificate x509Certificate = new X509Certificate(this.signerBuff);
        return x509Certificate;
    }

    public SecretKey getSecretKey() throws GpkiApiException {
        String string = "";
        if (this.gpkiapi.nSymAlg == gpkiapi_jni.SYM_ALG_SEED_CBC) {
            string = "SEED";
        } else if (this.gpkiapi.nSymAlg == gpkiapi_jni.SYM_ALG_DES_CBC) {
            string = "DES";
        } else if (this.gpkiapi.nSymAlg == gpkiapi_jni.SYM_ALG_3DES_CBC) {
            string = "3DES";
        } else if (this.gpkiapi.nSymAlg == gpkiapi_jni.SYM_ALG_NEAT_CBC) {
            string = "NEAT";
        } else if (this.gpkiapi.nSymAlg == gpkiapi_jni.SYM_ALG_ARIA_CBC) {
            string = "ARIA";
        } else if (this.gpkiapi.nSymAlg == gpkiapi_jni.SYM_ALG_NES_CBC) {
            string = "NES";
        } else {
            throw new GpkiApiException("Unknown secret algorithm(" + this.gpkiapi.nSymAlg + ")");
        }
        SecretKey secretKey = new SecretKey(string, this.gpkiapi.baKey, this.gpkiapi.baIV);
        return secretKey;
    }

    private native int _generate(int var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, int var6);

    private native int _process(int var1, byte[] var2, byte[] var3, byte[] var4);
}

