/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.gpkiapi.cms;

import com.gpki.gpkiapi.cert.X509Certificate;
import com.gpki.gpkiapi.crypto.Algorithm;
import com.gpki.gpkiapi.crypto.PrivateKey;
import com.gpki.gpkiapi.crypto.SecretKey;
import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi_jni;

public class WapEnvelopedData {
    private int algCode = 0;
    private String errBuff = "";
    private byte[] outBuff = null;
    private byte[] myCert = null;
    private byte[] myPriKey = null;
    private gpkiapi_jni gpkiapi = new gpkiapi_jni();

    public WapEnvelopedData() throws GpkiApiException {
        this.algCode = Algorithm.getSecretKeyAlg("SEED");
    }

    public WapEnvelopedData(String string) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The algorithm is empty. You must input a value for it.");
        }
        this.algCode = Algorithm.getSecretKeyAlg(string);
    }

    public void setMyCert(X509Certificate x509Certificate, PrivateKey privateKey) throws GpkiApiException {
        if (x509Certificate == null) {
            throw new GpkiApiException("The cert is empty. You must input a value for it.");
        }
        if (privateKey == null) {
            throw new GpkiApiException("The prikey is empty. You must input a value for it.");
        }
        this.myCert = x509Certificate.getCert();
        this.myPriKey = privateKey.getKey();
    }

    public byte[] generate(byte[] byArray, X509Certificate x509Certificate) throws GpkiApiException {
        if (byArray == null) {
            throw new GpkiApiException("The msg is null. You must input a value for it.");
        }
        if (x509Certificate == null) {
            throw new GpkiApiException("The recipientCert is empty. You must input a value for it.");
        }
        if (this.gpkiapi.WCMS_MakeWapEnvelopedData(x509Certificate.getCert(), byArray, Algorithm.code2id(this.algCode)) > 0) {
            throw new GpkiApiException(this.gpkiapi.sReturnString);
        }
        return this.gpkiapi.baReturnArray;
    }

    public byte[] process(byte[] byArray) throws GpkiApiException {
        if (byArray == null || byArray.length == 0) {
            throw new GpkiApiException("The recipientCert is empty. You must input a value for it.");
        }
        if (this.gpkiapi.WCMS_ProcessWapEnvelopedData(this.myCert, this.myPriKey, byArray) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        return this.gpkiapi.baReturnArray;
    }

    public SecretKey getSecretKey() throws GpkiApiException {
        String string = "";
        if (this.gpkiapi.nSymAlg == gpkiapi_jni.SYM_ALG_SEED_CBC) {
            string = "SEED";
        } else if (this.gpkiapi.nSymAlg == gpkiapi_jni.SYM_ALG_DES_CBC) {
            string = "DES";
        } else if (this.gpkiapi.nSymAlg == gpkiapi_jni.SYM_ALG_3DES_CBC) {
            string = "3DES";
        } else if (this.gpkiapi.nSymAlg == gpkiapi_jni.SYM_ALG_NEAT_CBC) {
            string = "NEAT";
        } else if (this.gpkiapi.nSymAlg == gpkiapi_jni.SYM_ALG_ARIA_CBC) {
            string = "ARIA";
        } else if (this.gpkiapi.nSymAlg == gpkiapi_jni.SYM_ALG_NES_CBC) {
            string = "NES";
        } else {
            throw new GpkiApiException("Unknown secret algorithm(" + this.gpkiapi.nSymAlg + ")");
        }
        SecretKey secretKey = new SecretKey(string, this.gpkiapi.baKey, this.gpkiapi.baIV);
        return secretKey;
    }
}

