/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.gpkiapi.crypto;

import com.gpki.gpkiapi.crypto.Algorithm;
import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi_jni;

public class Mac {
    private int algCode = 0;
    private String macKey = null;
    private byte[] outBuff = null;
    private gpkiapi_jni gpkiapi = new gpkiapi_jni();

    protected Mac() {
    }

    public static final Mac getInstance(String string) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The algorithm is empty. You must input a value for it.");
        }
        Mac mac = new Mac();
        mac.algCode = Algorithm.getMacAlg(string);
        if (mac.algCode == 0) {
            throw new GpkiApiException("Unknown algorithm. (input :" + string + ")");
        }
        return mac;
    }

    public final void init(String string) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The key is empty. You must input a value for it.");
        }
        this.macKey = string;
    }

    public final byte[] generate(byte[] byArray) throws GpkiApiException {
        if (byArray == null) {
            throw new GpkiApiException("The data is empty. You must input a value for it.");
        }
        if (this.gpkiapi.CRYPT_GenMAC(Algorithm.code2id(this.algCode), this.macKey, byArray) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        return this.gpkiapi.baReturnArray;
    }

    public final void verify(byte[] byArray, byte[] byArray2) throws GpkiApiException {
        if (byArray == null) {
            throw new GpkiApiException("The data is empty. You must input a value for it.");
        }
        if (byArray2 == null) {
            throw new GpkiApiException("The mac is empty. You must input a value for it.");
        }
        if (this.gpkiapi.CRYPT_VerifyMAC(Algorithm.code2id(this.algCode), this.macKey, byArray, byArray2) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
    }
}

