/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.gpkiapi.crypto;

import com.gpki.gpkiapi.crypto.Algorithm;
import com.gpki.gpkiapi.crypto.PrivateKey;
import com.gpki.gpkiapi.crypto.PublicKey;
import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi_jni;

public class Signature {
    private byte[] outBuff = null;
    private String errBuff = "";
    private byte[] privateKey = null;
    private byte[] publicKey = null;
    private int hashAlg = 0;
    private gpkiapi_jni gpkiapi = new gpkiapi_jni();

    private void initObject() {
        this.privateKey = null;
        this.publicKey = null;
        this.hashAlg = 0;
    }

    public final void initSign(PrivateKey privateKey, String string) throws GpkiApiException {
        this.initObject();
        if (privateKey == null) {
            throw new GpkiApiException("The priKey is empty. You must input a value for it.");
        }
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The msgDigestAlg is empty. You must input a value for it.");
        }
        this.hashAlg = Algorithm.getHashAlg(string);
        if (this.hashAlg == 0) {
            throw new GpkiApiException("Unknown algorithm. (input :" + this.hashAlg + ")");
        }
        this.privateKey = privateKey.getKey();
    }

    public final void initSign(PrivateKey privateKey, PublicKey publicKey, String string) throws GpkiApiException {
        this.initObject();
        if (privateKey == null) {
            throw new GpkiApiException("The priKey is empty. You must input a value for it.");
        }
        if (publicKey == null) {
            throw new GpkiApiException("The pubKey is empty. You must input a value for it.");
        }
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The msgDigestAlg is empty. You must input a value for it.");
        }
        this.hashAlg = Algorithm.getHashAlg(string);
        if (this.hashAlg == 0) {
            throw new GpkiApiException("Unknown algorithm. (input :" + this.hashAlg + ")");
        }
        this.privateKey = privateKey.getKey();
        this.publicKey = publicKey.getKey();
    }

    public final void initVerify(PublicKey publicKey, String string) throws GpkiApiException {
        this.initObject();
        if (publicKey == null) {
            throw new GpkiApiException("The pubKey is empty. You must input a value for it.");
        }
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The msgDigestAlg is empty. You must input a value for it.");
        }
        this.hashAlg = Algorithm.getHashAlg(string);
        if (this.hashAlg == 0) {
            throw new GpkiApiException("Unknown algorithm. (input :" + this.hashAlg + ")");
        }
        this.publicKey = publicKey.getKey();
    }

    public final byte[] sign(byte[] byArray) throws GpkiApiException {
        if (byArray == null) {
            throw new GpkiApiException("The data is null. You must input a value for it.");
        }
        if (this._sign(Algorithm.code2id(this.hashAlg), this.privateKey, this.publicKey, byArray) > 0) {
            throw new GpkiApiException(this.errBuff);
        }
        return this.outBuff;
    }

    public final void verify(byte[] byArray, byte[] byArray2) throws GpkiApiException {
        if (byArray == null) {
            throw new GpkiApiException("The data is null. You must input a value for it.");
        }
        if (byArray2 == null || byArray2.length == 0) {
            throw new GpkiApiException("The signature is empty. You must input a value for it.");
        }
        if (this._verify(Algorithm.code2id(this.hashAlg), this.publicKey, byArray, byArray2) > 0) {
            throw new GpkiApiException(this.errBuff);
        }
    }

    private native int _sign(int var1, byte[] var2, byte[] var3, byte[] var4);

    private native int _verify(int var1, byte[] var2, byte[] var3, byte[] var4);
}

