/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.gpkiapi.tsa;

import com.gpki.gpkiapi.cert.X509Certificate;
import com.gpki.gpkiapi.crypto.Algorithm;
import com.gpki.gpkiapi.crypto.PrivateKey;
import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi.tsa.TimeStampToken;
import com.gpki.gpkiapi_jni;

public class TimeStamp {
    private String errBuff = "";
    private byte[] outBuff = null;
    private int hashAlg = 0;
    private String policy = "";
    private byte[] message = null;
    private byte[] myCert = null;
    private byte[] myPriKey = null;
    private gpkiapi_jni gpkiapi = new gpkiapi_jni();

    public TimeStamp() throws GpkiApiException {
        this.hashAlg = Algorithm.getHashAlg("SHA1");
    }

    public TimeStamp(String string) throws GpkiApiException {
        this.hashAlg = Algorithm.getHashAlg(string);
    }

    public void setMessage(byte[] byArray) throws GpkiApiException {
        if (byArray == null) {
            throw new GpkiApiException("The cert is empty. You must input a value for it.");
        }
        this.message = byArray;
    }

    public void setPolicy(String string) {
        this.policy = string;
    }

    public void setMyCert(X509Certificate x509Certificate, PrivateKey privateKey) throws GpkiApiException {
        if (x509Certificate == null) {
            throw new GpkiApiException("The cert is empty. You must input a value for it.");
        }
        if (privateKey == null) {
            throw new GpkiApiException("The priKey is empty. You must input a value for it.");
        }
        this.myCert = x509Certificate.getCert();
        this.myPriKey = privateKey.getKey();
    }

    public TimeStampToken reqTimeStampToken(String string, int n) throws GpkiApiException {
        if (string.length() == 0) {
            throw new GpkiApiException("The ip is empty. You must input a value for it.");
        }
        if (n == 0) {
            throw new GpkiApiException("The port is empty. You must input a value for it.");
        }
        boolean bl = false;
        if (this.myCert != null && this.myCert.length != 0 && this.myPriKey != null && this.myPriKey.length != 0) {
            bl = true;
        }
        if (this.gpkiapi.TSP_GetToken(this.message, Algorithm.code2id(this.hashAlg), this.policy, bl, this.myCert, this.myPriKey, string, n) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        TimeStampToken timeStampToken = new TimeStampToken(this.gpkiapi.baToken);
        return timeStampToken;
    }
}

