/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.gpkiapi.tsa;

import com.gpki.gpkiapi.cert.X509Certificate;
import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi_jni;
import java.math.BigInteger;
import java.util.Date;

public class TimeStampToken {
    private String errBuff = "";
    private String cnBuff = "";
    private String dnBuff = "";
    private String policyBuff = "";
    private String hashAlgBuff = "";
    private long genTimeBuff = 0L;
    private long genTime_microBuff = 0L;
    private byte[] serialNumBuff = null;
    private byte[] nonceBuff = null;
    private byte[] msgImprintBuff = null;
    private byte[] timeStampToken = null;
    private byte[] tsaCertBuff = null;
    private gpkiapi_jni gpkiapi = new gpkiapi_jni();

    public TimeStampToken(byte[] byArray) throws GpkiApiException {
        if (byArray == null || byArray.length == 0) {
            throw new GpkiApiException("The tst is empty. You must input a value for it.");
        }
        this.timeStampToken = byArray;
        if (this._getInfo(byArray) > 0) {
            throw new GpkiApiException(this.errBuff);
        }
    }

    public void verify(byte[] byArray) throws GpkiApiException {
        if (this.gpkiapi.TSP_VerifyToken(byArray, this.timeStampToken) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
    }

    public byte[] getTimeStampToken() {
        return this.timeStampToken;
    }

    public String getPolicy() {
        return this.policyBuff;
    }

    public String getHashAlgorithm() {
        return this.hashAlgBuff;
    }

    public byte[] getMessageImprint() {
        return this.msgImprintBuff;
    }

    public BigInteger getSerialNumber() {
        BigInteger bigInteger = new BigInteger(this.serialNumBuff);
        return bigInteger;
    }

    public Date getGeneratedTime() {
        Date date = new Date(this.genTimeBuff * 1000L);
        return date;
    }

    public byte[] getNonce() {
        return this.nonceBuff;
    }

    public X509Certificate getTSACert() throws GpkiApiException {
        if (this.tsaCertBuff == null) {
            throw new GpkiApiException("The TSACert does not exist. first, request TimeStampToken");
        }
        X509Certificate x509Certificate = new X509Certificate(this.tsaCertBuff);
        return x509Certificate;
    }

    private native int _getInfo(byte[] var1);
}

