/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.aspectj.apache.bcel.classfile.ClassParser;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.util.ClassLoaderReference;
import org.aspectj.apache.bcel.util.DefaultClassLoaderReference;
import org.aspectj.apache.bcel.util.Repository;

public class NonCachingClassLoaderRepository
implements Repository {
    private static ClassLoader bootClassLoader = null;
    private ClassLoaderReference loaderRef;
    private Map loadedClasses = new SoftHashMap();

    public NonCachingClassLoaderRepository(ClassLoader loader) {
        this.loaderRef = new DefaultClassLoaderReference(loader != null ? loader : NonCachingClassLoaderRepository.getBootClassLoader());
    }

    public NonCachingClassLoaderRepository(ClassLoaderReference loaderRef) {
        this.loaderRef = loaderRef;
    }

    private static synchronized ClassLoader getBootClassLoader() {
        if (bootClassLoader == null) {
            bootClassLoader = new URLClassLoader(new URL[0]);
        }
        return bootClassLoader;
    }

    public void storeClass(JavaClass clazz) {
        this.loadedClasses.put(clazz.getClassName(), clazz);
        clazz.setRepository(this);
    }

    public void removeClass(JavaClass clazz) {
        this.loadedClasses.remove(clazz.getClassName());
    }

    public JavaClass findClass(String className) {
        if (this.loadedClasses.containsKey(className)) {
            return (JavaClass)this.loadedClasses.get(className);
        }
        return null;
    }

    public JavaClass loadClass(String className) throws ClassNotFoundException {
        String classFile = className.replace('.', '/');
        JavaClass RC = this.findClass(className);
        if (RC != null) {
            return RC;
        }
        try {
            InputStream is = this.loaderRef.getClassLoader().getResourceAsStream(String.valueOf(classFile) + ".class");
            if (is == null) {
                throw new ClassNotFoundException(String.valueOf(className) + " not found.");
            }
            ClassParser parser = new ClassParser(is, className);
            RC = parser.parse();
            this.storeClass(RC);
            return RC;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(e.toString());
        }
    }

    public JavaClass loadClass(Class clazz) throws ClassNotFoundException {
        return this.loadClass(clazz.getName());
    }

    public void clear() {
        this.loadedClasses.clear();
    }

    public static class SoftHashMap
    extends AbstractMap {
        private Map map;
        private ReferenceQueue rq = new ReferenceQueue();

        public SoftHashMap(Map map) {
            this.map = map;
        }

        public SoftHashMap() {
            this(new HashMap());
        }

        public SoftHashMap(Map map, boolean b) {
            this(map);
        }

        private void processQueue() {
            SpecialValue sv = null;
            while ((sv = (SpecialValue)this.rq.poll()) != null) {
                this.map.remove(sv.key);
            }
        }

        public Object get(Object key) {
            SpecialValue value = (SpecialValue)this.map.get(key);
            if (value == null) {
                return null;
            }
            if (value.get() == null) {
                this.map.remove(value.key);
                return null;
            }
            return value.get();
        }

        public Object put(Object k, Object v) {
            this.processQueue();
            return this.map.put(k, new SpecialValue(k, v));
        }

        public Set entrySet() {
            return this.map.entrySet();
        }

        public void clear() {
            this.processQueue();
            Set keys = this.map.keySet();
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                Object name = iterator.next();
                this.map.remove(name);
            }
        }

        public int size() {
            this.processQueue();
            return this.map.size();
        }

        public Object remove(Object k) {
            this.processQueue();
            SpecialValue value = (SpecialValue)this.map.remove(k);
            if (value == null) {
                return null;
            }
            if (value.get() != null) {
                return value.get();
            }
            return null;
        }

        class SpecialValue
        extends SoftReference {
            private final Object key;

            SpecialValue(Object k, Object v) {
                super(v, SoftHashMap.this.rq);
                this.key = k;
            }
        }
    }
}

