/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.xpath.XPathConstants;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.helpers.XPathUtils;
import org.apache.cxf.interceptor.ClientFaultConverter;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.staxutils.FragmentStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Soap12FaultInInterceptor
extends AbstractSoapInterceptor {
    public Soap12FaultInInterceptor() {
        super("unmarshal");
        this.addBefore(ClientFaultConverter.class.getName());
    }

    public void handleMessage(SoapMessage message) throws Fault {
        Object fault;
        String exMessage = null;
        QName faultCode = null;
        QName subCode = null;
        String role = null;
        String node = null;
        Element detail = null;
        XMLStreamReader reader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("s", "http://www.w3.org/2003/05/soap-envelope");
        XPathUtils xu = new XPathUtils(ns);
        try {
            fault = StaxUtils.read((XMLStreamReader)new FragmentStreamReader(reader));
            String faultCodeString = (String)xu.getValue("//s:Fault/s:Code/s:Value/text()", (Node)fault, XPathConstants.STRING);
            faultCode = XMLUtils.getQName((String)faultCodeString, (Node)fault);
            String subCodeString = (String)xu.getValue("//s:Fault/s:Code/s:Subcode/s:Value/text()", (Node)fault, XPathConstants.STRING);
            if (StringUtils.isEmpty((String)subCodeString)) {
                subCode = XMLUtils.getQName((String)subCodeString, (Node)fault);
            }
            exMessage = (String)xu.getValue("//s:Fault/s:Reason/s:Text/text()", (Node)fault, XPathConstants.STRING);
            Node detailNode = (Node)xu.getValue("//s:Fault/s:Detail", (Node)fault, XPathConstants.NODE);
            if (detailNode != null) {
                detail = (Element)detailNode;
            }
            role = (String)xu.getValue("//s:Fault/s:Role/text()", (Node)fault, XPathConstants.STRING);
            node = (String)xu.getValue("//s:Fault/s:Node/text()", (Node)fault, XPathConstants.STRING);
        }
        catch (XMLStreamException e) {
            throw new SoapFault("Could not parse message.", message.getVersion().getSender());
        }
        fault = new SoapFault(exMessage, faultCode);
        ((SoapFault)((Object)fault)).setSubCode(subCode);
        fault.setDetail(detail);
        ((SoapFault)((Object)fault)).setRole(role);
        ((SoapFault)((Object)fault)).setNode(node);
        message.setContent(Exception.class, fault);
    }
}

