/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.ArchiveFileSet;
import org.apache.tools.ant.types.ArchiveScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipScanner;

public class ZipFileSet
extends ArchiveFileSet {
    private String encoding = null;

    public ZipFileSet() {
    }

    protected ZipFileSet(FileSet fileset) {
        super(fileset);
    }

    protected ZipFileSet(ZipFileSet fileset) {
        super(fileset);
        this.encoding = fileset.encoding;
    }

    public void setEncoding(String enc) {
        this.checkZipFileSetAttributesAllowed();
        this.encoding = enc;
    }

    public String getEncoding() {
        if (this.isReference()) {
            AbstractFileSet ref = this.getRef(this.getProject());
            if (ref instanceof ZipFileSet) {
                return ((ZipFileSet)ref).getEncoding();
            }
            return null;
        }
        return this.encoding;
    }

    protected ArchiveScanner newArchiveScanner() {
        ZipScanner zs = new ZipScanner();
        zs.setEncoding(this.encoding);
        return zs;
    }

    protected AbstractFileSet getRef(Project p) {
        this.dieOnCircularReference(p);
        Object o = this.getRefid().getReferencedObject(p);
        if (o instanceof ZipFileSet) {
            return (AbstractFileSet)o;
        }
        if (o instanceof FileSet) {
            ZipFileSet zfs = new ZipFileSet((FileSet)o);
            this.configureFileSet(zfs);
            return zfs;
        }
        String msg = this.getRefid().getRefId() + " doesn't denote a zipfileset or a fileset";
        throw new BuildException(msg);
    }

    public Object clone() {
        if (this.isReference()) {
            return ((ZipFileSet)this.getRef(this.getProject())).clone();
        }
        return super.clone();
    }

    private void checkZipFileSetAttributesAllowed() {
        if (this.getProject() == null || this.isReference() && this.getRefid().getReferencedObject(this.getProject()) instanceof ZipFileSet) {
            this.checkAttributesAllowed();
        }
    }
}

