/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.spring;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.aegis.AegisBindingProvider;
import org.codehaus.xfire.service.Binding;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceFactory;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.service.invoker.BeanInvoker;
import org.codehaus.xfire.service.invoker.Invoker;
import org.codehaus.xfire.soap.Soap11Binding;
import org.codehaus.xfire.spring.SpringUtils;
import org.codehaus.xfire.spring.config.AbstractSoapBindingBean;
import org.codehaus.xfire.spring.config.EndpointBean;
import org.codehaus.xfire.spring.config.Soap11BindingBean;
import org.codehaus.xfire.spring.config.Soap12BindingBean;
import org.codehaus.xfire.spring.config.SpringServiceConfiguration;
import org.codehaus.xfire.wsdl.ResourceWSDL;
import org.codehaus.xfire.wsdl.WSDLWriter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ServiceBean
implements InitializingBean,
ApplicationContextAware {
    private static final Log logger = LogFactory.getLog((Class)ServiceBean.class);
    private Service xfireService;
    private ServiceFactory serviceFactory;
    protected XFire xFire;
    private String name;
    private String namespace;
    private Class serviceInterface;
    private Object service;
    private List bindings;
    private List inHandlers;
    private List outHandlers;
    private List faultHandlers;
    private List schemas;
    protected Class implementationClass;
    private Map properties = new HashMap();
    private String wsdlURL;
    private List operations;
    protected boolean createDefaultBindings = true;
    protected String use;
    protected String style;
    private String scope;
    private Invoker invoker;
    private Object executor;

    public void afterPropertiesSet() throws Exception {
        if (this.serviceFactory == null) {
            this.serviceFactory = new ObjectServiceFactory(this.xFire.getTransportManager(), (BindingProvider)new AegisBindingProvider());
        }
        ObjectServiceFactory osf = (ObjectServiceFactory)this.serviceFactory;
        SpringServiceConfiguration springConfig = new SpringServiceConfiguration();
        springConfig.setMethods(this.operations);
        osf.getServiceConfigurations().add(0, springConfig);
        Class<?> intf = this.getServiceClass();
        if (intf == null) {
            if (this.getServiceBean() == null) {
                throw new RuntimeException("Error creating service " + this.name + ". The service class or the service bean must be set!");
            }
            intf = SpringUtils.getUserTarget(this.getServiceBean()).getClass();
        }
        if (this.createDefaultBindings) {
            this.properties.put("objectServiceFactory.createDefaultBindings", Boolean.TRUE);
        } else {
            this.properties.put("objectServiceFactory.createDefaultBindings", Boolean.FALSE);
        }
        if (this.style != null) {
            this.properties.put("objectServiceFactory.style", this.style);
        }
        if (this.use != null) {
            this.properties.put("objectServiceFactory.use", this.use);
        }
        if (this.scope != null) {
            this.properties.put("objectServiceFactory.scope", this.scope);
        }
        if (this.implementationClass != null) {
            this.properties.put("xfire.serviceImplClass", this.implementationClass);
        }
        if (this.schemas != null) {
            this.properties.put("objectServiceFactory.schemas", this.schemas);
        }
        this.xfireService = this.serviceFactory.create(intf, this.name, this.namespace, this.properties);
        this.xfireService.setExecutor(this.executor);
        osf.getServiceConfigurations().remove((Object)springConfig);
        if (this.bindings != null && this.serviceFactory instanceof ObjectServiceFactory) {
            this.initializeBindings();
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Exposing service with name " + this.xfireService.getName()));
        }
        if (this.invoker != null) {
            this.xfireService.setInvoker(this.invoker);
        } else {
            Object serviceBean = this.getProxyForService();
            if (serviceBean != null) {
                this.xfireService.setInvoker((Invoker)new BeanInvoker(serviceBean));
            }
        }
        if (this.xfireService.getInHandlers() == null) {
            this.xfireService.setInHandlers(this.getInHandlers());
        } else if (this.getInHandlers() != null) {
            this.xfireService.getInHandlers().addAll(this.getInHandlers());
        }
        if (this.xfireService.getOutHandlers() == null) {
            this.xfireService.setOutHandlers(this.getOutHandlers());
        } else if (this.getOutHandlers() != null) {
            this.xfireService.getOutHandlers().addAll(this.getOutHandlers());
        }
        if (this.xfireService.getFaultHandlers() == null) {
            this.xfireService.setFaultHandlers(this.getFaultHandlers());
        } else if (this.getFaultHandlers() != null) {
            this.xfireService.getFaultHandlers().addAll(this.getFaultHandlers());
        }
        if (this.wsdlURL != null) {
            this.xfireService.setWSDLWriter((WSDLWriter)new ResourceWSDL(this.wsdlURL));
        }
        this.xFire.getServiceRegistry().register(this.xfireService);
    }

    protected void initializeBindings() throws Exception {
        ObjectServiceFactory osf = (ObjectServiceFactory)this.serviceFactory;
        Iterator itr = this.bindings.iterator();
        while (itr.hasNext()) {
            AbstractSoapBindingBean o = (AbstractSoapBindingBean)itr.next();
            Soap11Binding binding = null;
            if (o instanceof Soap11BindingBean) {
                binding = osf.createSoap11Binding(this.xfireService, o.getName(), o.getTransport());
            } else if (o instanceof Soap12BindingBean) {
                binding = osf.createSoap12Binding(this.xfireService, o.getName(), o.getTransport());
            }
            binding.setUndefinedEndpointAllowed(o.isAllowUndefinedEndpoints());
            if (o.getEndpoints() == null) continue;
            Iterator eitr = o.getEndpoints().iterator();
            while (eitr.hasNext()) {
                EndpointBean ep = (EndpointBean)eitr.next();
                osf.createEndpoint(this.xfireService, ep.getName(), ep.getUrl(), (Binding)binding);
            }
        }
    }

    protected Object getProxyForService() {
        return this.getServiceBean();
    }

    public Service getXFireService() {
        return this.xfireService;
    }

    public Object getServiceBean() {
        return this.service;
    }

    public void setServiceBean(Object service) {
        this.service = service;
    }

    public Class getServiceClass() {
        return this.serviceInterface;
    }

    public void setServiceClass(Class serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public void setServiceFactory(ServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    public ServiceFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public List getFaultHandlers() {
        return this.faultHandlers;
    }

    public void setFaultHandlers(List faultHandlers) {
        this.faultHandlers = faultHandlers;
    }

    public List getInHandlers() {
        return this.inHandlers;
    }

    public void setInHandlers(List inHandlers) {
        this.inHandlers = inHandlers;
    }

    public List getOutHandlers() {
        return this.outHandlers;
    }

    public void setOutHandlers(List outHandlers) {
        this.outHandlers = outHandlers;
    }

    public void setXfire(XFire xFire) {
        this.xFire = xFire;
    }

    public XFire getXfire() {
        return this.xFire;
    }

    public Class getImplementationClass() {
        return this.implementationClass;
    }

    public void setImplementationClass(Class implementationClass) {
        this.implementationClass = implementationClass;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getUse() {
        return this.use;
    }

    public void setUse(String use) {
        this.use = use;
    }

    public List getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List schemas) {
        this.schemas = schemas;
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        if (this.xFire == null) {
            this.xFire = (XFire)ctx.getBean("xfire");
        }
        if (this.serviceFactory == null) {
            this.serviceFactory = (ServiceFactory)ctx.getBean("xfire.serviceFactory");
        }
    }

    public List getBindings() {
        return this.bindings;
    }

    public void setBindings(List bindings) {
        this.bindings = bindings;
    }

    public Invoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public boolean isCreateDefaultBindings() {
        return this.createDefaultBindings;
    }

    public Object getExecutor() {
        return this.executor;
    }

    public void setExecutor(Object executor) {
        this.executor = executor;
    }

    public void setCreateDefaultBindings(boolean createDefaultBindings) {
        this.createDefaultBindings = createDefaultBindings;
    }

    public String getWsdlURL() {
        return this.wsdlURL;
    }

    public void setWsdlURL(String wsdlURL) {
        this.wsdlURL = wsdlURL;
    }

    public List getMethods() {
        return this.operations;
    }

    public void setMethods(List operations) {
        this.operations = operations;
    }
}

