/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.cvpl.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class EgovHsqlFunction {
    public static final String DATE_FORMAT = "yyyyMMdd";
    public static final String TIMESTAMP_FORMAT = "yyyyMMddHHmmss";
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMdd", Locale.KOREA);
    private static final SimpleDateFormat timestampFormatter = new SimpleDateFormat("yyyyMMddHHmmss", Locale.KOREA);

    public static Date directDate(String str) throws ParseException {
        return EgovHsqlFunction.to_date(str, DATE_FORMAT);
    }

    public static Date to_date(String str, String format) throws ParseException {
        if (str == null || "".equals(str)) {
            return null;
        }
        if (DATE_FORMAT.equals(format)) {
            return dateFormatter.parse(str);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.KOREA);
        return sdf.parse(str);
    }

    public static Timestamp directTimestamp(String str) throws ParseException {
        return EgovHsqlFunction.to_timestamp(str, TIMESTAMP_FORMAT);
    }

    public static Timestamp to_timestamp(String str, String format) throws ParseException {
        if (str == null || "".equals(str)) {
            return null;
        }
        if (TIMESTAMP_FORMAT.equals(format)) {
            return new Timestamp(timestampFormatter.parse(str).getTime());
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.KOREA);
        return new Timestamp(sdf.parse(str).getTime());
    }

    public static String directDateToChar(Date date) throws ParseException {
        return EgovHsqlFunction.to_char(date, DATE_FORMAT);
    }

    public static String to_char(Date date, String format) {
        if (date == null) {
            return null;
        }
        if (DATE_FORMAT.equals(format)) {
            return dateFormatter.format(date);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static String directTimestampToChar(Timestamp timestamp) {
        return EgovHsqlFunction.to_char(timestamp, TIMESTAMP_FORMAT);
    }

    public static String to_char(Timestamp timestamp, String format) {
        if (timestamp == null) {
            return null;
        }
        if (TIMESTAMP_FORMAT.equals(format)) {
            return timestampFormatter.format(timestamp);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(timestamp);
    }
}

