/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WeakReferenceMonitor {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$util$WeakReferenceMonitor == null ? (class$org$springframework$util$WeakReferenceMonitor = WeakReferenceMonitor.class$("org.springframework.util.WeakReferenceMonitor")) : class$org$springframework$util$WeakReferenceMonitor));
    private static final ReferenceQueue handleQueue = new ReferenceQueue();
    private static final Map trackedEntries = Collections.synchronizedMap(new HashMap());
    private static Thread monitoringThread = null;
    static /* synthetic */ Class class$org$springframework$util$WeakReferenceMonitor;

    public static void monitor(Object handle, ReleaseListener listener) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Monitoring handle [" + handle + "] with release listener [" + listener + "]"));
        }
        WeakReference<Object> weakRef = new WeakReference<Object>(handle, handleQueue);
        WeakReferenceMonitor.addEntry(weakRef, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addEntry(Reference ref, ReleaseListener entry) {
        trackedEntries.put(ref, entry);
        Class clazz = class$org$springframework$util$WeakReferenceMonitor == null ? (class$org$springframework$util$WeakReferenceMonitor = WeakReferenceMonitor.class$("org.springframework.util.WeakReferenceMonitor")) : class$org$springframework$util$WeakReferenceMonitor;
        synchronized (clazz) {
            if (!WeakReferenceMonitor.isMonitoringThreadRunning()) {
                monitoringThread = new Thread((Runnable)new MonitoringProcess(), (class$org$springframework$util$WeakReferenceMonitor == null ? (class$org$springframework$util$WeakReferenceMonitor = WeakReferenceMonitor.class$("org.springframework.util.WeakReferenceMonitor")) : class$org$springframework$util$WeakReferenceMonitor).getName());
                monitoringThread.start();
            }
        }
    }

    private static ReleaseListener removeEntry(Reference reference) {
        return (ReleaseListener)trackedEntries.remove(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isMonitoringThreadRunning() {
        Class clazz = class$org$springframework$util$WeakReferenceMonitor == null ? (class$org$springframework$util$WeakReferenceMonitor = WeakReferenceMonitor.class$("org.springframework.util.WeakReferenceMonitor")) : class$org$springframework$util$WeakReferenceMonitor;
        synchronized (clazz) {
            return monitoringThread != null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface ReleaseListener {
        public void released();
    }

    private static class MonitoringProcess
    implements Runnable {
        private MonitoringProcess() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            logger.debug((Object)"Starting reference monitor thread");
            try {
                while (!trackedEntries.isEmpty()) {
                    try {
                        Reference reference = handleQueue.remove();
                        ReleaseListener entry = WeakReferenceMonitor.removeEntry(reference);
                        if (entry == null) continue;
                        entry.released();
                    }
                    catch (InterruptedException ex) {
                        logger.debug((Object)"Reference monitor thread interrupted", (Throwable)ex);
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                logger.debug((Object)"Stopping reference monitor thread");
                Class clazz = class$org$springframework$util$WeakReferenceMonitor == null ? (class$org$springframework$util$WeakReferenceMonitor = WeakReferenceMonitor.class$("org.springframework.util.WeakReferenceMonitor")) : class$org$springframework$util$WeakReferenceMonitor;
                synchronized (clazz) {
                    monitoringThread = null;
                    throw throwable;
                }
            }
            logger.debug((Object)"Stopping reference monitor thread");
            Class clazz = class$org$springframework$util$WeakReferenceMonitor == null ? (class$org$springframework$util$WeakReferenceMonitor = WeakReferenceMonitor.class$("org.springframework.util.WeakReferenceMonitor")) : class$org$springframework$util$WeakReferenceMonitor;
            synchronized (clazz) {
                monitoringThread = null;
                return;
            }
        }
    }
}

