/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.database.AmbiguousTableNameException;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableIterator;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.OrderedTableNameMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger((Class)DefaultDataSet.class);
    private final OrderedTableNameMap _tableMap = super.createTableNameMap();

    public DefaultDataSet() {
    }

    public DefaultDataSet(boolean caseSensitiveTableNames) {
        super(caseSensitiveTableNames);
    }

    public DefaultDataSet(ITable table) throws AmbiguousTableNameException {
        this(new ITable[]{table});
    }

    public DefaultDataSet(ITable table1, ITable table2) throws AmbiguousTableNameException {
        this(new ITable[]{table1, table2});
    }

    public DefaultDataSet(ITable[] tables) throws AmbiguousTableNameException {
        this(tables, false);
    }

    public DefaultDataSet(ITable[] tables, boolean caseSensitiveTableNames) throws AmbiguousTableNameException {
        super(caseSensitiveTableNames);
        for (int i = 0; i < tables.length; ++i) {
            this.addTable(tables[i]);
        }
    }

    public void addTable(ITable table) throws AmbiguousTableNameException {
        logger.debug("addTable(table={}) - start", (Object)table);
        this._tableMap.add(table.getTableMetaData().getTableName(), table);
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        logger.debug("createIterator(reversed={}) - start", (Object)Boolean.toString(reversed));
        ITable[] tables = this._tableMap.orderedValues().toArray(new ITable[0]);
        return new DefaultTableIterator(tables, reversed);
    }
}

