/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.mysql;

import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.DataTypeException;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlDataTypeFactory
extends DefaultDataTypeFactory {
    public static final String UNSIGNED_SUFFIX = " UNSIGNED";
    public static final String SQL_TYPE_NAME_TINYINT_UNSIGNED = "TINYINT UNSIGNED";
    private static final Logger logger = LoggerFactory.getLogger((Class)MySqlDataTypeFactory.class);

    public DataType createDataType(int sqlType, String sqlTypeName) throws DataTypeException {
        if (logger.isDebugEnabled()) {
            logger.debug("createDataType(sqlType={}, sqlTypeName={}) - start", (Object)String.valueOf(sqlType), (Object)sqlTypeName);
        }
        if (sqlType == 1111) {
            if ("longtext".equalsIgnoreCase(sqlTypeName)) {
                return DataType.CLOB;
            }
            if ("bit".equalsIgnoreCase(sqlTypeName)) {
                return DataType.BOOLEAN;
            }
            if ("point".equalsIgnoreCase(sqlTypeName)) {
                return DataType.BINARY;
            }
        }
        if (SQL_TYPE_NAME_TINYINT_UNSIGNED.equalsIgnoreCase(sqlTypeName)) {
            return DataType.TINYINT;
        }
        if (sqlTypeName.endsWith(UNSIGNED_SUFFIX) && sqlType == 4) {
            return DataType.BIGINT;
        }
        return super.createDataType(sqlType, sqlTypeName);
    }
}

