/*
 * Decompiled with CFR 0.152.
 */
package jeus.connector;

import java.util.HashSet;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ResourceAllocationException;
import javax.resource.spi.SharingViolationException;
import javax.security.auth.Subject;
import jeus.connector.ConnectionPool;
import jeus.connector.ConnectionPoolInfo;
import jeus.connector.ConnectionPoolStats;
import jeus.connector.ConnectionPoolTable;
import jeus.connector.ConnectionWaitTimeoutException;
import jeus.connector.ConnectorLocalDemarcator;
import jeus.connector.ManagedConnectionEventListener;
import jeus.connector.ManagedConnectionHandler;
import jeus.connector.ManagedConnectionPool;
import jeus.connector.MaximumWaitingQueueException;
import jeus.transaction.TransactionImpl;
import jeus.transaction.TransactionManagerImpl;
import jeus.transaction.resources.LocalXAResourceWrapper;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLevel;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JCA1;

final class ConnectionHandlerAcquirer {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.connector");
    private final ManagedConnectionPool mcp;
    private final ConnectionPoolInfo poolInfo;
    private final ConnectionPoolStats poolStats;
    private final ConnectionPoolTable poolTable;
    private final ConnectionRequestInfo cxRequestInfo;
    private final Subject subject;
    private final boolean shareable;
    private ManagedConnectionHandler handler;
    private long startTime;

    static ManagedConnectionHandler acquire(ManagedConnectionPool mcp, ConnectionRequestInfo cxRequestInfo, Subject subject, boolean shareable) throws ResourceException {
        ConnectionHandlerAcquirer acquirer = new ConnectionHandlerAcquirer(mcp, cxRequestInfo, subject, shareable);
        acquirer.compute();
        return acquirer.handler;
    }

    private ConnectionHandlerAcquirer(ManagedConnectionPool mcp, ConnectionRequestInfo cxRequestInfo, Subject subject, boolean shareable) {
        this.mcp = mcp;
        this.cxRequestInfo = cxRequestInfo;
        this.subject = subject;
        this.shareable = shareable;
        this.poolInfo = mcp.getPoolInfo();
        this.poolStats = mcp.getPoolStats();
        this.poolTable = mcp.getPoolTable();
    }

    private boolean isNotComputed() {
        return this.handler == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compute() throws ResourceException {
        block24: {
            if (logger.isLoggable(JeusMessage_JCA1._1651_LEVEL)) {
                logger.log(JeusMessage_JCA1._1651_LEVEL, JeusMessage_JCA1._1651, new Object[]{this.cxRequestInfo, this.subject, this.shareable ? "" : "non-"});
            }
            if (!this.poolInfo.isWorking()) {
                if (logger.isLoggable(JeusMessage_JCA1._1652_LEVEL)) {
                    logger.log(JeusMessage_JCA1._1652_LEVEL, JeusMessage_JCA1._1652);
                }
                throw new ResourceAllocationException("connection pool is suspended");
            }
            this.startTime = System.currentTimeMillis();
            this.poolStats.getWaitingThreadCount().increase();
            try {
                this.trySharingTransactedHandler();
                if (!this.isNotComputed()) break block24;
                if (logger.isLoggable(JeusMessage_JCA1._1684_LEVEL)) {
                    logger.log(JeusMessage_JCA1._1684_LEVEL, JeusMessage_JCA1._1684);
                }
                ConnectionPool pool = this.poolTable.acquireConnectionPool(this.cxRequestInfo);
                this.getManagedConnectionHandlerBelowMinSize(pool);
                if (this.isNotComputed()) {
                    if (logger.isLoggable(JeusMessage_JCA1._1686_LEVEL)) {
                        logger.log(JeusMessage_JCA1._1686_LEVEL, JeusMessage_JCA1._1686);
                    }
                    if (this.poolInfo.isReauthenticationSupport()) {
                        if (logger.isLoggable(JeusMessage_JCA1._1687_LEVEL)) {
                            logger.log(JeusMessage_JCA1._1687_LEVEL, JeusMessage_JCA1._1687);
                        }
                        this.tryNonBlockingDesignatedMode(pool);
                        if (this.isNotComputed()) {
                            this.tryNonBlockingNonDesignatedMode(pool);
                        }
                    }
                    if (this.isNotComputed()) {
                        this.tryBlockingDesignatedMode(pool);
                        if (this.isNotComputed()) {
                            this.getManagedConnectionHandler(pool);
                        }
                        if (this.isNotComputed()) {
                            this.getDisposableManagedConnectionHandler();
                        }
                    }
                }
                if (!this.isNotComputed()) {
                    try {
                        ManagedConnectionEventListener listener = new ManagedConnectionEventListener(this.handler);
                        this.handler.addConnectionEventListener(listener);
                    }
                    catch (ResourceException re) {
                        re.printStackTrace();
                        this.handler.destroy();
                        this.handler = null;
                    }
                }
                if (this.isNotComputed()) {
                    if (logger.isLoggable(JeusLevel.DEV)) {
                        logger.dev("-----failed to get connection");
                    }
                    if (logger.isLoggable(JeusMessage_JCA1._1700_LEVEL)) {
                        logger.log(JeusMessage_JCA1._1700_LEVEL, JeusMessage_JCA1._1700);
                    }
                    if (logger.isLoggable(JeusMessage_JCA1._1659_LEVEL)) {
                        logger.log(JeusMessage_JCA1._1659_LEVEL, JeusMessage_JCA1._1659);
                    }
                    if (logger.isLoggable(JeusMessage_JCA1._1608_LEVEL)) {
                        logger.log(JeusMessage_JCA1._1608_LEVEL, JeusMessage_JCA1._1608);
                    }
                    this.poolStats.getAcquireFailCount().increase();
                    throw new ResourceAllocationException("resource is fully occupied");
                }
                if (logger.isLoggable(JeusMessage_JCA1._1658_LEVEL)) {
                    logger.log(JeusMessage_JCA1._1658_LEVEL, JeusMessage_JCA1._1658, (Object)this.handler.getIdentity());
                }
                this.poolStats.getWaitTime().addData(System.currentTimeMillis() - this.startTime);
                this.handler.setShareable(this.shareable);
            }
            finally {
                this.poolStats.getWaitingThreadCount().decrease();
            }
        }
    }

    private void trySharingTransactedHandler() throws ResourceException {
        TransactionImpl curTx;
        if (logger.isLoggable(JeusMessage_JCA1._1660_LEVEL)) {
            logger.log(JeusMessage_JCA1._1660_LEVEL, JeusMessage_JCA1._1660);
        }
        if ((curTx = (TransactionImpl)TransactionManagerImpl.txManager.getTransaction()) != null) {
            LocalXAResourceWrapper rsc;
            if (logger.isLoggable(JeusMessage_JCA1._1653_LEVEL)) {
                logger.log(JeusMessage_JCA1._1653_LEVEL, JeusMessage_JCA1._1653, (Object)curTx);
            }
            if (this.poolInfo.getTxType() == 1 && (rsc = curTx.getLocalXAResource()) != null) {
                this.trySharingLocalTransactedHandler(rsc);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void trySharingLocalTransactedHandler(LocalXAResourceWrapper rsc) throws ResourceException {
        if (logger.isLoggable(JeusMessage_JCA1._1654_LEVEL)) {
            logger.log(JeusMessage_JCA1._1654_LEVEL, JeusMessage_JCA1._1654);
        }
        if (rsc instanceof ConnectorLocalDemarcator) {
            this.handler = ((ConnectorLocalDemarcator)rsc).getManagedConnectionHandler();
            if (this.shareable && this.handler.canShareTransaction(this.cxRequestInfo, this.subject)) {
                HashSet<ManagedConnection> candidateSet = new HashSet<ManagedConnection>(1);
                candidateSet.add(this.handler.getRealConnection());
                if (this.mcp.getManagedConnectionFactory().matchManagedConnections(candidateSet, this.subject, this.cxRequestInfo) == null) throw new SharingViolationException(ErrorMsgManager.getLocalizedString((int)14011));
                if (logger.isLoggable(JeusMessage_JCA1._1656_LEVEL)) {
                    logger.log(JeusMessage_JCA1._1656_LEVEL, JeusMessage_JCA1._1656);
                }
                if (logger.isLoggable(JeusLevel.DEV)) {
                    logger.dev("------ return Shared Connection---");
                }
                this.poolStats.getWaitTime().addData(System.currentTimeMillis() - this.startTime);
                return;
            }
            if (logger.isLoggable(JeusMessage_JCA1._1655_LEVEL)) {
                logger.log(JeusMessage_JCA1._1655_LEVEL, JeusMessage_JCA1._1655);
            }
            this.poolStats.getAcquireFailCount().increase();
            throw new SharingViolationException(ErrorMsgManager.getLocalizedString((int)14011));
        }
        if (logger.isLoggable(JeusMessage_JCA1._1657_LEVEL)) {
            logger.log(JeusMessage_JCA1._1657_LEVEL, JeusMessage_JCA1._1657);
        }
        this.poolStats.getAcquireFailCount().increase();
        throw new SharingViolationException(ErrorMsgManager.getLocalizedString((int)14011));
    }

    private void getManagedConnectionHandlerBelowMinSize(ConnectionPool pool) throws ResourceException {
        this.handler = this.mcp.createManagedConnectionHandlerBelowMinSize(this.cxRequestInfo, this.subject);
        if (this.handler != null) {
            if (logger.isLoggable(JeusMessage_JCA1._1685_LEVEL)) {
                logger.log(JeusMessage_JCA1._1685_LEVEL, JeusMessage_JCA1._1685);
            }
            pool.registerToCavity(this.handler);
        }
    }

    private void tryNonBlockingDesignatedMode(ConnectionPool pool) {
        if (logger.isLoggable(JeusMessage_JCA1._1688_LEVEL)) {
            logger.log(JeusMessage_JCA1._1688_LEVEL, JeusMessage_JCA1._1688);
        }
        if (pool.size() > 0) {
            this.handler = pool.getConnectionHandler(this.cxRequestInfo, this.subject);
            if (this.handler != null) {
                if (logger.isLoggable(JeusMessage_JCA1._1689_LEVEL)) {
                    logger.log(JeusMessage_JCA1._1689_LEVEL, JeusMessage_JCA1._1689);
                }
                return;
            }
        }
        if (logger.isLoggable(JeusMessage_JCA1._1690_LEVEL)) {
            logger.log(JeusMessage_JCA1._1690_LEVEL, JeusMessage_JCA1._1690);
        }
    }

    private void tryNonBlockingNonDesignatedMode(ConnectionPool pool) throws ResourceException {
        if (logger.isLoggable(JeusMessage_JCA1._1691_LEVEL)) {
            logger.log(JeusMessage_JCA1._1691_LEVEL, JeusMessage_JCA1._1691);
        }
        ConnectionPool[] pools = this.poolTable.getConnectionPools();
        for (int i = 0; i < pools.length; ++i) {
            ConnectionPool otherPool = pools[i];
            if (pool.equals(otherPool) || otherPool.size() == 0) continue;
            this.handler = otherPool.getConnectionHandler(this.cxRequestInfo, this.subject);
            if (this.handler == null) continue;
            if (logger.isLoggable(JeusMessage_JCA1._1692_LEVEL)) {
                logger.log(JeusMessage_JCA1._1692_LEVEL, JeusMessage_JCA1._1692);
            }
            this.handler.setResources();
            return;
        }
        if (logger.isLoggable(JeusMessage_JCA1._1693_LEVEL)) {
            logger.log(JeusMessage_JCA1._1693_LEVEL, JeusMessage_JCA1._1693);
        }
    }

    private void tryBlockingDesignatedMode(ConnectionPool pool) {
        block9: {
            if (logger.isLoggable(JeusMessage_JCA1._1694_LEVEL)) {
                logger.log(JeusMessage_JCA1._1694_LEVEL, JeusMessage_JCA1._1694);
            }
            try {
                this.handler = this.poolInfo.getWaitingTime() > 0L && this.poolInfo.getWaitTrial() > 0 ? pool.forcedGetConnectionHandler(this.poolInfo.getWaitingTime(), this.poolInfo.getWaitTrial(), this.cxRequestInfo, this.subject) : pool.getConnectionHandler(this.cxRequestInfo, this.subject);
                if (this.handler == null) {
                    if (logger.isLoggable(JeusMessage_JCA1._1696_LEVEL)) {
                        logger.log(JeusMessage_JCA1._1696_LEVEL, JeusMessage_JCA1._1696);
                    }
                } else if (logger.isLoggable(JeusMessage_JCA1._1695_LEVEL)) {
                    logger.log(JeusMessage_JCA1._1695_LEVEL, JeusMessage_JCA1._1695);
                }
            }
            catch (ConnectionWaitTimeoutException wte) {
                if (logger.isLoggable(JeusMessage_JCA1._1698_LEVEL)) {
                    logger.log(JeusMessage_JCA1._1698_LEVEL, JeusMessage_JCA1._1698);
                }
            }
            catch (MaximumWaitingQueueException mqe) {
                if (!logger.isLoggable(JeusMessage_JCA1._1699_LEVEL)) break block9;
                logger.log(JeusMessage_JCA1._1699_LEVEL, JeusMessage_JCA1._1699);
            }
        }
    }

    private void getManagedConnectionHandler(ConnectionPool pool) throws ResourceException {
        this.handler = this.mcp.createManagedConnectionHandler(this.cxRequestInfo, this.subject);
        if (this.handler != null) {
            pool.registerToCavity(this.handler);
        }
    }

    private void getDisposableManagedConnectionHandler() {
        this.handler = this.mcp.createDisposableManagedConnectionHandler(this.cxRequestInfo, this.subject);
    }
}

