/*
 * Decompiled with CFR 0.152.
 */
package jeus.connector;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Set;
import javax.resource.NotSupportedException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.security.auth.Subject;
import jeus.connector.ConnectionPoolInfo;
import jeus.connector.ConnectionPoolTicket;
import jeus.connector.ConnectionWaitTimeoutException;
import jeus.connector.ConnectionWaiterQueue;
import jeus.connector.ManagedConnectionHandler;
import jeus.connector.ManagedConnectionPool;
import jeus.connector.MaximumWaitingQueueException;
import jeus.util.logging.JeusLevel;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JCA0;
import jeus.util.message.JeusMessage_JCA1;

final class ConnectionPool {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.connector");
    private final ManagedConnectionPool mcp;
    private final ConnectionPoolInfo poolInfo;
    private final ManagedConnectionHandler[] handlers;
    private final ConnectionWaiterQueue waiterQueue;
    private volatile BitSet pooledBits;
    private final String identity;
    private final int max;
    private int size;
    private int age;

    public ConnectionPool(ManagedConnectionPool mcp, Object reqInfo) {
        this.mcp = mcp;
        this.poolInfo = mcp.getPoolInfo();
        this.max = mcp.getPoolInfo().getMax();
        this.pooledBits = new BitSet(this.max);
        this.handlers = new ManagedConnectionHandler[this.max];
        this.waiterQueue = new ConnectionWaiterQueue(this);
        this.identity = mcp.getManagedConnectionFactory().hashCode() + ":" + reqInfo.hashCode();
        if (logger.isLoggable(JeusMessage_JCA0._1001_LEVEL)) {
            logger.log(JeusMessage_JCA0._1001_LEVEL, JeusMessage_JCA0._1001, (Object)this.identity);
        }
    }

    public boolean returnConnection(ManagedConnectionHandler mch) {
        int index;
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("----[ConnectionPool/returnConnection] return connection " + mch.getIdentity());
        }
        mch.setPooled();
        if (logger.isLoggable(JeusMessage_JCA0._1002_LEVEL)) {
            logger.log(JeusMessage_JCA0._1002_LEVEL, JeusMessage_JCA0._1002, (Object)mch.getIdentity());
        }
        if ((index = mch.index) < 0) {
            return this.addToCavity(mch);
        }
        this.returnConnection(index);
        return true;
    }

    private synchronized void increaseSize() {
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("************ INCREASE (CURRNET : " + this.size + ") **************");
        }
        ++this.size;
        ++this.age;
        this.mcp.getPoolStats().getFreeConnections().increase();
    }

    private synchronized void decreaseSize() {
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("************ DECREASE (CURRNET : " + this.size + ") **************");
        }
        this.mcp.getPoolStats().getFreeConnections().decrease();
        --this.size;
    }

    private synchronized void increaseAge() {
        ++this.age;
    }

    public int size() {
        return this.size;
    }

    synchronized ManagedConnectionHandler[] retrieveConnectionHandlers() {
        ArrayList<ManagedConnectionHandler> handlerList = new ArrayList<ManagedConnectionHandler>();
        int index = this.pooledBits.nextSetBit(0);
        while (index >= 0 && index < this.handlers.length) {
            handlerList.add(this.handlers[index]);
            index = this.pooledBits.nextSetBit(index + 1);
        }
        return handlerList.toArray(new ManagedConnectionHandler[0]);
    }

    ManagedConnectionHandler forcedGetConnectionHandler(long timeout, int count, ConnectionRequestInfo info, Subject subject) throws ConnectionWaitTimeoutException, MaximumWaitingQueueException {
        if (logger.isLoggable(JeusMessage_JCA0._1003_LEVEL)) {
            logger.log(JeusMessage_JCA0._1003_LEVEL, JeusMessage_JCA0._1003, new Object[]{String.valueOf(timeout), String.valueOf(count)});
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("----[ConnectionPool/getConnection] blocking " + timeout + " msec " + count + " count");
        }
        ConnectionPoolTicket ticket = new ConnectionPoolTicket(info, subject, this.age, timeout, count);
        int index = this.nextPooledBit(0, ticket);
        while (!ticket.isExpired()) {
            ManagedConnectionHandler mch;
            if (logger.isLoggable(JeusMessage_JCA0._1004_LEVEL)) {
                logger.log(JeusMessage_JCA0._1004_LEVEL, JeusMessage_JCA0._1004, new Object[]{String.valueOf(ticket.getRemainingTime()), String.valueOf(ticket.getRemainingCount())});
            }
            if (index < 0) {
                index = this.waiterQueue.waitAndGetIndexFor(ticket);
                this.pooledBits.set(index);
                this.increaseAge();
            }
            if ((mch = this.getRecommendedConnectionHandler(index, ticket)) != null) {
                if (logger.isLoggable(JeusLevel.DEV)) {
                    logger.dev("*****return managed connection handler " + mch.getIdentity());
                }
                mch.setActivated();
                if (!ticket.isHanded()) {
                    this.decreaseSize();
                }
                return mch;
            }
            index = this.nextPooledBit(index + 1, ticket);
        }
        if (logger.isLoggable(JeusMessage_JCA0._1012_LEVEL)) {
            logger.log(JeusMessage_JCA0._1012_LEVEL, JeusMessage_JCA0._1012);
        }
        throw new ConnectionWaitTimeoutException();
    }

    private ManagedConnectionHandler getRecommendedConnectionHandler(int index, ConnectionPoolTicket ticket) {
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("----[ConnectionPool/getConnection] recommended " + index);
        }
        if (logger.isLoggable(JeusMessage_JCA0._1009_LEVEL)) {
            logger.log(JeusMessage_JCA0._1009_LEVEL, JeusMessage_JCA0._1009, (Object)String.valueOf(index));
        }
        if (this.checkoutConnection(index)) {
            ManagedConnectionHandler mch = this.handlers[index];
            if (ticket.isSkipMatch() || this.poolInfo.isSkipMatching()) {
                return mch;
            }
            if (logger.isLoggable(JeusMessage_JCA0._1010_LEVEL)) {
                logger.log(JeusMessage_JCA0._1010_LEVEL, JeusMessage_JCA0._1010, (Object)mch.getIdentity());
            }
            ticket.add(mch.getRealConnection());
            if (this.matchConnection(ticket)) {
                if (logger.isLoggable(JeusLevel.DEV)) {
                    logger.dev("**** connection matched" + (ticket.getNumOfFailed() == 0 ? "" : " after " + ticket.getNumOfFailed()) + " failure(s)");
                }
                return mch;
            }
            if (logger.isLoggable(JeusMessage_JCA0._1011_LEVEL)) {
                logger.log(JeusMessage_JCA0._1011_LEVEL, JeusMessage_JCA0._1011, (Object)mch.getIdentity());
            }
            ticket.matchFailed(index);
            if (ticket.isHanded()) {
                ticket.setHanded(false);
                this.returnConnection(index);
            } else {
                this.pooledBits.set(index);
                this.increaseAge();
            }
        }
        return null;
    }

    private int nextPooledBit(int index, ConnectionPoolTicket ticket) {
        if (ticket.getAge() != this.age) {
            ticket.setAge(this.age);
            index = 0;
        }
        index = this.pooledBits.nextSetBit(index);
        while (true) {
            if (index == -1) {
                if (logger.isLoggable(JeusMessage_JCA0._1015_LEVEL)) {
                    logger.log(JeusMessage_JCA0._1015_LEVEL, JeusMessage_JCA0._1015);
                }
                return -1;
            }
            if (ticket.isAcceptable(index)) {
                if (logger.isLoggable(JeusMessage_JCA0._1016_LEVEL)) {
                    logger.log(JeusMessage_JCA0._1016_LEVEL, JeusMessage_JCA0._1016, (Object)String.valueOf(index));
                }
                return index;
            }
            index = this.pooledBits.nextSetBit(index + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkoutConnection(int index) {
        ManagedConnectionHandler mch;
        if (logger.isLoggable(JeusMessage_JCA0._1017_LEVEL)) {
            logger.log(JeusMessage_JCA0._1017_LEVEL, JeusMessage_JCA0._1017, (Object)String.valueOf(index));
        }
        if ((mch = this.handlers[index]) != null) {
            ManagedConnectionHandler managedConnectionHandler = mch;
            synchronized (managedConnectionHandler) {
                if (!this.pooledBits.get(index)) {
                    if (logger.isLoggable(JeusMessage_JCA0._1018_LEVEL)) {
                        logger.log(JeusMessage_JCA0._1018_LEVEL, JeusMessage_JCA0._1018, (Object)mch.getIdentity());
                    }
                    return false;
                }
                this.pooledBits.clear(index);
                if (logger.isLoggable(JeusMessage_JCA0._1019_LEVEL)) {
                    logger.log(JeusMessage_JCA0._1019_LEVEL, JeusMessage_JCA0._1019, (Object)String.valueOf(index));
                }
                return true;
            }
        }
        if (logger.isLoggable(JeusMessage_JCA0._1020_LEVEL)) {
            logger.log(JeusMessage_JCA0._1020_LEVEL, JeusMessage_JCA0._1020, (Object)String.valueOf(index));
        }
        return false;
    }

    private boolean matchConnection(ConnectionPoolTicket ticket) {
        if (logger.isLoggable(JeusMessage_JCA0._1032_LEVEL)) {
            logger.log(JeusMessage_JCA0._1032_LEVEL, JeusMessage_JCA0._1032);
        }
        try {
            if (this.mcp.getManagedConnectionFactory().matchManagedConnections((Set)ticket, ticket.getSubject(), ticket.getConnectionRequestInfo()) != null) {
                if (logger.isLoggable(JeusMessage_JCA0._1033_LEVEL)) {
                    logger.log(JeusMessage_JCA0._1033_LEVEL, JeusMessage_JCA0._1033);
                }
                this.mcp.getPoolStats().getMatchSuccessCount().increase();
                return true;
            }
        }
        catch (NotSupportedException ne) {
            this.poolInfo.setReauthenticationSupport(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (logger.isLoggable(JeusMessage_JCA0._1034_LEVEL)) {
            logger.log(JeusMessage_JCA0._1034_LEVEL, JeusMessage_JCA0._1034);
        }
        this.mcp.getPoolStats().getMatchFailCount().increase();
        return false;
    }

    ManagedConnectionHandler getConnectionHandler(ConnectionRequestInfo info, Subject subject) {
        if (logger.isLoggable(JeusMessage_JCA0._1035_LEVEL)) {
            logger.log(JeusMessage_JCA0._1035_LEVEL, JeusMessage_JCA0._1035);
        }
        int index = this.pooledBits.nextSetBit(0);
        while (index >= 0 && index < this.handlers.length) {
            if (this.checkoutConnection(index)) {
                if (logger.isLoggable(JeusMessage_JCA0._1036_LEVEL)) {
                    logger.log(JeusMessage_JCA0._1036_LEVEL, JeusMessage_JCA0._1036, (Object)String.valueOf(index));
                }
                ManagedConnectionHandler mch = this.handlers[index];
                if (logger.isLoggable(JeusMessage_JCA0._1037_LEVEL) && !this.poolInfo.isSkipMatching()) {
                    logger.log(JeusMessage_JCA0._1037_LEVEL, JeusMessage_JCA0._1037, (Object)mch.getIdentity());
                }
                ConnectionPoolTicket ticket = new ConnectionPoolTicket(info, subject);
                ticket.add(mch.getRealConnection());
                if (this.poolInfo.isSkipMatching() || this.matchConnection(ticket)) {
                    if (logger.isLoggable(JeusLevel.DEV)) {
                        logger.dev("----[ConnectionPool/getConnection] accepted");
                    }
                    if (logger.isLoggable(JeusMessage_JCA0._1038_LEVEL)) {
                        logger.log(JeusMessage_JCA0._1038_LEVEL, JeusMessage_JCA0._1038, (Object)mch.getIdentity());
                    }
                    mch.setActivated();
                    this.decreaseSize();
                    return mch;
                }
                if (logger.isLoggable(JeusLevel.DEV)) {
                    logger.dev("----[ConnectionPool/getConnection] refused");
                }
                if (logger.isLoggable(JeusMessage_JCA0._1039_LEVEL)) {
                    logger.log(JeusMessage_JCA0._1039_LEVEL, JeusMessage_JCA0._1039, (Object)mch.getIdentity());
                }
                this.pooledBits.set(index);
                this.increaseAge();
            }
            index = this.pooledBits.nextSetBit(index + 1);
        }
        return null;
    }

    void removeConnection(boolean inUse, ManagedConnectionHandler mch) {
        int index;
        if (logger.isLoggable(JeusMessage_JCA1._1663_LEVEL)) {
            logger.log(JeusMessage_JCA1._1663_LEVEL, JeusMessage_JCA1._1663, new Object[]{mch.getIdentity(), this.getIdentity()});
        }
        if ((index = mch.index) >= 0) {
            this.handlers[index] = null;
        }
        if (!inUse) {
            this.decreaseSize();
        }
        this.mcp.clearMapping(mch);
        if (logger.isLoggable(JeusMessage_JCA0._1040_LEVEL)) {
            logger.log(JeusMessage_JCA0._1040_LEVEL, JeusMessage_JCA0._1040, (Object)mch.getIdentity());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addToCavity(ManagedConnectionHandler mch) {
        int index;
        if (logger.isLoggable(JeusMessage_JCA0._1041_LEVEL)) {
            logger.log(JeusMessage_JCA0._1041_LEVEL, JeusMessage_JCA0._1041, (Object)mch.getIdentity());
        }
        if ((index = this.registerToCavity(mch)) < 0) {
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("----[ConnectionPool/addToCavity] pool full");
            }
            if (logger.isLoggable(JeusMessage_JCA0._1042_LEVEL)) {
                logger.log(JeusMessage_JCA0._1042_LEVEL, JeusMessage_JCA0._1042, (Object)mch.getIdentity());
            }
            ManagedConnectionHandler managedConnectionHandler = mch;
            synchronized (managedConnectionHandler) {
                this.removeConnection(true, mch);
                mch.invalidate();
            }
            return false;
        }
        if (logger.isLoggable(JeusMessage_JCA0._1043_LEVEL)) {
            logger.log(JeusMessage_JCA0._1043_LEVEL, JeusMessage_JCA0._1043, (Object)mch.getIdentity());
        }
        this.returnConnection(index);
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("----[ConnectionPool/addToCavity] connection added to " + index);
        }
        return true;
    }

    private boolean returnConnection(int index) {
        if (logger.isLoggable(JeusMessage_JCA0._1025_LEVEL)) {
            logger.log(JeusMessage_JCA0._1025_LEVEL, JeusMessage_JCA0._1025, (Object)String.valueOf(index));
        }
        if (!this.waiterQueue.notifyWaiter(index)) {
            if (logger.isLoggable(JeusMessage_JCA0._1027_LEVEL)) {
                logger.log(JeusMessage_JCA0._1027_LEVEL, JeusMessage_JCA0._1027, new Object[]{String.valueOf(this.size), String.valueOf(index)});
            }
            this.pooledBits.set(index);
            this.increaseSize();
            return false;
        }
        return true;
    }

    public synchronized int registerToCavity(ManagedConnectionHandler mch) {
        int index = this.pooledBits.nextClearBit(0);
        while (index >= 0 && index < this.handlers.length) {
            if (this.handlers[index] == null) {
                if (logger.isLoggable(JeusLevel.DEV)) {
                    logger.dev("------[ConnectionPool/registerToCavity] empty index.. " + index + ", connection registered");
                }
                mch.index = index;
                this.handlers[index] = mch;
                return index;
            }
            index = this.pooledBits.nextClearBit(index + 1);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destoy() {
        if (logger.isLoggable(JeusMessage_JCA0._1044_LEVEL)) {
            logger.log(JeusMessage_JCA0._1044_LEVEL, JeusMessage_JCA0._1044);
        }
        int index = this.pooledBits.nextSetBit(0);
        while (index >= 0) {
            ManagedConnectionHandler mch = this.handlers[index];
            if (mch != null) {
                if (logger.isLoggable(JeusMessage_JCA0._1045_LEVEL)) {
                    logger.log(JeusMessage_JCA0._1045_LEVEL, JeusMessage_JCA0._1045, (Object)mch.getIdentity());
                }
                ManagedConnectionHandler managedConnectionHandler = mch;
                synchronized (managedConnectionHandler) {
                    this.removeConnection(false, mch);
                    mch.shrink();
                }
            }
            index = this.pooledBits.nextSetBit(index + 1);
        }
        if (logger.isLoggable(JeusMessage_JCA0._1046_LEVEL)) {
            logger.log(JeusMessage_JCA0._1046_LEVEL, JeusMessage_JCA0._1046);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shrink() {
        if (logger.isLoggable(JeusMessage_JCA0._1047_LEVEL)) {
            logger.log(JeusMessage_JCA0._1047_LEVEL, JeusMessage_JCA0._1047);
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("start shrinking connection pool");
        }
        long current = System.currentTimeMillis();
        int index = this.pooledBits.nextSetBit(0);
        while (this.mcp.checkShrinkAllowed() && index >= 0 && index < this.max) {
            if (this.checkoutConnection(index)) {
                ManagedConnectionHandler mch = this.handlers[index];
                if (logger.isLoggable(JeusLevel.DEV)) {
                    logger.dev("*** current - pooledTime : " + (current - mch.getPooledTime()));
                }
                if (current - mch.getPooledTime() > this.poolInfo.getPooledTimeout()) {
                    if (logger.isLoggable(JeusMessage_JCA0._1048_LEVEL)) {
                        logger.log(JeusMessage_JCA0._1048_LEVEL, JeusMessage_JCA0._1048, (Object)mch.getIdentity());
                    }
                    if (logger.isLoggable(JeusLevel.DEV)) {
                        logger.dev("managed connection " + mch.getIdentity() + " will be destroyed by pooled timeout");
                    }
                    ManagedConnectionHandler managedConnectionHandler = mch;
                    synchronized (managedConnectionHandler) {
                        this.removeConnection(false, mch);
                        mch.shrink();
                    }
                    this.mcp.getPoolStats().getShrinkCount().increase();
                } else {
                    this.pooledBits.set(index);
                    this.increaseAge();
                }
            }
            index = this.pooledBits.nextSetBit(index + 1);
        }
        if (logger.isLoggable(JeusMessage_JCA0._1049_LEVEL)) {
            logger.log(JeusMessage_JCA0._1049_LEVEL, JeusMessage_JCA0._1049);
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("end shrinking connection pool");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(Set invalidSet) {
        if (logger.isLoggable(JeusMessage_JCA0._1056_LEVEL)) {
            logger.log(JeusMessage_JCA0._1056_LEVEL, JeusMessage_JCA0._1056, (Object)invalidSet);
        }
        long current = System.currentTimeMillis();
        int index = this.pooledBits.nextSetBit(0);
        while (index >= 0 && index < this.handlers.length) {
            block12: {
                ManagedConnectionHandler mch = this.handlers[index];
                if (mch != null) {
                    ManagedConnectionHandler managedConnectionHandler = mch;
                    synchronized (managedConnectionHandler) {
                        if (!this.pooledBits.get(index)) {
                            break block12;
                        }
                        if (invalidSet.contains(mch.getRealConnection())) {
                            if (logger.isLoggable(JeusMessage_JCA0._1057_LEVEL)) {
                                logger.log(JeusMessage_JCA0._1057_LEVEL, JeusMessage_JCA0._1057, (Object)mch.getIdentity());
                            }
                            ManagedConnectionHandler managedConnectionHandler2 = mch;
                            synchronized (managedConnectionHandler2) {
                                this.removeConnection(false, mch);
                                mch.shrink();
                            }
                            this.mcp.getPoolStats().getInvalidateCount().increase();
                            this.pooledBits.clear(index);
                            this.mcp.getPoolStats().getUseTime().addData(current - mch.getActivatedTime());
                        }
                    }
                }
            }
            index = this.pooledBits.nextSetBit(index + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dissociate() {
        if (logger.isLoggable(JeusMessage_JCA0._1050_LEVEL)) {
            logger.log(JeusMessage_JCA0._1050_LEVEL, JeusMessage_JCA0._1050);
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("start dissociation of active connections.. " + this.toInverseString());
        }
        int index = this.pooledBits.nextClearBit(0);
        while (index >= 0 && index < this.handlers.length) {
            ManagedConnectionHandler mch = this.handlers[index];
            if (mch != null) {
                ManagedConnectionHandler managedConnectionHandler = mch;
                synchronized (managedConnectionHandler) {
                    if (this.pooledBits.get(index)) {
                    } else if (mch.isDissociatableNow()) {
                        if (logger.isLoggable(JeusMessage_JCA0._1051_LEVEL)) {
                            logger.log(JeusMessage_JCA0._1051_LEVEL, JeusMessage_JCA0._1051, (Object)mch.getIdentity());
                        }
                        if (logger.isLoggable(JeusLevel.DEV)) {
                            logger.dev("managed connection " + mch.getIdentity() + " will be dissociated by dissociation timeout");
                        }
                        this.mcp.getPoolStats().getDissociationCount().increase();
                        mch.dissociateConnections();
                    }
                }
            }
            index = this.pooledBits.nextClearBit(index + 1);
        }
        if (logger.isLoggable(JeusMessage_JCA0._1052_LEVEL)) {
            logger.log(JeusMessage_JCA0._1052_LEVEL, JeusMessage_JCA0._1052);
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("end dissociation of active connections");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        if (logger.isLoggable(JeusMessage_JCA0._1053_LEVEL)) {
            logger.log(JeusMessage_JCA0._1053_LEVEL, JeusMessage_JCA0._1053);
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("start invalidation of active connections.. " + this.toInverseString());
        }
        int index = this.pooledBits.nextClearBit(0);
        while (index >= 0 && index < this.handlers.length) {
            ManagedConnectionHandler mch = this.handlers[index];
            if (mch != null) {
                ManagedConnectionHandler managedConnectionHandler = mch;
                synchronized (managedConnectionHandler) {
                    if (this.pooledBits.get(index)) {
                    } else if (mch.isInvalidatableNow()) {
                        if (logger.isLoggable(JeusMessage_JCA0._1054_LEVEL)) {
                            logger.log(JeusMessage_JCA0._1054_LEVEL, JeusMessage_JCA0._1054, (Object)mch.getIdentity());
                        }
                        if (logger.isLoggable(JeusLevel.DEV)) {
                            logger.dev("managed connection " + mch.getIdentity() + " will be invalidated by invalidation timeout");
                        }
                        this.mcp.getPoolStats().getInvalidateCount().increase();
                        this.pooledBits.clear(index);
                        this.mcp.getPoolStats().getUseTime().addData(System.currentTimeMillis() - mch.getActivatedTime());
                        this.removeConnection(true, mch);
                        mch.invalidate();
                    }
                }
            }
            index = this.pooledBits.nextClearBit(index + 1);
        }
        if (logger.isLoggable(JeusMessage_JCA0._1055_LEVEL)) {
            logger.log(JeusMessage_JCA0._1055_LEVEL, JeusMessage_JCA0._1055);
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("end invalidation of active connections");
        }
    }

    public String getIdentity() {
        return this.identity;
    }

    public String toString() {
        return this.size + this.pooledBits.toString();
    }

    private String toInverseString() {
        BitSet inverse = (BitSet)this.pooledBits.clone();
        inverse.flip(0, this.max);
        return this.size + inverse.toString();
    }

    ManagedConnectionPool getManagedConnectionPool() {
        return this.mcp;
    }
}

