/*
 * Decompiled with CFR 0.152.
 */
package jeus.connector;

import java.util.Iterator;
import java.util.LinkedList;
import javax.resource.spi.ConnectionRequestInfo;
import javax.security.auth.Subject;
import jeus.connector.ConnectionPool;
import jeus.connector.ConnectionPoolTicket;
import jeus.connector.ConnectionWaitTimeoutException;
import jeus.connector.ManagedConnectionHandler;
import jeus.connector.ManagedConnectionPool;
import jeus.connector.MaximumWaitingQueueException;
import jeus.util.logging.JeusLevel;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JCA0;

final class ConnectionWaiterQueue
extends LinkedList {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.connector");
    private final ConnectionPool connectionPool;
    private final ManagedConnectionPool mcp;

    ConnectionWaiterQueue(ConnectionPool cp) {
        this.connectionPool = cp;
        this.mcp = this.connectionPool.getManagedConnectionPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean notifyWaiter(int index) {
        int current = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            ConnectionPoolTicket ticket;
            ++current;
            ConnectionPoolTicket connectionPoolTicket = ticket = (ConnectionPoolTicket)iter.next();
            synchronized (connectionPoolTicket) {
                if (ticket.isAcceptable(index)) {
                    if (logger.isLoggable(JeusMessage_JCA0._1026_LEVEL)) {
                        logger.log(JeusMessage_JCA0._1026_LEVEL, JeusMessage_JCA0._1026, (Object)String.valueOf(current));
                    }
                    if (logger.isLoggable(JeusLevel.DEV)) {
                        logger.dev("------waiter notified by mch index of " + index);
                    }
                    iter.remove();
                    ticket.setHanded(true);
                    ticket.setIndex(index);
                    ticket.notify();
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAvailableConnection() {
        if (logger.isLoggable(JeusMessage_JCA0._1021_LEVEL)) {
            logger.log(JeusMessage_JCA0._1021_LEVEL, JeusMessage_JCA0._1021);
        }
        if (this.size() > 0) {
            ConnectionPoolTicket ticket;
            ConnectionPoolTicket connectionPoolTicket = ticket = (ConnectionPoolTicket)this.get(0);
            synchronized (connectionPoolTicket) {
                try {
                    ConnectionRequestInfo reqInfo = ticket.getConnectionRequestInfo();
                    Subject subject = ticket.getSubject();
                    ManagedConnectionHandler mch = this.mcp.createManagedConnectionHandlerBelowMinSize(reqInfo, subject);
                    if (mch != null) {
                        int index = this.connectionPool.registerToCavity(mch);
                        if (index > 0) {
                            this.remove(ticket);
                            ticket.setHanded(true);
                            ticket.setSkipMatch(true);
                            ticket.setIndex(mch.index);
                            ticket.notify();
                            return true;
                        }
                        if (logger.isLoggable(JeusLevel.DEV)) {
                            logger.dev("!!!!!!!!!!!!!!!!! oops");
                        }
                        this.connectionPool.addToCavity(mch);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (logger.isLoggable(JeusMessage_JCA0._1023_LEVEL)) {
            logger.log(JeusMessage_JCA0._1023_LEVEL, JeusMessage_JCA0._1023);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int waitAndGetIndexFor(ConnectionPoolTicket ticket) throws MaximumWaitingQueueException, ConnectionWaitTimeoutException {
        ConnectionWaiterQueue connectionWaiterQueue = this;
        synchronized (connectionWaiterQueue) {
            if (logger.isLoggable(JeusMessage_JCA0._1005_LEVEL)) {
                logger.log(JeusMessage_JCA0._1005_LEVEL, JeusMessage_JCA0._1005);
            }
            if (this.size() >= this.mcp.getPoolInfo().getMaxWaiter()) {
                if (logger.isLoggable(JeusMessage_JCA0._1006_LEVEL)) {
                    logger.log(JeusMessage_JCA0._1006_LEVEL, JeusMessage_JCA0._1006);
                }
                if (!this.checkAvailableConnection()) {
                    if (logger.isLoggable(JeusMessage_JCA0._1007_LEVEL)) {
                        logger.log(JeusMessage_JCA0._1007_LEVEL, JeusMessage_JCA0._1007);
                    }
                    throw new MaximumWaitingQueueException();
                }
            } else if (logger.isLoggable(JeusMessage_JCA0._1008_LEVEL)) {
                logger.log(JeusMessage_JCA0._1008_LEVEL, JeusMessage_JCA0._1008);
            }
            this.add(ticket);
            if (logger.isLoggable(JeusMessage_JCA0._1024_LEVEL)) {
                logger.log(JeusMessage_JCA0._1024_LEVEL, JeusMessage_JCA0._1024);
            }
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("----------client request is registered to waiter queue, current : " + this.size());
            }
        }
        if (logger.isLoggable(JeusMessage_JCA0._1028_LEVEL)) {
            logger.log(JeusMessage_JCA0._1028_LEVEL, JeusMessage_JCA0._1028, (Object)String.valueOf(ticket.getRemainingTime()));
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("----------------------- wait ticket ");
        }
        try {
            return ticket.waitAndGetIndex();
        }
        catch (ConnectionWaitTimeoutException cwte) {
            ConnectionWaiterQueue connectionWaiterQueue2 = this;
            synchronized (connectionWaiterQueue2) {
                this.remove(ticket);
                if (logger.isLoggable(JeusMessage_JCA0._1031_LEVEL)) {
                    logger.log(JeusMessage_JCA0._1031_LEVEL, JeusMessage_JCA0._1031);
                }
                throw cwte;
            }
        }
    }
}

