/*
 * Decompiled with CFR 0.152.
 */
package jeus.connector;

import java.util.logging.Level;
import jeus.connector.ConnectionPoolInfo;
import jeus.connector.ManagedConnectionPool;
import jeus.util.logging.JeusLevel;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JCA0;

final class ConnectorTimer
extends Thread {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.connector");
    private ManagedConnectionPool managedConnectionPool;
    private boolean running;
    private long shrinkTimeout;
    private long dissociateTimeout;
    private long invalidateTimeout;
    private long validateTimeout;
    private long shrinkTime = Long.MAX_VALUE;
    private long dissociateTime = Long.MAX_VALUE;
    private long invalidateTime = Long.MAX_VALUE;
    private long validateTime = Long.MAX_VALUE;

    ConnectorTimer(ManagedConnectionPool mcp) {
        super("Connector Timer");
        this.setDaemon(true);
        this.managedConnectionPool = mcp;
        if (logger.isLoggable(JeusMessage_JCA0._1301_LEVEL)) {
            logger.log(JeusMessage_JCA0._1301_LEVEL, JeusMessage_JCA0._1301);
        }
    }

    void startTimer() {
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(JeusMessage_JCA0._1302_LEVEL, JeusMessage_JCA0._1302, (Object)String.valueOf(this.shrinkTimeout));
            logger.log(JeusMessage_JCA0._1303_LEVEL, JeusMessage_JCA0._1303, (Object)String.valueOf(this.dissociateTimeout));
            logger.log(JeusMessage_JCA0._1304_LEVEL, JeusMessage_JCA0._1304, (Object)String.valueOf(this.invalidateTimeout));
        }
        this.change();
        this.setRunning(true);
        this.start();
    }

    void stopTimer() {
        this.setRunning(false);
    }

    synchronized void setRunning(boolean running) {
        this.running = running;
    }

    synchronized boolean isRunning() {
        return this.running;
    }

    synchronized void change() {
        ConnectionPoolInfo poolInfo = this.managedConnectionPool.getPoolInfo();
        long sout = Math.max(0L, poolInfo.getPooledTimeout());
        long dout = Math.max(0L, poolInfo.getDissociationTimeout());
        long iout = Math.max(0L, poolInfo.getInvalidationTimeout());
        long vout = Math.max(0L, poolInfo.getValidationTimeout());
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("[ConnectorTimer.change] shrinkTimeout=" + sout + ", dissociateTimeout=" + dout + ", invalidateTimeout=" + iout);
        }
        long currentTime = System.currentTimeMillis();
        if (sout != this.shrinkTimeout) {
            this.shrinkTimeout = sout;
            this.updateShrinkTime(currentTime);
            this.notify();
        }
        if (dout != this.dissociateTimeout) {
            this.dissociateTimeout = dout;
            this.updateDissociateTime(currentTime);
            this.notify();
        }
        if (iout != this.invalidateTimeout) {
            this.invalidateTimeout = iout;
            this.updateInvalidateTime(currentTime);
            this.notify();
        }
        if (vout != this.validateTimeout) {
            this.validateTimeout = vout;
            this.updateValidateTime(currentTime);
            this.notify();
        }
    }

    public void run() {
        if (logger.isLoggable(JeusMessage_JCA0._1305_LEVEL)) {
            logger.log(JeusMessage_JCA0._1305_LEVEL, JeusMessage_JCA0._1305);
        }
        this.mainLoop();
    }

    private synchronized void mainLoop() {
        while (this.isRunning()) {
            this.processSchedule();
            this.waitForNextSchedule();
        }
    }

    private void processSchedule() {
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.shrinkTime) {
            this.managedConnectionPool.shrink();
            currentTime = System.currentTimeMillis();
            this.updateShrinkTime(currentTime);
        }
        if (currentTime >= this.dissociateTime) {
            this.managedConnectionPool.dissociate();
            currentTime = System.currentTimeMillis();
            this.updateDissociateTime(currentTime);
        }
        if (currentTime >= this.invalidateTime) {
            this.managedConnectionPool.invalidate();
            currentTime = System.currentTimeMillis();
            this.updateInvalidateTime(currentTime);
        }
        if (currentTime >= this.validateTime) {
            this.managedConnectionPool.validate();
            currentTime = System.currentTimeMillis();
            this.updateValidateTime(currentTime);
        }
    }

    private void waitForNextSchedule() {
        long wakeTime = this.shrinkTime;
        if (wakeTime > this.dissociateTime) {
            wakeTime = this.dissociateTime;
        }
        if (wakeTime > this.invalidateTime) {
            wakeTime = this.invalidateTime;
        }
        if (wakeTime > this.validateTime) {
            wakeTime = this.validateTime;
        }
        long currentTime = System.currentTimeMillis();
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("[ConnectorTimer.run] waitTime=" + (wakeTime - currentTime) + ", shrinkRemain=" + (this.shrinkTime - currentTime) + ", dissociateRemain=" + (this.dissociateTime - currentTime) + ", invalidateRemain=" + (this.invalidateTime - currentTime) + ", validatingTime=" + (this.validateTime - currentTime));
        }
        try {
            if (wakeTime == Long.MAX_VALUE) {
                this.wait();
            } else {
                this.wait(wakeTime - currentTime);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    private void updateShrinkTime(long currentTime) {
        this.shrinkTime = this.shrinkTimeout == 0L ? Long.MAX_VALUE : currentTime + this.shrinkTimeout;
    }

    private void updateDissociateTime(long currentTime) {
        this.dissociateTime = this.dissociateTimeout == 0L ? Long.MAX_VALUE : currentTime + this.dissociateTimeout;
    }

    private void updateInvalidateTime(long currentTime) {
        this.invalidateTime = this.invalidateTimeout == 0L ? Long.MAX_VALUE : currentTime + this.invalidateTimeout;
    }

    private void updateValidateTime(long currentTime) {
        this.validateTime = this.validateTimeout == 0L ? Long.MAX_VALUE : currentTime + this.validateTimeout;
    }
}

