/*
 * Decompiled with CFR 0.152.
 */
package jeus.connector;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import jeus.connector.ManagedConnectionHandler;
import jeus.util.logging.JeusLevel;
import jeus.util.logging.JeusLogger;

public class InvocationHandler
implements java.lang.reflect.InvocationHandler {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)InvocationHandler.class.getName());
    private final ManagedConnectionHandler mch;
    private final Object con;
    static final String CONNECTION_HANDLE_INTERFACE_NAME = "jeus.connector.ConnectionHandler";
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";

    public InvocationHandler(ManagedConnectionHandler mch, Object con) {
        this.mch = mch;
        this.con = con;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodClassName;
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("---[NAVIS/InvocationHandler] invoking.. : " + method.getName());
        }
        if ((methodClassName = method.getDeclaringClass().getName()).equals(JAVA_LANG_OBJECT)) {
            return this.invokeJavaObjectMethod(this, method, args);
        }
        if (methodClassName.equals(CONNECTION_HANDLE_INTERFACE_NAME)) {
            return this.con;
        }
        this.mch.checkStatus(proxy);
        try {
            return method.invoke(this.con, args);
        }
        catch (InvocationTargetException ite) {
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("---[NAVIS/InvocationHandler] ERROR invoking.. : " + method.getName() + "/" + this.con + "---");
            }
            throw ite.getTargetException();
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("---[NAVIS/InvocationHandler] ERROR invoking.. : " + method.getName() + "/" + this.con + "---");
                t.printStackTrace();
            }
            RuntimeException re = new RuntimeException();
            re.initCause(t);
            throw re;
        }
    }

    private Object invokeJavaObjectMethod(java.lang.reflect.InvocationHandler handler, Method method, Object[] args) throws RuntimeException {
        Object returnValue;
        switch (method.getName().charAt(0)) {
            case 'e': {
                Object other = Proxy.isProxyClass(args[0].getClass()) ? Proxy.getInvocationHandler(args[0]) : args[0];
                returnValue = handler.equals(other);
                break;
            }
            case 'h': {
                returnValue = new Integer(handler.hashCode());
                break;
            }
            case 't': {
                returnValue = handler.toString();
                break;
            }
            default: {
                throw new RuntimeException(method.getName());
            }
        }
        return returnValue;
    }
}

