/*
 * Decompiled with CFR 0.152.
 */
package jeus.connector;

import java.lang.reflect.Proxy;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ResourceAllocationException;
import javax.resource.spi.SharingViolationException;
import javax.resource.spi.UnavailableException;
import javax.security.auth.Subject;
import javax.transaction.xa.Xid;
import jeus.connector.ConnectionHandler;
import jeus.connector.ConnectionPoolInfo;
import jeus.connector.ConnectorLocalDemarcator;
import jeus.connector.ConnectorXAResource;
import jeus.connector.InvocationHandler;
import jeus.connector.ManagedConnectionPool;
import jeus.connector.ManagedConnectionState;
import jeus.connector.ManagedConnectionTxState;
import jeus.management.j2ee.JCAResource;
import jeus.transaction.TransactionImpl;
import jeus.transaction.TransactionManagerImpl;
import jeus.transaction.logging.ConnectorXAResourceFactory;
import jeus.transaction.resources.LocalXAResourceWrapper;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusRuntimeException;
import jeus.util.logging.JeusLevel;
import jeus.util.message.JeusMessage_JCA0;
import jeus.util.message.JeusMessage_JCA1;

public final class ManagedConnectionHandler
extends ManagedConnectionState {
    public ManagedConnectionHandler(ManagedConnectionPool mcp, ManagedConnection manCon, boolean disposable, ConnectionRequestInfo reqInfo, Subject subject) throws ResourceException {
        super(mcp, manCon, disposable, reqInfo, subject);
        this.txState = ManagedConnectionTxState.getInitialState(this);
        mcp.getPoolStats().getCreateCount().increase();
        this.setResources();
        if (logger.isLoggable(JeusMessage_JCA0._1451_LEVEL)) {
            logger.log(JeusMessage_JCA0._1451_LEVEL, JeusMessage_JCA0._1451, (Object)this.getIdentity());
        }
    }

    void setResources() throws ResourceException {
        if (logger.isLoggable(JeusMessage_JCA0._1453_LEVEL)) {
            logger.log(JeusMessage_JCA0._1453_LEVEL, JeusMessage_JCA0._1453, (Object)this.getIdentity());
        }
        if (this.txSupport == 1 || this.txSupport == 2) {
            this.localDemarcator = new ConnectorLocalDemarcator(this, this.manCon.getLocalTransaction());
        }
        if (this.txSupport == 2 || this.txSupport == 3) {
            ConnectionPoolInfo connectionPoolInfo = this.mcp.getPoolInfo();
            Reference ref = JCAResource.getRecoveryReference(connectionPoolInfo.getModuleName(), connectionPoolInfo.getExportName());
            ConnectorXAResource jeusXAResource = new ConnectorXAResource(this, this.manCon.getXAResource());
            jeusXAResource.setXAResourceFactory(new ConnectorXAResourceFactory(ref));
            this.xaResource = jeusXAResource;
        }
    }

    public void rollbackLocalTx() {
        this.txState.rollbackLocalTx();
    }

    public void cciLocalTransactionStarted() {
        if (logger.isLoggable(JeusMessage_JCA0._1456_LEVEL)) {
            logger.log(JeusMessage_JCA0._1456_LEVEL, JeusMessage_JCA0._1456);
        }
        this.txState.cciLocalTransactionStarted();
    }

    public void cciLocalTransactionCompleted() {
        this.txState.cciLocalTransactionCompleted();
    }

    public void spiLocalTransactionStarted(Xid xid) {
        this.txState.spiLocalTransactionStarted(xid);
    }

    public void spiLocalTransactionCompleted() {
        this.txState.spiLocalTransactionCompleted();
    }

    public void globalTransactionStarted(Xid xid) {
        this.txState.spiGlobalTransactionStarted(xid);
    }

    public void globalTransactionCompleted() {
        this.txState.globalTransactionCompleted();
    }

    public boolean lazyEnlist() throws ResourceException {
        return this.txState.lazyEnlist();
    }

    public void closeByApplication(Object con) {
        if (logger.isLoggable(JeusMessage_JCA0._1464_LEVEL)) {
            logger.log(JeusMessage_JCA0._1464_LEVEL, JeusMessage_JCA0._1464, new Object[]{con, this.getIdentity()});
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("---[NAVIS/ManagedConnectionHandler/closeByApplication] current shared : " + this.sharedHandles.size() + " from : " + this.manCon.hashCode());
        }
        if (this.isDestroyed()) {
            if (logger.isLoggable(JeusMessage_JCA0._1465_LEVEL)) {
                logger.log(JeusMessage_JCA0._1465_LEVEL, JeusMessage_JCA0._1465, (Object)this.getIdentity());
            }
            return;
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("------ close con : " + con.getClass().getName() + " : " + con.hashCode());
        }
        try {
            Object handler;
            if (logger.isLoggable(JeusMessage_JCA0._1466_LEVEL)) {
                logger.log(JeusMessage_JCA0._1466_LEVEL, JeusMessage_JCA0._1466);
            }
            if ((handler = this.sharedHandles.remove(con)) == null) {
                if (logger.isLoggable(JeusLevel.DEV)) {
                    logger.dev("------ requested connetion is not assigned to current managed connection handler");
                }
            } else if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("------ connection warpper : " + handler.getClass().getName() + " : " + handler.hashCode());
            }
            this.mcp.unregisterConnection(con);
            this.clear();
            if (logger.isLoggable(JeusMessage_JCA0._1467_LEVEL)) {
                logger.log(JeusMessage_JCA0._1467_LEVEL, JeusMessage_JCA0._1467);
            }
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_JCA0._1468_LEVEL)) {
                logger.log(JeusMessage_JCA0._1468_LEVEL, JeusMessage_JCA0._1468);
            }
            t.printStackTrace();
            this.destroy();
        }
    }

    public synchronized void destroy() {
        if (logger.isLoggable(JeusMessage_JCA0._1469_LEVEL)) {
            logger.log(JeusMessage_JCA0._1469_LEVEL, JeusMessage_JCA0._1469, (Object)this.getIdentity());
        }
        this.forcedClear();
        this.mcp.removeConnection(this);
        this.innerDestroy();
        if (logger.isLoggable(JeusMessage_JCA0._1470_LEVEL)) {
            logger.log(JeusMessage_JCA0._1470_LEVEL, JeusMessage_JCA0._1470);
        }
    }

    synchronized void shrink() {
        if (logger.isLoggable(JeusMessage_JCA0._1471_LEVEL)) {
            logger.log(JeusMessage_JCA0._1471_LEVEL, JeusMessage_JCA0._1471, (Object)this.getIdentity());
        }
        this.forcedClear();
        this.manCon.removeConnectionEventListener(this.listener);
        this.innerDestroy();
        if (logger.isLoggable(JeusMessage_JCA0._1472_LEVEL)) {
            logger.log(JeusMessage_JCA0._1472_LEVEL, JeusMessage_JCA0._1472);
        }
    }

    synchronized void invalidate() {
        if (logger.isLoggable(JeusMessage_JCA0._1473_LEVEL)) {
            logger.log(JeusMessage_JCA0._1473_LEVEL, JeusMessage_JCA0._1473, (Object)this.getIdentity());
        }
        this.forcedClear();
        this.manCon.removeConnectionEventListener(this.listener);
        this.innerDestroy();
        if (logger.isLoggable(JeusMessage_JCA0._1474_LEVEL)) {
            logger.log(JeusMessage_JCA0._1474_LEVEL, JeusMessage_JCA0._1474);
        }
    }

    private void forcedClear() {
        if (logger.isLoggable(JeusMessage_JCA0._1475_LEVEL)) {
            logger.log(JeusMessage_JCA0._1475_LEVEL, JeusMessage_JCA0._1475, (Object)this.getIdentity());
        }
        this.setDestroyed();
        this.txState.rollbackLocalTxForced();
        this.txState.rollbackGlobalTxForced();
        this.mcp.unregisterConnection(this.sharedHandles.keySet());
        this.sharedHandles.clear();
        if (logger.isLoggable(JeusMessage_JCA0._1477_LEVEL)) {
            logger.log(JeusMessage_JCA0._1477_LEVEL, JeusMessage_JCA0._1477);
        }
    }

    private void innerDestroy() {
        try {
            this.manCon.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.mcp.getPoolStats().getDestroyCount().increase();
    }

    void clear() {
        if (logger.isLoggable(JeusMessage_JCA0._1478_LEVEL)) {
            logger.log(JeusMessage_JCA0._1478_LEVEL, JeusMessage_JCA0._1478, (Object)this.getIdentity());
        }
        this.txState.clear();
    }

    public void checkStatus(Object handle) throws ResourceException {
        if (logger.isLoggable(JeusMessage_JCA0._1484_LEVEL)) {
            logger.log(JeusMessage_JCA0._1484_LEVEL, JeusMessage_JCA0._1484, handle);
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("---[NAVIS/ManagedConnectionHandler/checkStatus] handle : " + handle);
        }
        if (this.isDestroyed()) {
            if (logger.isLoggable(JeusMessage_JCA0._1485_LEVEL)) {
                logger.log(JeusMessage_JCA0._1485_LEVEL, JeusMessage_JCA0._1485, (Object)this.getIdentity());
            }
            throw new UnavailableException();
        }
        this.setAccessed();
        if (this.txSupport != 0) {
            this.txState.checkStatus(handle);
        } else if (logger.isLoggable(JeusMessage_JCA0._1486_LEVEL)) {
            logger.log(JeusMessage_JCA0._1486_LEVEL, JeusMessage_JCA0._1486);
        }
    }

    private boolean tryLastResource(TransactionImpl threadTx) throws ResourceException {
        if (this.txSupport != 3 && threadTx.getLocalXAResource() == null) {
            this.enlistLocalTransaction(threadTx);
            return true;
        }
        return false;
    }

    private boolean tryShareLocalTransaction(TransactionImpl threadTx, Object handle, boolean throwex) throws SharingViolationException {
        LocalXAResourceWrapper rsc;
        if (logger.isLoggable(JeusMessage_JCA0._1489_LEVEL)) {
            logger.log(JeusMessage_JCA0._1489_LEVEL, JeusMessage_JCA0._1489);
        }
        if ((rsc = threadTx.getLocalXAResource()) instanceof ConnectorLocalDemarcator) {
            ManagedConnectionHandler mch = ((ConnectorLocalDemarcator)rsc).getManagedConnectionHandler();
            if (this.manCon.equals(mch.manCon)) {
                if (logger.isLoggable(JeusMessage_JCA0._1490_LEVEL)) {
                    logger.log(JeusMessage_JCA0._1490_LEVEL, JeusMessage_JCA0._1490);
                }
                return true;
            }
            if (this.canShareTransaction(mch)) {
                if (logger.isLoggable(JeusMessage_JCA0._1491_LEVEL)) {
                    logger.log(JeusMessage_JCA0._1491_LEVEL, JeusMessage_JCA0._1491);
                }
                return this.shareLocalTransaction(mch, handle, throwex);
            }
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("------[NAVIS/ManagedConnectionHandler/tryShareLocalTransaction] unable to associate from : " + this.manCon.hashCode());
            }
            if (logger.isLoggable(JeusMessage_JCA0._1492_LEVEL)) {
                logger.log(JeusMessage_JCA0._1492_LEVEL, JeusMessage_JCA0._1492);
            }
            if (throwex) {
                throw new SharingViolationException(ErrorMsgManager.getLocalizedString((int)14011));
            }
        } else {
            if (logger.isLoggable(JeusMessage_JCA0._1493_LEVEL)) {
                logger.log(JeusMessage_JCA0._1493_LEVEL, JeusMessage_JCA0._1493);
            }
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("------[NAVIS/ManagedConnectionHandler/tryShareLocalTransaction] current local transaction is associated with jdbc connection from : " + this.manCon.hashCode());
            }
            if (throwex) {
                throw new SharingViolationException(ErrorMsgManager.getLocalizedString((int)14011));
            }
        }
        return false;
    }

    private boolean shareLocalTransaction(ManagedConnectionHandler mch, Object handle, boolean throwex) throws SharingViolationException {
        if (logger.isLoggable(JeusMessage_JCA0._1494_LEVEL)) {
            logger.log(JeusMessage_JCA0._1494_LEVEL, JeusMessage_JCA0._1494);
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("------[NAVIS/ManagedConnectionHandler/tryShareLocalTransaction] try to associate to managed connection in local transaction from : " + this.manCon.hashCode());
        }
        try {
            mch.associateWithEnlistedConnection(handle);
            this.mcp.unregisterConnection(this.sharedHandles.keySet());
            this.sharedHandles.clear();
            this.clear();
            if (logger.isLoggable(JeusMessage_JCA0._1495_LEVEL)) {
                logger.log(JeusMessage_JCA0._1495_LEVEL, JeusMessage_JCA0._1495);
            }
            return true;
        }
        catch (ResourceException re) {
            if (logger.isLoggable(JeusMessage_JCA0._1496_LEVEL)) {
                logger.log(JeusMessage_JCA0._1496_LEVEL, JeusMessage_JCA0._1496);
            }
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("------[NAVIS/ManagedConnectionHandler/tryShareLocalTransaction] exception in associating from : " + this.manCon.hashCode());
            }
            re.printStackTrace();
            if (throwex) {
                throw new SharingViolationException(ErrorMsgManager.getLocalizedString((int)14011));
            }
            return false;
        }
    }

    private void enlistLocalTransaction(TransactionImpl curTx) throws ResourceException {
        if (logger.isLoggable(JeusMessage_JCA0._1497_LEVEL)) {
            logger.log(JeusMessage_JCA0._1497_LEVEL, JeusMessage_JCA0._1497);
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("------[NAVIS/ManagedConnectionHandler/enlistLocalTransaction] enlist to current transaction from : " + this.manCon.hashCode());
        }
        try {
            curTx.enlistLocalXAResource(this.localDemarcator);
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_JCA0._1498_LEVEL)) {
                logger.log(JeusMessage_JCA0._1498_LEVEL, JeusMessage_JCA0._1498);
            }
            throw new SharingViolationException("impossible", t);
        }
        if (logger.isLoggable(JeusMessage_JCA0._1499_LEVEL)) {
            logger.log(JeusMessage_JCA0._1499_LEVEL, JeusMessage_JCA0._1499);
        }
        this.enlistedTx = curTx;
    }

    private void enlistXAResource(TransactionImpl curTx) throws SharingViolationException {
        if (logger.isLoggable(JeusMessage_JCA1._1500_LEVEL)) {
            logger.log(JeusMessage_JCA1._1500_LEVEL, JeusMessage_JCA1._1500);
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("------[NAVIS/ManagedConnectionHandler/enlistXAResource]--- from : " + this.manCon.hashCode());
        }
        try {
            curTx.enlistResource(this.xaResource);
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_JCA1._1501_LEVEL)) {
                logger.log(JeusMessage_JCA1._1501_LEVEL, JeusMessage_JCA1._1501);
            }
            throw new SharingViolationException("", t);
        }
        if (logger.isLoggable(JeusMessage_JCA1._1502_LEVEL)) {
            logger.log(JeusMessage_JCA1._1502_LEVEL, JeusMessage_JCA1._1502);
        }
        this.enlistedTx = curTx;
    }

    static TransactionImpl getTransaction() {
        try {
            return (TransactionImpl)TransactionManagerImpl.txManager.getTransaction();
        }
        catch (Exception se) {
            return null;
        }
    }

    public Object getConnection() throws ResourceException {
        if (this.isDestroyed()) {
            if (logger.isLoggable(JeusMessage_JCA1._1503_LEVEL)) {
                logger.log(JeusMessage_JCA1._1503_LEVEL, JeusMessage_JCA1._1503, (Object)this.getIdentity());
            }
            throw new UnavailableException();
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("---[NAVIS/ManagedConnectionHandler/getConnection] current shared : " + this.sharedHandles.size() + " from : " + this.manCon.hashCode());
        }
        if (logger.isLoggable(JeusMessage_JCA1._1504_LEVEL)) {
            logger.log(JeusMessage_JCA1._1504_LEVEL, JeusMessage_JCA1._1504, (Object)this.getIdentity());
        }
        Object con = this.manCon.getConnection(this.subject, this.reqInfo);
        if (logger.isLoggable(JeusMessage_JCA1._1505_LEVEL)) {
            logger.log(JeusMessage_JCA1._1505_LEVEL, JeusMessage_JCA1._1505, con);
        }
        if (this.isUseWrapper()) {
            return this.getWrappedConnection(con);
        }
        return this.getRawConnection(con);
    }

    private Object getWrappedConnection(Object con) throws ResourceAllocationException {
        InvocationHandler handler = new InvocationHandler(this, con);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (logger.isLoggable(JeusMessage_JCA1._1506_LEVEL)) {
            logger.log(JeusMessage_JCA1._1506_LEVEL, JeusMessage_JCA1._1506);
        }
        try {
            Object proxy = Proxy.newProxyInstance(loader, this.mcp.getInterfaces(), (java.lang.reflect.InvocationHandler)handler);
            this.sharedHandles.put(con, proxy);
            this.mcp.registerConnection(con, this);
            return proxy;
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusMessage_JCA1._1507_LEVEL)) {
                logger.log(JeusMessage_JCA1._1507_LEVEL, JeusMessage_JCA1._1507);
            }
            this.sharedHandles.remove(con);
            this.mcp.unregisterConnection(con);
            throw new ResourceAllocationException(e.getMessage());
        }
    }

    private Object getRawConnection(Object con) throws ResourceException {
        this.sharedHandles.put(con, con);
        this.mcp.registerConnection(con, this);
        if (!this.isLazyEnlistable()) {
            if (logger.isLoggable(JeusMessage_JCA1._1508_LEVEL)) {
                logger.log(JeusMessage_JCA1._1508_LEVEL, JeusMessage_JCA1._1508);
            }
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("--------- try to enlist managed connection");
            }
            this.checkStatus(con);
        } else {
            if (logger.isLoggable(JeusMessage_JCA1._1509_LEVEL)) {
                logger.log(JeusMessage_JCA1._1509_LEVEL, JeusMessage_JCA1._1509);
            }
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("--------- skip enlisment for lazy enlistable managed connection");
            }
        }
        if (logger.isLoggable(JeusMessage_JCA1._1510_LEVEL)) {
            logger.log(JeusMessage_JCA1._1510_LEVEL, JeusMessage_JCA1._1510, con);
        }
        return con;
    }

    private void associateWithEnlistedConnection(Object handler) throws ResourceException {
        if (logger.isLoggable(JeusMessage_JCA1._1511_LEVEL)) {
            logger.log(JeusMessage_JCA1._1511_LEVEL, JeusMessage_JCA1._1511, new Object[]{handler, this.getIdentity()});
        }
        if (this.isDestroyed()) {
            if (logger.isLoggable(JeusMessage_JCA1._1512_LEVEL)) {
                logger.log(JeusMessage_JCA1._1512_LEVEL, JeusMessage_JCA1._1512, (Object)this.getIdentity());
            }
            throw new UnavailableException();
        }
        if (this.isUseWrapper()) {
            ConnectionHandler wrapper = (ConnectionHandler)handler;
            handler = wrapper.getRealConnection();
        }
        this.manCon.associateConnection(handler);
        this.sharedHandles.put(handler, handler);
        this.mcp.registerConnection(handler, this);
        if (logger.isLoggable(JeusMessage_JCA1._1513_LEVEL)) {
            logger.log(JeusMessage_JCA1._1513_LEVEL, JeusMessage_JCA1._1513);
        }
    }

    public void addConnectionEventListener(ConnectionEventListener listener) throws ResourceException {
        if (logger.isLoggable(JeusMessage_JCA1._1514_LEVEL)) {
            logger.log(JeusMessage_JCA1._1514_LEVEL, JeusMessage_JCA1._1514, (Object)this.getIdentity());
        }
        if (this.isDestroyed()) {
            if (logger.isLoggable(JeusMessage_JCA1._1515_LEVEL)) {
                logger.log(JeusMessage_JCA1._1515_LEVEL, JeusMessage_JCA1._1515, (Object)this.getIdentity());
            }
            throw new UnavailableException();
        }
        if (this.listener != null) {
            if (logger.isLoggable(JeusMessage_JCA1._1516_LEVEL)) {
                logger.log(JeusMessage_JCA1._1516_LEVEL, JeusMessage_JCA1._1516);
            }
            this.manCon.removeConnectionEventListener(this.listener);
        }
        this.listener = listener;
        this.manCon.addConnectionEventListener(listener);
        if (logger.isLoggable(JeusMessage_JCA1._1517_LEVEL)) {
            logger.log(JeusMessage_JCA1._1517_LEVEL, JeusMessage_JCA1._1517, (Object)this.getIdentity());
        }
    }

    private boolean tryShareLocalTransaction(LocalXAResourceWrapper rsc, boolean throwex) throws SharingViolationException {
        if (logger.isLoggable(JeusMessage_JCA1._1524_LEVEL)) {
            logger.log(JeusMessage_JCA1._1524_LEVEL, JeusMessage_JCA1._1524);
        }
        if (rsc instanceof ConnectorLocalDemarcator) {
            ManagedConnectionHandler mch = ((ConnectorLocalDemarcator)rsc).getManagedConnectionHandler();
            if (this.manCon.equals(mch.manCon)) {
                return true;
            }
            if (logger.isLoggable(JeusMessage_JCA1._1525_LEVEL)) {
                logger.log(JeusMessage_JCA1._1525_LEVEL, JeusMessage_JCA1._1525);
            }
            if (throwex) {
                throw new SharingViolationException(ErrorMsgManager.getLocalizedString((int)14011));
            }
        } else {
            if (logger.isLoggable(JeusMessage_JCA1._1526_LEVEL)) {
                logger.log(JeusMessage_JCA1._1526_LEVEL, JeusMessage_JCA1._1526);
            }
            if (throwex) {
                throw new SharingViolationException(ErrorMsgManager.getLocalizedString((int)14011));
            }
        }
        return false;
    }

    public boolean dissociateConnections() {
        if (logger.isLoggable(JeusMessage_JCA1._1527_LEVEL)) {
            logger.log(JeusMessage_JCA1._1527_LEVEL, JeusMessage_JCA1._1527, (Object)this.getIdentity());
        }
        try {
            ((DissociatableManagedConnection)this.manCon).dissociateConnections();
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_JCA1._1528_LEVEL)) {
                logger.log(JeusMessage_JCA1._1528_LEVEL, JeusMessage_JCA1._1528, (Object)this.getIdentity(), t);
            }
            this.destroy();
            return false;
        }
        for (Object con : this.sharedHandles.keySet()) {
            this.mcp.unregisterConnection(con);
        }
        this.sharedHandles.clear();
        this.enlistedTx = null;
        this.clear();
        if (logger.isLoggable(JeusMessage_JCA1._1529_LEVEL)) {
            logger.log(JeusMessage_JCA1._1529_LEVEL, JeusMessage_JCA1._1529, (Object)this.getIdentity());
        }
        return true;
    }

    public ConnectionHandler checkRegisteredConnection(Object con) {
        return (ConnectionHandler)this.sharedHandles.get(con);
    }

    public void associateConnection(Object con) throws ResourceException {
        this.sharedHandles.put(con, con);
        this.mcp.unregisterConnection(con);
        this.mcp.registerConnection(con, this);
        this.manCon.associateConnection(con);
    }

    final void checkCurrentTransaction(Object handle) throws ResourceException {
        TransactionImpl threadTx = ManagedConnectionHandler.getTransaction();
        if (threadTx == null) {
            if (logger.isLoggable(JeusMessage_JCA0._1488_LEVEL)) {
                logger.log(JeusMessage_JCA0._1488_LEVEL, JeusMessage_JCA0._1488);
            }
            return;
        }
        if (threadTx.equals(this.enlistedTx)) {
            return;
        }
        if (this.tryLastResource(threadTx)) {
            return;
        }
        if (this.txSupport == 2 || this.txSupport == 3) {
            this.enlistXAResource(threadTx);
        } else if (this.txSupport == 1 && this.tryShareLocalTransaction(threadTx, handle, true)) {
            this.enlistedTx = threadTx;
        }
    }

    final boolean spiLazyEnlist() throws ResourceException {
        if (!this.isLazyEnlistable()) {
            if (logger.isLoggable(JeusMessage_JCA1._1518_LEVEL)) {
                logger.log(JeusMessage_JCA1._1518_LEVEL, JeusMessage_JCA1._1518, (Object)this.getIdentity());
            }
            throw new SharingViolationException();
        }
        if (this.isDestroyed()) {
            if (logger.isLoggable(JeusMessage_JCA1._1519_LEVEL)) {
                logger.log(JeusMessage_JCA1._1519_LEVEL, JeusMessage_JCA1._1519, (Object)this.getIdentity());
            }
            throw new UnavailableException();
        }
        if (this.txSupport == 0) {
            if (logger.isLoggable(JeusMessage_JCA1._1520_LEVEL)) {
                logger.log(JeusMessage_JCA1._1520_LEVEL, JeusMessage_JCA1._1520, (Object)this.getIdentity());
            }
            if (logger.isLoggable(JeusMessage_JCA1._1521_LEVEL)) {
                logger.log(JeusMessage_JCA1._1521_LEVEL, JeusMessage_JCA1._1521);
            }
            throw new SharingViolationException();
        }
        TransactionImpl curTx = ManagedConnectionHandler.getTransaction();
        if (curTx == null) {
            if (logger.isLoggable(JeusMessage_JCA1._1523_LEVEL)) {
                logger.log(JeusMessage_JCA1._1523_LEVEL, JeusMessage_JCA1._1523);
            }
            return false;
        }
        LocalXAResourceWrapper rsc = curTx.getLocalXAResource();
        if (rsc == null && this.txSupport != 3) {
            this.enlistLocalTransaction(curTx);
            return true;
        }
        boolean shared = false;
        switch (this.txSupport) {
            case 2: {
                shared = this.tryShareLocalTransaction(rsc, false);
            }
            case 3: {
                if (shared) break;
                this.enlistXAResource(curTx);
                break;
            }
            case 1: {
                shared = this.tryShareLocalTransaction(rsc, true);
            }
        }
        return shared;
    }

    void arrangeSpiTxRollback() {
        block4: {
            try {
                TransactionImpl curTx = ManagedConnectionHandler.getTransaction();
                if (curTx != null) {
                    curTx.setRollbackOnly();
                }
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_JCA0._1457_LEVEL)) break block4;
                logger.log(JeusMessage_JCA0._1457_LEVEL, JeusMessage_JCA0._1457, t);
            }
        }
        if (logger.isLoggable(JeusMessage_JCA0._1458_LEVEL)) {
            logger.log(JeusMessage_JCA0._1458_LEVEL, JeusMessage_JCA0._1458);
        }
        throw new JeusRuntimeException("current managed connection is participated in spi transaction");
    }
}

