/*
 * Decompiled with CFR 0.152.
 */
package jeus.connector;

import java.util.HashSet;
import javax.annotation.Resource;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LazyAssociatableConnectionManager;
import javax.resource.spi.LazyEnlistableConnectionManager;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.ResourceAllocationException;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import jeus.connector.ConnectionHandlerAcquirer;
import jeus.connector.ManagedConnectionHandler;
import jeus.connector.ManagedConnectionPool;
import jeus.management.JMXManager;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEDeployedObjectMBean;
import jeus.security.resource.PrincipalImpl;
import jeus.util.ErrorMsgManager;
import jeus.util.ExecutionContext;
import jeus.util.JeusRuntimeException;
import jeus.util.VirtualDNS;
import jeus.util.logging.JeusLevel;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JCA1;
import jeus.util.properties.JeusManagerPropertyValues;

public final class ManagedConnectionManager
implements ConnectionManager,
LazyEnlistableConnectionManager,
LazyAssociatableConnectionManager {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.connector");
    private final ManagedConnectionPool mcp;
    private final String appName;
    private final boolean standalone;
    private final boolean shareable;
    private final boolean appAuth;

    public ManagedConnectionManager(ManagedConnectionPool mcp, boolean standalone, boolean shareable, Resource.AuthenticationType authType) {
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("[ManagedConnectionManager.ManagedConnectionManager][IN ] " + mcp + ", " + standalone);
        }
        this.mcp = mcp;
        this.appName = mcp.getPoolInfo().getAppName();
        this.standalone = standalone;
        this.shareable = shareable;
        boolean bl = this.appAuth = authType == Resource.AuthenticationType.APPLICATION;
        if (logger.isLoggable(JeusMessage_JCA1._1601_LEVEL)) {
            logger.log(JeusMessage_JCA1._1601_LEVEL, JeusMessage_JCA1._1601, (Object)String.valueOf(shareable));
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("[ManagedConnectionManager.ManagedConnectionManager][OUT] " + this);
        }
    }

    public final void lazyEnlist(ManagedConnection mc) throws ResourceException {
        if (logger.isLoggable(JeusMessage_JCA1._1602_LEVEL)) {
            logger.log(JeusMessage_JCA1._1602_LEVEL, JeusMessage_JCA1._1602, (Object)String.valueOf(mc.hashCode()));
        }
        this.mcp.lazyEnlist(mc);
    }

    public final void associateConnection(Object con, ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (logger.isLoggable(JeusMessage_JCA1._1603_LEVEL)) {
            logger.log(JeusMessage_JCA1._1603_LEVEL, JeusMessage_JCA1._1603, (Object)String.valueOf(con.hashCode()));
        }
        ManagedConnectionHandler mch = this.acquireConnectionHandler(mcf, cxRequestInfo);
        mch.associateConnection(con);
    }

    public final Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("[ManagedConnectionManager.allocateConnection][IN ] " + mcf + ", " + cxRequestInfo);
        }
        if (logger.isLoggable(JeusMessage_JCA1._1604_LEVEL)) {
            logger.log(JeusMessage_JCA1._1604_LEVEL, JeusMessage_JCA1._1604, new Object[]{mcf, cxRequestInfo});
        }
        ManagedConnectionHandler mch = this.acquireConnectionHandler(mcf, cxRequestInfo);
        Object connection = mch.getConnection();
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("[ManagedConnectionManager.allocateConnection][OUT] " + connection);
        }
        return connection;
    }

    private ManagedConnectionHandler acquireConnectionHandler(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("[ManagedConnectionManager.forcedGetConnectionHandler][IN ] " + mcf + ", " + cxRequestInfo);
        }
        this.checkManagedConnectionFactory(mcf);
        if (this.isDedicated()) {
            this.checkAppContext();
        }
        Subject subject = this.getSubject(mcf);
        ManagedConnectionHandler result = ConnectionHandlerAcquirer.acquire(this.mcp, cxRequestInfo, subject, this.shareable);
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("[ManagedConnectionManager.forcedGetConnectionHandler][OUT] " + result);
        }
        return result;
    }

    private void checkManagedConnectionFactory(ManagedConnectionFactory mcf) throws ResourceAdapterInternalException {
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("[ManagedConnectionManager.checkManagedConnectionFactory][IN ] " + mcf);
        }
        if (!this.mcp.getManagedConnectionFactory().equals(mcf)) {
            if (logger.isLoggable(JeusMessage_JCA1._1605_LEVEL)) {
                logger.log(JeusMessage_JCA1._1605_LEVEL, JeusMessage_JCA1._1605, (Object)mcf);
            }
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("[ManagedConnectionManager.checkManagedConnectionFactory][OUT] wrong ManagedConnectionFactory; throws ResourceAdapterInternalException");
            }
            throw new ResourceAdapterInternalException();
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("[ManagedConnectionManager.checkManagedConnectionFactory][OUT]");
        }
    }

    private boolean isDedicated() {
        boolean result;
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("[ManagedConnectionManager.isDedicated][IN ]");
        }
        boolean bl = result = !this.standalone && this.appName != null;
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("[ManagedConnectionManager.isDedicated][OUT] " + result);
        }
        return result;
    }

    private void checkAppContext() {
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("[ManagedConnectionManager.checkAppContext][IN ]");
        }
        try {
            String currentAppName = ExecutionContext.getExecutionContext().getAppName();
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("[ManagedConnectionManager.checkAppContext] current application name is " + currentAppName);
            }
            MBeanServer server = JMXManager.getMbeanServer();
            ObjectName[] deployedObjectNames = JMXUtility.queryJ2EEDeployedObjects(server, VirtualDNS.LOCAL_VIRTUALNAME, JeusManagerPropertyValues.containerName, null, currentAppName);
            J2EEDeployedObjectMBean[] mbeans = JMXUtility.getProxy((MBeanServerConnection)server, deployedObjectNames, J2EEDeployedObjectMBean.class, false);
            for (int i = 0; i < mbeans.length; ++i) {
                J2EEDeployedObjectMBean mbean = mbeans[i];
                ObjectName name = mbean.getObjectName();
                String earAppName = name.getKeyProperty("J2EEApplication");
                if (earAppName != null && earAppName.equals(this.appName)) continue;
                if (logger.isLoggable(JeusMessage_JCA1._1607_LEVEL)) {
                    logger.log(JeusMessage_JCA1._1607_LEVEL, JeusMessage_JCA1._1607, new Object[]{this.appName, currentAppName});
                }
                if (logger.isLoggable(JeusLevel.DEV)) {
                    logger.dev("[ManagedConnectionManager.checkAppContext][OUT] wrong application context; throw ResourceAllocationException");
                }
                throw new ResourceAllocationException();
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("[ManagedConnectionManager.checkAppContext][OUT] " + e + " has been occurred; throw JeusRuntimeException");
            }
            throw new JeusRuntimeException((Throwable)e);
        }
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("[ManagedConnectionManager.checkAppContext][OUT]");
        }
    }

    private Subject getSubject(ManagedConnectionFactory mcf) throws SecurityException {
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("[ManagedConnectionManager.getSubject][IN ] " + mcf);
        }
        if (this.appAuth) {
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("[ManagedConnectionManager.getSubject][OUT] appAuth is true; return null");
            }
            return null;
        }
        String username = this.mcp.getPoolInfo().getUsername();
        if (username == null) {
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("[ManagedConnectionManager.getSubject][OUT] username is null; return null");
            }
            return null;
        }
        String password = this.mcp.getPoolInfo().getPassword();
        try {
            if (logger.isLoggable(JeusMessage_JCA1._1609_LEVEL)) {
                logger.log(JeusMessage_JCA1._1609_LEVEL, JeusMessage_JCA1._1609, new Object[]{username, password});
            }
            HashSet<PrincipalImpl> principals = new HashSet<PrincipalImpl>();
            principals.add(new PrincipalImpl(username));
            PasswordCredential credential = new PasswordCredential(username, password.toCharArray());
            credential.setManagedConnectionFactory(mcf);
            HashSet<PasswordCredential> privCredentials = new HashSet<PasswordCredential>();
            privCredentials.add(credential);
            Subject subject = new Subject(true, principals, new HashSet(), privCredentials);
            if (logger.isLoggable(JeusMessage_JCA1._1610_LEVEL)) {
                logger.log(JeusMessage_JCA1._1610_LEVEL, JeusMessage_JCA1._1610, (Object)subject);
            }
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("[ManagedConnectionManager.getSubject][OUT] " + subject);
            }
            return subject;
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_JCA1._1611_LEVEL)) {
                logger.log(JeusMessage_JCA1._1611_LEVEL, JeusMessage_JCA1._1611, new Object[]{username, password});
            }
            logger.directLog(t);
            if (logger.isLoggable(JeusLevel.DEV)) {
                logger.dev("[ManagedConnectionManager.getSubject][OUT] unexpected throwable <" + t + "> has been occurred; throw SecurityException");
            }
            throw new SecurityException(ErrorMsgManager.getLocalizedString((int)14015));
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ManagedConnectionManager{");
        buf.append("mcp=").append(this.mcp);
        buf.append(", appName=").append(this.appName);
        buf.append(", standalone=").append(this.standalone);
        buf.append(", shareable=").append(this.shareable);
        buf.append(", appAuth=").append(this.appAuth);
        buf.append("}");
        return buf.toString();
    }
}

