/*
 * Decompiled with CFR 0.152.
 */
package jeus.connector;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import jeus.util.JeusOutputStreamWriter;
import jeus.util.file.FileUtils;

public final class RollOverFileWriter
extends Writer {
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final Calendar CALENDAR = Calendar.getInstance();
    private final String filename;
    private final String extension;
    private final int bufSize;
    private final boolean append;
    private final int validDay;
    private Writer writer;
    private long expireTime;

    public RollOverFileWriter(String filename, String extension, boolean append, int bufSize, int validDay) throws IOException {
        if (filename == null || filename.trim().length() == 0) {
            throw new IOException("Invalid filename: " + filename);
        }
        this.filename = filename.trim();
        this.extension = extension == null || extension.trim().length() == 0 ? null : extension.trim();
        this.append = append;
        this.bufSize = bufSize > 0 ? bufSize : 1;
        this.validDay = validDay;
        if (!this.isRollOverEnabled()) {
            FileOutputStream fos = new FileOutputStream(this.calculateFile(0L), this.append);
            this.writer = new JeusOutputStreamWriter((OutputStream)fos, this.bufSize);
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.isRollOverEnabled()) {
            this.checkAndRollOver(System.currentTimeMillis());
        }
        this.writer.write(cbuf, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndRollOver(long currentTime) throws IOException {
        if (currentTime >= this.expireTime) {
            RollOverFileWriter rollOverFileWriter = this;
            synchronized (rollOverFileWriter) {
                if (currentTime >= this.expireTime) {
                    if (this.writer != null) {
                        this.writer.flush();
                        this.writer.close();
                    }
                    FileOutputStream fos = new FileOutputStream(this.calculateFile(currentTime), this.append);
                    this.writer = new JeusOutputStreamWriter((OutputStream)fos, this.bufSize);
                    this.expireTime = this.calculateExpireTime(currentTime);
                }
            }
        }
    }

    private File calculateFile(long currentTime) {
        File file;
        StringBuffer buf = new StringBuffer(this.filename);
        if (this.isRollOverEnabled()) {
            buf.append("_");
            buf.append(SIMPLE_DATE_FORMAT.format(new Date(currentTime)));
        }
        if (this.extension != null) {
            buf.append(".").append(this.extension);
        }
        if (!(file = new File(buf.toString())).exists()) {
            FileUtils.makeDirectories((File)file);
        }
        return file;
    }

    private long calculateExpireTime(long currentTime) {
        CALENDAR.setTimeInMillis(currentTime);
        int year = CALENDAR.get(1);
        int month = CALENDAR.get(2);
        int date = CALENDAR.get(5);
        CALENDAR.clear();
        CALENDAR.set(year, month, date);
        CALENDAR.add(5, this.validDay);
        return CALENDAR.getTime().getTime();
    }

    public void flush() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
            this.writer = null;
        }
    }

    public void finalize() throws Throwable {
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
            this.writer = null;
        }
        super.finalize();
    }

    private boolean isRollOverEnabled() {
        return this.validDay > 0;
    }
}

