/*
 * Decompiled with CFR 0.152.
 */
package jeus.connector.work;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.resource.spi.work.WorkRejectedException;
import jeus.connector.work.WorkManager;
import jeus.connector.work.WorkQueue;
import jeus.connector.work.WorkWrapper;
import jeus.management.j2ee.statistics.BoundedRangeStatisticImpl;
import jeus.util.DaemonThreadFactory;
import jeus.util.concurrent50.concurrent.ThreadFactory;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JCA1;

public class WorkExecutor {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.connector");
    private int step;
    private WorkManager workManager;
    public static final int DEFAULT_MAXIMUMPOOLSIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_MINIMUMPOOLSIZE = 1;
    public static final long DEFAULT_KEEPALIVETIME = 60000L;
    protected int maximumPoolSize_ = Integer.MAX_VALUE;
    protected int minimumPoolSize_ = 1;
    protected long keepAliveTime_ = 60000L;
    protected boolean shutdown_ = false;
    protected final BlockingQueue handOff_;
    protected final Map threads_;
    protected BlockedExecutionHandler blockedExecutionHandler_;
    private BoundedRangeStatisticImpl freeThreads;
    private BoundedRangeStatisticImpl pooledThreads;
    private int num;
    private ThreadFactory threadFactory = new DaemonThreadFactory("Connector");

    public WorkExecutor(BlockingQueue blockingQueue) {
        this(blockingQueue, Integer.MAX_VALUE);
    }

    public WorkExecutor(BlockingQueue blockingQueue, int maxPoolSize) {
        this.maximumPoolSize_ = maxPoolSize;
        this.handOff_ = blockingQueue;
        this.runWhenBlocked();
        this.threads_ = new HashMap();
    }

    public WorkExecutor(WorkManager workManager, WorkQueue msgPool, int max, int step, BoundedRangeStatisticImpl freeThreads, BoundedRangeStatisticImpl pooledThreads) {
        this(msgPool, max);
        this.freeThreads = freeThreads;
        this.pooledThreads = pooledThreads;
        this.workManager = workManager;
        this.step = step;
        if (logger.isLoggable(JeusMessage_JCA1._1851_LEVEL)) {
            logger.log(JeusMessage_JCA1._1851_LEVEL, JeusMessage_JCA1._1851);
        }
    }

    /*
     * Exception decompiling
     */
    public void execute(WorkWrapper work, long rejectTimeout) throws WorkRejectedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean shutdown() {
        if (logger.isLoggable(JeusMessage_JCA1._1859_LEVEL)) {
            logger.log(JeusMessage_JCA1._1859_LEVEL, JeusMessage_JCA1._1859);
        }
        this.shutdownNow();
        boolean shutdowned = true;
        Map.Entry[] it = this.threads_.entrySet().toArray(new Map.Entry[0]);
        for (int i = 0; i < it.length; ++i) {
            Map.Entry entry = it[i];
            Worker worker = (Worker)entry.getKey();
            WorkWrapper work = worker.task;
            if (work != null) {
                if (logger.isLoggable(JeusMessage_JCA1._1860_LEVEL)) {
                    logger.log(JeusMessage_JCA1._1860_LEVEL, JeusMessage_JCA1._1860, (Object)work);
                }
                shutdowned = false;
                work.release();
                continue;
            }
            Thread thread = (Thread)entry.getValue();
            thread.interrupt();
        }
        if (logger.isLoggable(JeusMessage_JCA1._1861_LEVEL)) {
            logger.log(JeusMessage_JCA1._1861_LEVEL, JeusMessage_JCA1._1861, (Object)(shutdowned ? "" : "not yet"));
        }
        return shutdowned;
    }

    public synchronized int getMaximumPoolSize() {
        return this.maximumPoolSize_;
    }

    public synchronized void setMaximumPoolSize(int newMaximum) {
        if (newMaximum <= 0) {
            throw new IllegalArgumentException();
        }
        this.maximumPoolSize_ = newMaximum;
    }

    public synchronized int getMinimumPoolSize() {
        return this.minimumPoolSize_;
    }

    public synchronized void setMinimumPoolSize(int newMinimum) {
        if (newMinimum < 0) {
            throw new IllegalArgumentException();
        }
        this.minimumPoolSize_ = newMinimum;
    }

    public synchronized int getIncreaseStepSize() {
        return this.step;
    }

    public synchronized void setIncreaseStepSize(int step) {
        if (step < 0) {
            throw new IllegalArgumentException();
        }
        this.step = step;
    }

    public synchronized int getPoolSize() {
        return (int)this.pooledThreads.getCurrent();
    }

    public synchronized long getKeepAliveTime() {
        return this.keepAliveTime_;
    }

    public synchronized void setKeepAliveTime(long msecs) {
        this.keepAliveTime_ = msecs;
    }

    public synchronized BlockedExecutionHandler getBlockedExecutionHandler() {
        return this.blockedExecutionHandler_;
    }

    public synchronized void setBlockedExecutionHandler(BlockedExecutionHandler h) {
        this.blockedExecutionHandler_ = h;
    }

    protected void addThread(WorkWrapper command) {
        Worker worker = new Worker(command);
        Thread thread = this.threadFactory.newThread((Runnable)worker);
        thread.setName("JCA WORKER " + ++this.num);
        thread.setDaemon(true);
        this.pooledThreads.increase();
        this.threads_.put(worker, thread);
        if (command != null) {
            command.setState(1, null);
        }
        thread.start();
        this.workManager.createCount.increase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createThreads(int numberOfThreads) {
        if (logger.isLoggable(JeusMessage_JCA1._1862_LEVEL)) {
            logger.log(JeusMessage_JCA1._1862_LEVEL, JeusMessage_JCA1._1862, (Object)String.valueOf(numberOfThreads));
        }
        int ncreated = 0;
        for (int i = 0; i < numberOfThreads; ++i) {
            WorkExecutor workExecutor = this;
            synchronized (workExecutor) {
                if (this.pooledThreads.getCurrent() < (long)this.maximumPoolSize_) {
                    this.addThread(null);
                    ++ncreated;
                } else {
                    break;
                }
                continue;
            }
        }
        if (logger.isLoggable(JeusMessage_JCA1._1863_LEVEL)) {
            logger.log(JeusMessage_JCA1._1863_LEVEL, JeusMessage_JCA1._1863, (Object)String.valueOf(ncreated));
        }
        return ncreated;
    }

    public synchronized void interruptAll() {
        for (Thread t : this.threads_.values()) {
            t.interrupt();
        }
    }

    public void shutdownNow() {
        this.shutdownNow(new DiscardWhenBlocked());
    }

    public synchronized void shutdownNow(BlockedExecutionHandler handler) {
        this.setBlockedExecutionHandler(handler);
        this.shutdown_ = true;
        this.maximumPoolSize_ = 0;
        this.minimumPoolSize_ = 0;
    }

    public void shutdownAfterProcessingCurrentlyQueuedTasks() {
        this.shutdownAfterProcessingCurrentlyQueuedTasks(new DiscardWhenBlocked());
    }

    public synchronized void shutdownAfterProcessingCurrentlyQueuedTasks(BlockedExecutionHandler handler) {
        this.setBlockedExecutionHandler(handler);
        this.shutdown_ = true;
        if (this.pooledThreads.getCurrent() == 0L) {
            this.maximumPoolSize_ = 0;
            this.minimumPoolSize_ = 0;
        }
    }

    public synchronized boolean isTerminatedAfterShutdown() {
        return this.shutdown_ && this.pooledThreads.getCurrent() == 0L;
    }

    public synchronized boolean awaitTerminationAfterShutdown(long maxWaitTime) throws InterruptedException {
        if (!this.shutdown_) {
            throw new IllegalStateException();
        }
        if (this.pooledThreads.getCurrent() == 0L) {
            return true;
        }
        if (maxWaitTime < 0L) {
            return false;
        }
        this.wait(maxWaitTime);
        return this.pooledThreads.getCurrent() == 0L;
    }

    public synchronized void awaitTerminationAfterShutdown() throws InterruptedException {
        if (!this.shutdown_) {
            throw new IllegalStateException();
        }
        while (this.pooledThreads.getCurrent() > 0L) {
            this.wait();
        }
    }

    public List drain() {
        boolean wasInterrupted = false;
        Vector tasks = new Vector();
        while (true) {
            try {
                Object x;
                while ((x = this.handOff_.poll(0L, TimeUnit.MILLISECONDS)) != null) {
                    tasks.addElement(x);
                }
            }
            catch (InterruptedException ex) {
                wasInterrupted = true;
                continue;
            }
            break;
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
        return tasks;
    }

    protected synchronized void workerDone(Worker w) {
        this.threads_.remove(w);
        this.pooledThreads.decrease();
        if (this.pooledThreads.getCurrent() == 0L && this.shutdown_) {
            this.minimumPoolSize_ = 0;
            this.maximumPoolSize_ = 0;
            this.notifyAll();
        }
        this.workManager.shrinkCount.increase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorkWrapper getTask() throws InterruptedException {
        long waitTime;
        WorkExecutor workExecutor = this;
        synchronized (workExecutor) {
            if (this.pooledThreads.getCurrent() > (long)this.maximumPoolSize_) {
                return null;
            }
            waitTime = this.shutdown_ ? 0L : this.keepAliveTime_;
        }
        if (waitTime >= 0L) {
            return (WorkWrapper)this.handOff_.poll(waitTime, TimeUnit.MILLISECONDS);
        }
        return (WorkWrapper)this.handOff_.take();
    }

    public void runWhenBlocked() {
        this.setBlockedExecutionHandler(new RunWhenBlocked());
    }

    public void waitWhenBlocked() {
        this.setBlockedExecutionHandler(new WaitWhenBlocked());
    }

    public void discardWhenBlocked() {
        this.setBlockedExecutionHandler(new DiscardWhenBlocked());
    }

    public void abortWhenBlocked() {
        this.setBlockedExecutionHandler(new AbortWhenBlocked());
    }

    public void discardOldestWhenBlocked() {
        this.setBlockedExecutionHandler(new DiscardOldestWhenBlocked());
    }

    protected class DiscardOldestWhenBlocked
    implements BlockedExecutionHandler {
        protected DiscardOldestWhenBlocked() {
        }

        public boolean blockedAction(Runnable command) throws InterruptedException {
            WorkExecutor.this.handOff_.poll(0L, TimeUnit.MILLISECONDS);
            if (!WorkExecutor.this.handOff_.offer(command, 0L, TimeUnit.MILLISECONDS)) {
                command.run();
            }
            return true;
        }
    }

    protected class AbortWhenBlocked
    implements BlockedExecutionHandler {
        protected AbortWhenBlocked() {
        }

        public boolean blockedAction(Runnable command) {
            throw new RuntimeException("Pool is blocked");
        }
    }

    protected class DiscardWhenBlocked
    implements BlockedExecutionHandler {
        protected DiscardWhenBlocked() {
        }

        public boolean blockedAction(Runnable command) {
            return true;
        }
    }

    protected class WaitWhenBlocked
    implements BlockedExecutionHandler {
        protected WaitWhenBlocked() {
        }

        public boolean blockedAction(Runnable command) throws InterruptedException {
            WorkExecutor.this.handOff_.put(command);
            return true;
        }
    }

    protected class RunWhenBlocked
    implements BlockedExecutionHandler {
        protected RunWhenBlocked() {
        }

        public boolean blockedAction(Runnable command) {
            command.run();
            return true;
        }
    }

    public static interface BlockedExecutionHandler {
        public boolean blockedAction(Runnable var1) throws InterruptedException;
    }

    protected class Worker
    implements Runnable {
        public WorkWrapper task;

        protected Worker(WorkWrapper firstTask) {
            this.task = firstTask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (this.task != null) {
                    this.task.run();
                    ((WorkExecutor)WorkExecutor.this).workManager.useTime.addData(this.task.getUseTime());
                    WorkExecutor.this.freeThreads.increase();
                    this.task = null;
                }
                while ((this.task = WorkExecutor.this.getTask()) != null) {
                    WorkExecutor.this.freeThreads.decrease();
                    this.task.run();
                    ((WorkExecutor)WorkExecutor.this).workManager.useTime.addData(this.task.getUseTime());
                    WorkExecutor.this.freeThreads.increase();
                    this.task = null;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                WorkExecutor.this.workerDone(this);
            }
        }
    }
}

