/*
 * Decompiled with CFR 0.152.
 */
package jeus.connector.work;

import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import jeus.connector.work.WorkManager;
import jeus.transaction.ConnectorXATerminator;

public class WorkState {
    protected WorkManager workManager;
    protected Work work;
    protected long release;
    protected long timeout;
    protected long due;
    protected long requestedTime;
    protected long acceptTime;
    protected long rejectTime;
    protected long startTime;
    protected long completeTime;
    protected int state;
    protected boolean valid;
    protected ExecutionContext ctx;
    protected WorkListener lsnr;
    protected WorkException exception;
    public static final int ERROR = -1;
    protected ConnectorXATerminator xaResource;

    public WorkState(WorkManager workManager, ConnectorXATerminator terminator, Work work, long startLimit, long releaseLimit, ExecutionContext ctx, WorkListener lsnr) {
        this.workManager = workManager;
        this.work = work;
        this.ctx = ctx;
        this.lsnr = lsnr;
        this.release = releaseLimit;
        this.timeout = startLimit;
        this.requestedTime = System.currentTimeMillis();
        this.due = startLimit > 0L ? this.requestedTime + startLimit : 0L;
        this.xaResource = terminator;
        this.valid = true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[Work/" + this.work.hashCode());
        buf.append("] state : " + this.state);
        if (this.state >= 1) {
            buf.append(" accept elapsed : " + this.getAcceptElapsed());
        }
        if (this.state >= 3) {
            buf.append(", start elapsed : " + this.getStartElapsed());
        }
        if (this.state >= 4) {
            buf.append(", used time : " + this.getUseTime());
        }
        return buf.toString();
    }

    public long getAcceptElapsed() {
        return this.acceptTime - this.requestedTime;
    }

    public long getRejectElapsed() {
        return this.rejectTime - this.requestedTime;
    }

    public long getStartElapsed() {
        return this.startTime - this.acceptTime;
    }

    public long getCompleteElapsed() {
        return this.completeTime - this.startTime;
    }

    public long getUseTime() {
        return this.completeTime - this.acceptTime;
    }

    public long getAcceptTime() {
        return this.acceptTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getCompleteTime() {
        return this.completeTime;
    }
}

