/*
 * Decompiled with CFR 0.152.
 */
package jeus.connector.work;

import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkRejectedException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import jeus.connector.work.WorkManager;
import jeus.connector.work.WorkState;
import jeus.transaction.ConnectorXATerminator;
import jeus.util.logging.JeusLevel;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_JCA1;

public class WorkWrapper
extends WorkState
implements Work {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.connector");

    public WorkWrapper(WorkManager WorkManager2, ConnectorXATerminator terminator, Work work, long startLimit, long releaseLimit, ExecutionContext ctx, WorkListener lsnr) {
        super(WorkManager2, terminator, work, startLimit, releaseLimit, ctx, lsnr);
        if (logger.isLoggable(JeusMessage_JCA1._1951_LEVEL)) {
            logger.log(JeusMessage_JCA1._1951_LEVEL, JeusMessage_JCA1._1951);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean valid = this.setState(3, null);
        if (!valid) {
            if (logger.isLoggable(JeusMessage_JCA1._1952_LEVEL)) {
                logger.log(JeusMessage_JCA1._1952_LEVEL, JeusMessage_JCA1._1952);
            }
            return;
        }
        Xid xid = null;
        try {
            if (this.ctx != null && (xid = this.ctx.getXid()) != null) {
                if (logger.isLoggable(JeusMessage_JCA1._1953_LEVEL)) {
                    logger.log(JeusMessage_JCA1._1953_LEVEL, JeusMessage_JCA1._1953);
                }
                long timeout = this.ctx.getTransactionTimeout();
                this.xaResource.begin(xid, timeout);
            }
            if (logger.isLoggable(JeusMessage_JCA1._1954_LEVEL)) {
                logger.log(JeusMessage_JCA1._1954_LEVEL, JeusMessage_JCA1._1954);
            }
            this.work.run();
            if (logger.isLoggable(JeusMessage_JCA1._1955_LEVEL)) {
                logger.log(JeusMessage_JCA1._1955_LEVEL, JeusMessage_JCA1._1955);
            }
        }
        catch (XAException xae) {
            if (xae.errorCode == -8) {
                if (logger.isLoggable(JeusMessage_JCA1._1956_LEVEL)) {
                    logger.log(JeusMessage_JCA1._1956_LEVEL, JeusMessage_JCA1._1956, (Throwable)xae);
                }
                this.setState(-1, (WorkException)new WorkCompletedException(xae.getMessage(), "2"));
            } else {
                if (logger.isLoggable(JeusMessage_JCA1._1957_LEVEL)) {
                    logger.log(JeusMessage_JCA1._1957_LEVEL, JeusMessage_JCA1._1957, (Throwable)xae);
                }
                this.setState(-1, (WorkException)new WorkCompletedException(xae.getMessage(), "-1"));
            }
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_JCA1._1958_LEVEL)) {
                logger.log(JeusMessage_JCA1._1958_LEVEL, JeusMessage_JCA1._1958, (Object)this, t);
            }
            this.setState(-1, (WorkException)new WorkCompletedException(t.getMessage(), "-1"));
        }
        finally {
            if (xid != null) {
                if (logger.isLoggable(JeusMessage_JCA1._1959_LEVEL)) {
                    logger.log(JeusMessage_JCA1._1959_LEVEL, JeusMessage_JCA1._1959, (Object)xid);
                }
                this.xaResource.end(xid);
            }
            this.setState(4, null);
        }
    }

    public synchronized void waitState(int state) throws WorkException {
        if (logger.isLoggable(JeusMessage_JCA1._1960_LEVEL)) {
            logger.log(JeusMessage_JCA1._1960_LEVEL, JeusMessage_JCA1._1960);
        }
        while (!this.checkState(state)) {
            long remain;
            int prev = this.state;
            if (this.due == 0L) {
                remain = 0L;
            } else {
                remain = this.due - System.currentTimeMillis();
                if (remain == 0L) {
                    remain = -1L;
                }
            }
            if (remain >= 0L) {
                try {
                    if (logger.isLoggable(JeusMessage_JCA1._1961_LEVEL)) {
                        logger.log(JeusMessage_JCA1._1961_LEVEL, JeusMessage_JCA1._1961, (Object)String.valueOf(remain));
                    }
                    this.wait(remain);
                }
                catch (InterruptedException interruptedexception) {}
                continue;
            }
            if (prev >= 3) {
                if (logger.isLoggable(JeusMessage_JCA1._1962_LEVEL)) {
                    logger.log(JeusMessage_JCA1._1962_LEVEL, JeusMessage_JCA1._1962);
                }
                this.release();
                this.due = 0L;
                continue;
            }
            if (logger.isLoggable(JeusMessage_JCA1._1963_LEVEL)) {
                logger.log(JeusMessage_JCA1._1963_LEVEL, JeusMessage_JCA1._1963);
            }
            this.valid = false;
            throw new WorkRejectedException("work timeout : " + this.timeout + " msec");
        }
    }

    private boolean checkState(int state) throws WorkException {
        boolean ok;
        if (logger.isLoggable(JeusMessage_JCA1._1964_LEVEL)) {
            logger.log(JeusMessage_JCA1._1964_LEVEL, JeusMessage_JCA1._1964, (Object)String.valueOf(state));
        }
        if (this.state == -1) {
            if (logger.isLoggable(JeusMessage_JCA1._1965_LEVEL)) {
                logger.log(JeusMessage_JCA1._1965_LEVEL, JeusMessage_JCA1._1965, (Throwable)this.exception);
            }
            throw this.exception;
        }
        if (this.state == 2) {
            if (logger.isLoggable(JeusMessage_JCA1._1966_LEVEL)) {
                logger.log(JeusMessage_JCA1._1966_LEVEL, JeusMessage_JCA1._1966);
            }
            this.valid = false;
            throw new WorkRejectedException("submited work is rejected for internal reasons.");
        }
        boolean bl = ok = this.state >= state;
        if (logger.isLoggable(JeusMessage_JCA1._1967_LEVEL)) {
            logger.log(JeusMessage_JCA1._1967_LEVEL, JeusMessage_JCA1._1967, (Object)(ok ? "" : "not "));
        }
        return ok;
    }

    public synchronized boolean setState(int state, WorkException e) {
        if (logger.isLoggable(JeusMessage_JCA1._1968_LEVEL)) {
            logger.log(JeusMessage_JCA1._1968_LEVEL, JeusMessage_JCA1._1968, (Object)String.valueOf(state));
        }
        if (this.state == -1) {
            if (logger.isLoggable(JeusMessage_JCA1._1969_LEVEL)) {
                logger.log(JeusMessage_JCA1._1969_LEVEL, JeusMessage_JCA1._1969);
            }
            return false;
        }
        if (!this.valid) {
            if (logger.isLoggable(JeusMessage_JCA1._1970_LEVEL)) {
                logger.log(JeusMessage_JCA1._1970_LEVEL, JeusMessage_JCA1._1970);
            }
            return false;
        }
        int before = this.state;
        this.state = state;
        this.exception = e;
        this.dealState();
        if (logger.isLoggable(JeusLevel.DEV)) {
            logger.dev("[NAVIS/WorkState] state change from " + before + " to " + this + " : " + e);
        }
        if (logger.isLoggable(JeusMessage_JCA1._1971_LEVEL)) {
            logger.log(JeusMessage_JCA1._1971_LEVEL, JeusMessage_JCA1._1971, new Object[]{String.valueOf(before), this});
        }
        this.notify();
        return true;
    }

    private void dealState() {
        if (logger.isLoggable(JeusMessage_JCA1._1972_LEVEL)) {
            logger.log(JeusMessage_JCA1._1972_LEVEL, JeusMessage_JCA1._1972);
        }
        long current = System.currentTimeMillis();
        switch (this.state) {
            case 1: {
                this.acceptTime = current;
                if (this.lsnr != null) {
                    WorkEvent event = new WorkEvent((Object)this, this.state, this.work, this.exception);
                    this.lsnr.workAccepted(event);
                }
                if (logger.isLoggable(JeusMessage_JCA1._1973_LEVEL)) {
                    logger.log(JeusMessage_JCA1._1973_LEVEL, JeusMessage_JCA1._1973, (Object)String.valueOf(current));
                }
                this.workManager.acceptTime.addData(this.getAcceptElapsed());
                break;
            }
            case 3: {
                this.startTime = current;
                this.due = this.release > 0L ? this.startTime + this.release : 0L;
                long startElapsed = this.getStartElapsed();
                if (this.lsnr != null) {
                    WorkEvent event = new WorkEvent((Object)this, this.state, this.work, this.exception, startElapsed);
                    this.lsnr.workStarted(event);
                }
                if (logger.isLoggable(JeusMessage_JCA1._1974_LEVEL)) {
                    logger.log(JeusMessage_JCA1._1974_LEVEL, JeusMessage_JCA1._1974, (Object)String.valueOf(current));
                }
                this.workManager.startTime.addData(startElapsed);
                break;
            }
            case 4: {
                this.completeTime = current;
                if (this.lsnr != null) {
                    WorkEvent event = new WorkEvent((Object)this, this.state, this.work, this.exception);
                    this.lsnr.workCompleted(event);
                }
                if (logger.isLoggable(JeusMessage_JCA1._1975_LEVEL)) {
                    logger.log(JeusMessage_JCA1._1975_LEVEL, JeusMessage_JCA1._1975, (Object)String.valueOf(current));
                }
                this.workManager.completeTime.addData(this.getCompleteElapsed());
                break;
            }
            case 2: {
                this.rejectTime = current;
                if (this.lsnr != null) {
                    WorkEvent event = new WorkEvent((Object)this, this.state, this.work, this.exception);
                    this.lsnr.workRejected(event);
                }
                if (logger.isLoggable(JeusMessage_JCA1._1976_LEVEL)) {
                    logger.log(JeusMessage_JCA1._1976_LEVEL, JeusMessage_JCA1._1976, (Object)String.valueOf(current));
                }
                this.workManager.rejectTime.addData(this.getRejectElapsed());
                break;
            }
            case -1: {
                this.completeTime = current;
                if (logger.isLoggable(JeusMessage_JCA1._1977_LEVEL)) {
                    logger.log(JeusMessage_JCA1._1977_LEVEL, JeusMessage_JCA1._1977, (Object)String.valueOf(current));
                }
                this.workManager.completeTime.addData(this.getCompleteElapsed());
            }
        }
    }

    public void release() {
        this.work.release();
    }
}

