/*
 * Decompiled with CFR 0.152.
 */
package jeus.container.namingenv;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import jeus.container.namingenv.EnvRef;
import jeus.container.namingenv.InjectionInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassEnvInfo {
    protected Class targetClass;
    protected Map<String, EnvRef> entries = new HashMap<String, EnvRef>();
    protected Map<Member, InjectionInfo> injections = new LinkedHashMap<Member, InjectionInfo>();
    protected Method postConstructMethod;
    protected Method preDestroyMethod;

    ClassEnvInfo(Class cls) {
        this.targetClass = cls;
    }

    void init(Class cls) {
        this.targetClass = cls;
        this.entries.clear();
        this.injections.clear();
        this.postConstructMethod = null;
        this.preDestroyMethod = null;
    }

    Class getTargetClass() {
        return this.targetClass;
    }

    void addInjectionTarget(InjectionInfo injection) {
        Member member = injection.getMember();
        this.injections.put(member, injection);
    }

    Collection<EnvRef> entries() {
        return this.entries.values();
    }

    void addEntry(EnvRef entry) {
        this.entries.put(entry.getName(), entry);
    }

    InjectionInfo getInjectionInfo(Member member) {
        return this.injections.get(member);
    }

    Iterator<InjectionInfo> getInjectionInfoIterator() {
        return this.injections.values().iterator();
    }

    Method getPostConstructMethod() {
        return this.postConstructMethod;
    }

    void setPostConstructMethod(Method postConstructMethod) {
        this.postConstructMethod = postConstructMethod;
    }

    Method getPreDestroyMethod() {
        return this.preDestroyMethod;
    }

    void setPreDestroyMethod(Method preDestroyMethod) {
        this.preDestroyMethod = preDestroyMethod;
    }
}

