/*
 * Decompiled with CFR 0.152.
 */
package jeus.container.namingenv;

import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.naming.LinkRef;
import jeus.container.ExecutionModule;
import jeus.container.namingenv.EnvRef;
import jeus.container.namingenv.EnvironmentContext;
import jeus.container.namingenv.EnvironmentException;
import jeus.container.namingenv.JndiEnvironmentMappingGroup;
import jeus.ejb.EJBUtils;
import jeus.util.StringUtil;
import jeus.util.message.JeusMessage_EJB12;

public class EjbRef
extends EnvRef {
    protected String beanName;
    protected Class beanInterface;
    protected Boolean isHome;
    protected Boolean isRemote;

    public EjbRef(String name) {
        super(name);
    }

    public EjbRef(String name, String beanName, Class beanInterface) {
        super(name);
        this.beanName = beanName;
        this.beanInterface = beanInterface;
        this.setIsHome();
    }

    public String getBeanName() {
        return this.beanName;
    }

    public Class getBeanInterface() {
        return this.beanInterface;
    }

    private void setIsHome() {
        this.isHome = EJBHome.class.isAssignableFrom(this.beanInterface) || EJBLocalHome.class.isAssignableFrom(this.beanInterface) ? Boolean.valueOf(true) : Boolean.valueOf(false);
    }

    public Boolean isHome() {
        return this.isHome;
    }

    public Boolean isRemote() {
        return this.isRemote;
    }

    public void setRemote(boolean remote) {
        this.isRemote = remote;
    }

    public void setType(Class type) {
        if (this.beanInterface == null) {
            this.beanInterface = type;
            this.setIsHome();
        }
    }

    public void setEjbLink(String ejblink) {
        this.beanName = ejblink;
    }

    public Object getBindingObject(EnvironmentContext context) throws EnvironmentException {
        String jndiName = this.getJndiName(context);
        if (jndiName == null) {
            if (logger.isLoggable(JeusMessage_EJB12._9102_LEVEL)) {
                logger.log(JeusMessage_EJB12._9102_LEVEL, JeusMessage_EJB12._9102, (Object)this.name);
            }
            throw new EnvironmentException("There is no mapping for environment entry '" + this.name + "'");
        }
        return new LinkRef(jndiName);
    }

    public String getJndiName(EnvironmentContext context) {
        String jndiName = this.getMappedJndiName(context.getEnvironmentMapping());
        if (jndiName == null) {
            jndiName = this.mappedName;
        }
        if (jndiName != null && this.beanInterface != null) {
            assert (this.isHome != null);
            jndiName = EJBUtils.getActualEjbJndiName(jndiName, this.isHome == false, this.beanInterface.getName());
        }
        if (context.isServerMode()) {
            ExecutionModule module = context.getModule();
            if (jndiName == null && !StringUtil.isNullOrEmpty((String)this.beanName)) {
                String intfName = this.beanInterface == null ? null : this.beanInterface.getName();
                jndiName = module.getEJBJndiName(this.beanName, intfName, this.isRemote);
            }
            if (jndiName == null && this.beanInterface != null) {
                jndiName = module.getEJBJndiName("", this.beanInterface.getName(), this.isRemote);
            }
        }
        if (jndiName == null) {
            jndiName = this.beanInterface.getName();
            logger.info("There is no mapping for ejb-ref '" + this.name + "', so the default JNDI name is '" + jndiName + "'");
        }
        return jndiName;
    }

    private String getMappedJndiName(JndiEnvironmentMappingGroup mapping) {
        return this.getMatchingJndiName(mapping.getEjbRefMapping());
    }
}

