/*
 * Decompiled with CFR 0.152.
 */
package jeus.container.namingenv;

import java.util.HashMap;
import java.util.Map;
import jeus.container.ExecutionModule;
import jeus.container.namingenv.JndiEnvironmentMappingGroup;

public class EnvironmentContext {
    protected Map<String, Object> context = new HashMap<String, Object>(4);
    protected ExecutionModule module;
    protected JndiEnvironmentMappingGroup environmentMapping;
    protected String rootArchiveUri;
    protected boolean clientMode;

    public EnvironmentContext(JndiEnvironmentMappingGroup mapping) {
        assert (mapping != null);
        this.environmentMapping = mapping;
        this.clientMode = true;
    }

    public EnvironmentContext(ExecutionModule module, JndiEnvironmentMappingGroup mapping) {
        assert (module != null);
        assert (mapping != null);
        this.module = module;
        this.environmentMapping = mapping;
        this.rootArchiveUri = module.getRootArchive().getArchiveUri();
    }

    public boolean contains(String key) {
        return this.context.containsKey(key);
    }

    public Object getContextData(String key) {
        return this.context.get(key);
    }

    public void setContextData(String key, Object value) {
        this.context.put(key, value);
    }

    public ExecutionModule getModule() {
        return this.module;
    }

    public JndiEnvironmentMappingGroup getEnvironmentMapping() {
        return this.environmentMapping;
    }

    public boolean isServerMode() {
        return !this.clientMode;
    }

    public String getRootArchiveUri() {
        return this.rootArchiveUri;
    }

    public void setRootArchiveUri(String rootArchiveUri) {
        this.rootArchiveUri = rootArchiveUri;
    }
}

