/*
 * Decompiled with CFR 0.152.
 */
package jeus.container.namingenv;

import java.util.List;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.xml.ws.handler.HandlerResolver;
import jeus.container.namingenv.EnvRef;
import jeus.container.namingenv.EnvironmentContext;
import jeus.container.namingenv.EnvironmentException;
import jeus.container.namingenv.NamingEnvironment;
import jeus.jndi.objectfactory.ObjectRefAddr;
import jeus.webservices.api.EWSProvider;
import jeus.xml.binding.j2ee.ServiceRefHandlerChainsType;
import jeus.xml.binding.j2ee.ServiceRefType;
import jeus.xml.binding.jeusDD.JeusWebservicesClientDdType;
import jeus.xml.binding.jeusDD.ServiceClientType;

public class ServiceRef
extends EnvRef {
    protected Class type;
    private Class serviceClass;
    private String wsdlLocation;
    private Class declaringClass;
    private HandlerResolver handlerResolver;
    private ServiceRefType serviceStdDd;

    public ServiceRef(String name) {
        super(name);
    }

    public ServiceRef(String name, Class declaringClass, Class type, Class value, String wsdlLocation) {
        super(name);
        this.type = type;
        this.serviceClass = value;
        this.wsdlLocation = wsdlLocation;
        this.declaringClass = declaringClass;
    }

    public Object getBindingObject(EnvironmentContext context) throws EnvironmentException {
        JeusWebservicesClientDdType serviceRefMapping = context.getEnvironmentMapping().getServiceRefMapping();
        ServiceClientType serviceExtDd = null;
        if (serviceRefMapping != null) {
            List serviceClient = serviceRefMapping.getServiceClient();
            for (ServiceClientType serviceClientType : serviceClient) {
                if (!serviceClientType.getServiceRefName().equals(this.name)) continue;
                serviceExtDd = serviceClientType;
                break;
            }
        }
        Reference ref = new Reference(this.serviceClass.getName(), "jeus.webservices.ws4ee12.JaxWsServiceReferenceFactory", null);
        String archiveUri = context.getRootArchiveUri();
        if (context.isServerMode()) {
            context.getModule().processPortComponentlink(serviceExtDd, this.serviceStdDd);
        }
        ref.add(new StringRefAddr("archiveUri", archiveUri));
        ref.add(new StringRefAddr("type", this.type != null ? this.type.getName() : null));
        ref.add(new StringRefAddr("wsdlLocation", this.wsdlLocation));
        ref.add(new ObjectRefAddr("serviceStdDd", this.serviceStdDd));
        ref.add(new ObjectRefAddr("serviceExtDd", serviceExtDd));
        ref.add(new StringRefAddr("declaringClass", this.declaringClass != null ? this.declaringClass.getName() : null));
        ref.add(new ObjectRefAddr("handlerResolver", this.handlerResolver));
        return ref;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public Class getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(Class serviceClass) {
        this.serviceClass = serviceClass;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public void setServiceStdDd(ServiceRefType serviceStdDd) {
        this.serviceStdDd = serviceStdDd;
    }

    public void processHandlerFile(String file, NamingEnvironment env) throws Exception {
        EWSProvider provider = EWSProvider.getProvider();
        if (provider != null) {
            this.handlerResolver = provider.createHandlerResolver(this.declaringClass, file, env);
        }
    }

    public void processHandlerChains(ServiceRefHandlerChainsType handlerChains, NamingEnvironment env) throws Exception {
        EWSProvider provider = EWSProvider.getProvider();
        if (provider != null) {
            this.handlerResolver = provider.createHandlerResolver(this.declaringClass, handlerChains, env);
        }
    }
}

