/*
 * Decompiled with CFR 0.152.
 */
package jeus.container.util;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class IntrospectionUtil {
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";

    public static String getPropertyName(Method method) throws IntrospectionException {
        Property property = IntrospectionUtil.extractProperty(method);
        if (property == null) {
            throw new IntrospectionException("Not JavaBean property");
        }
        return property.name;
    }

    public static Class getPropertyType(Method method) throws IntrospectionException {
        Property property = IntrospectionUtil.extractProperty(method);
        if (property == null) {
            throw new IntrospectionException("Not JavaBean property");
        }
        return property.type;
    }

    public static PropertyDescriptor getPropertyDesriptor(Method method) throws IntrospectionException {
        return null;
    }

    public static boolean isPropertyMethod(Method method) {
        Property property = IntrospectionUtil.extractProperty(method);
        return property != null;
    }

    public static boolean isGetter(Method method) {
        Property property = IntrospectionUtil.extractProperty(method);
        return property != null && property.kind == PropertyKind.GETTER;
    }

    public static boolean isSetter(Method method) {
        Property property = IntrospectionUtil.extractProperty(method);
        return property != null && property.kind == PropertyKind.SETTER;
    }

    public static Method[] getSetterMethods(Class cls, String propertyName) {
        Method[] methods = cls.getDeclaredMethods();
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : methods) {
            Class<?> returnType = method.getReturnType();
            String name = method.getName();
            if (returnType != Void.TYPE || !name.startsWith(SET_PREFIX) || !propertyName.equals(IntrospectionUtil.decapitalize(name.substring(3)))) continue;
            list.add(method);
        }
        return list.toArray(new Method[list.size()]);
    }

    public static Method getSetterMethod(Class cls, String propertyName, Class type) {
        assert (cls != null && propertyName != null);
        String name = SET_PREFIX + IntrospectionUtil.capitalize(propertyName);
        try {
            if (type != null) {
                return cls.getDeclaredMethod(name, type);
            }
            for (Method m : cls.getDeclaredMethods()) {
                if (!m.getName().equals(name)) continue;
                return m;
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return null;
    }

    private static Property extractProperty(Method method) {
        if (method == null) {
            return null;
        }
        int mods = method.getModifiers();
        String name = method.getName();
        Class<?> returnType = method.getReturnType();
        Class<?>[] argTypes = method.getParameterTypes();
        int argCount = argTypes.length;
        Property property = null;
        if (argCount == 0) {
            if (returnType != Void.TYPE && name.startsWith(GET_PREFIX)) {
                String propertyName = IntrospectionUtil.decapitalize(name.substring(3));
                property = new Property(PropertyKind.GETTER, propertyName, returnType, method);
            } else if (returnType == Boolean.TYPE && name.startsWith(IS_PREFIX)) {
                String propertyName = IntrospectionUtil.decapitalize(name.substring(2));
                property = new Property(PropertyKind.GETTER, propertyName, Boolean.TYPE, method);
            }
        } else if (argCount == 1 && returnType == Void.TYPE && name.startsWith(SET_PREFIX)) {
            String propertyName = IntrospectionUtil.decapitalize(name.substring(3));
            property = new Property(PropertyKind.SETTER, propertyName, argTypes[0], method);
        }
        return property;
    }

    private static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    private static class Property {
        PropertyKind kind;
        String name;
        Class type;
        Method method;

        Property(PropertyKind kind, String name, Class type, Method method) {
            this.kind = kind;
            this.name = name;
            this.type = type;
            this.method = method;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PropertyKind {
        GETTER,
        SETTER;

    }
}

