/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.command;

import java.util.Map;
import javax.enterprise.deploy.spi.TargetModuleID;
import jeus.deploy.ObjectNameTarget;
import jeus.deploy.command.CommandException;
import jeus.deploy.command.CommandUtils;
import jeus.deploy.command.ICommand;
import jeus.deploy.status.JeusProgressObject;
import jeus.management.enterprise.agent.MEJBUtility;
import jeus.security.base.Subject;
import jeus.security.spi.LoginService;
import jeus.util.JeusRuntimeException;

public abstract class AbstractCommand
implements ICommand {
    private MEJBUtility msFacade;
    private JeusProgressObject po;
    private ObjectNameTarget target;
    private TargetModuleID targetModuleID;
    private Subject currentSubject;

    public void setParameters(Map paramsMap) {
        this.po = (JeusProgressObject)paramsMap.get("jeus.deploy.commmand.ICommand.ProgressObject");
        this.target = (ObjectNameTarget)paramsMap.get("jeus.deploy.commmand.ICommand.Target");
        this.targetModuleID = (TargetModuleID)paramsMap.get("jeus.deploy.commmand.ICommand.TargetModuleID");
        this.msFacade = (MEJBUtility)paramsMap.get("jeus.deploy.commmand.ICommand.MEJBUtiltiy");
        this.currentSubject = (Subject)paramsMap.get("jeus.deploy.commmand.ICommand.Subject");
    }

    public TargetModuleID getTargetModuleID() {
        return this.targetModuleID;
    }

    public void setTargetModuleID(TargetModuleID targetModuleID) {
        this.targetModuleID = targetModuleID;
    }

    public ObjectNameTarget getTarget() {
        return this.target;
    }

    public JeusProgressObject getJeusProgressObject() {
        return this.po;
    }

    public Subject getSubject() {
        return this.currentSubject;
    }

    public void run() {
        try {
            this.prepareBeforeCommand();
            CommandUtils.fireRunningEvent(this);
            this.doCommand();
        }
        catch (Throwable e) {
            System.err.println("Deployment Exception Occurred: " + e.getMessage());
            this.cleanupAfterCommand();
            if (e instanceof Exception) {
                CommandUtils.fireFailedEvent(this, (Exception)e);
            } else {
                CommandUtils.fireFailedEvent(this, new CommandException(e));
            }
            return;
        }
        this.cleanupAfterCommand();
        CommandUtils.fireCompletedEvent(this);
    }

    protected void prepareBeforeCommand() {
        try {
            LoginService.login(this.currentSubject);
            if (this.msFacade == null) {
                this.msFacade = MEJBUtility.getMEJBUtility();
            }
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }

    public MEJBUtility getMBeanServerFacade() {
        return this.msFacade;
    }

    protected void cleanupAfterCommand() {
        try {
            LoginService.logout();
        }
        catch (Throwable e) {
            throw new JeusRuntimeException("Exception occurred", e);
        }
    }

    protected abstract void doCommand() throws Exception;
}

