/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.command;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import jeus.deploy.JeusDeploymentManager;
import jeus.deploy.ObjectNameTarget;
import jeus.deploy.archivist.FileArchive;
import jeus.deploy.command.CommandBarrier;
import jeus.deploy.command.CommandException;
import jeus.deploy.command.CommandFactory;
import jeus.deploy.command.CommandUtils;
import jeus.deploy.command.ICommand;
import jeus.deploy.status.JeusProgressObject;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEServerMBean;
import jeus.security.base.Subject;
import jeus.security.spi.LoginService;
import jeus.util.JeusRuntimeException;
import jeus.util.PooledExecutorFactory;
import jeus.util.concurrent50.concurrent.Executor;
import jeus.util.logging.JeusLogger;
import jeus.util.properties.JeusPropertyValues;
import jeus.xml.binding.jeusDD.ApplicationType;
import jeus.xml.binding.jeusDD.EjbComponentType;

public class DeploymentCommander {
    private static long DEFAULT_WAITTIME = 1000L;
    private static int DEFAULT_MAX_POOL_SIZE = 10;
    private static final Executor threadPool = PooledExecutorFactory.createPooledExecutor((String)"DeploymentCommander", (int)DEFAULT_MAX_POOL_SIZE);
    private long waitTime = DEFAULT_WAITTIME;
    private Subject currentSubject;
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.deploy");

    public void setCurrentSubject(Subject currentSubject) {
        this.currentSubject = currentSubject;
    }

    public void setWaitTime(long msec) {
        this.waitTime = msec;
    }

    protected void doWork(Object[] targets, Map paramsMap, CommandBarrier barrier) {
        ICommand command = null;
        for (Object target : targets) {
            if (targets instanceof Target[]) {
                paramsMap.put("jeus.deploy.commmand.ICommand.Target", target);
            } else {
                paramsMap.put("jeus.deploy.commmand.ICommand.TargetModuleID", target);
            }
            try {
                command = CommandFactory.createCommand(paramsMap);
                threadPool.execute((Runnable)command);
            }
            catch (Exception e) {
                if (JeusPropertyValues.JEUS_CTS && command.getCommandType().equals(CommandType.UNDEPLOY) && e instanceof InstanceNotFoundException) {
                    CommandUtils.fireCompletedEvent(command);
                    continue;
                }
                CommandUtils.fireFailedEvent(command, e);
            }
        }
        this.waitUntilDone(barrier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitUntilDone(CommandBarrier barrier) {
        CommandBarrier commandBarrier = barrier;
        synchronized (commandBarrier) {
            while (!barrier.isCompleted()) {
                try {
                    if (this.waitTime < 0L) continue;
                    barrier.wait(this.waitTime);
                }
                catch (InterruptedException e) {
                    throw new CommandException(e);
                }
            }
            return;
        }
    }

    public void distribute(Target[] targets, ApplicationType config, MBeanServerConnection msFacade, JeusProgressObject po, boolean autoSrcDistribute, String contextGroup, String context, String docbase) {
        if (targets == null || targets.length == 0) {
            return;
        }
        if (targets.length > 1 && !this.deployable(targets, msFacade, config)) {
            throw new CommandException("Each container has a different jar file (check the each apphome) or two more containers cannot deploy an exploded module.");
        }
        CommandBarrier barrier = new CommandBarrier(targets.length);
        po.addProgressListener(barrier);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("jeus.deploy.commmand.ICommand.MEJBUtiltiy", msFacade);
        paramsMap.put("jeus.deploy.commmand.ICommand.ProgressObject", po);
        paramsMap.put("jeus.deploy.commmand.ICommand.CommandType", CommandType.DISTRIBUTE);
        this.prepareCurrentSubject(paramsMap);
        try {
            ApplicationType t = (ApplicationType)config.cloneType();
            paramsMap.put("jeus.deploy.commmand.DistributeCommand.Config", t);
        }
        catch (JAXBException jaxbe) {
            // empty catch block
        }
        if (docbase != null) {
            paramsMap.put("jeus.deploy.commmand.DistributeCommand.ContextGroup", contextGroup);
            paramsMap.put("jeus.deploy.commmand.DistributeCommand.ContextName", context);
            paramsMap.put("jeus.deploy.commmand.DistributeCommand.Docbase", docbase);
            autoSrcDistribute = true;
        }
        if (autoSrcDistribute) {
            paramsMap.put("jeus.deploy.commmand.ICommand.Target", targets[0]);
            ICommand leaderCommand = CommandFactory.createCommand(paramsMap);
            leaderCommand.run();
            if (targets.length > 1) {
                if (!barrier.getCompletedList().isEmpty()) {
                    List appList = config.getNameAndPathAndDeploymentType();
                    for (JAXBElement anAppList : appList) {
                        Object obj = anAppList.getValue();
                        if (!(obj instanceof EjbComponentType)) continue;
                        try {
                            ApplicationType fastConfig = config.cloneApplicationType();
                            paramsMap.put("jeus.deploy.commmand.DistributeCommand.Config", fastConfig);
                        }
                        catch (JAXBException e) {}
                    }
                }
                paramsMap.put("jeus.deploy.commmand.DistributeCommand.Leader", targets[0]);
                Object[] remains = new Target[targets.length - 1];
                System.arraycopy(targets, 1, remains, 0, targets.length - 1);
                this.doWork(remains, paramsMap, barrier);
            }
        } else {
            this.doWork(targets, paramsMap, barrier);
        }
        po.setResultTargetModuleIDs(barrier.getCompletedList());
        po.removeProgressListener(barrier);
    }

    private boolean deployable(Target[] targets, MBeanServerConnection msFacade, ApplicationType config) {
        try {
            JeusDeploymentManager.isExploded(config);
        }
        catch (JeusRuntimeException e) {
            String fileName = JeusDeploymentManager.getApplicationPath(config);
            ObjectName[] objNames = new ObjectName[targets.length];
            for (int i = 0; i < objNames.length; ++i) {
                objNames[i] = ((ObjectNameTarget)targets[i]).getObjectName();
            }
            J2EEServerMBean[] servers = JMXUtility.getProxy(msFacade, objNames, J2EEServerMBean.class, false);
            Vector<String> moduleFullPaths = new Vector<String>();
            block3: for (J2EEServerMBean server : servers) {
                ArrayList appArchives = server.getAppArchives();
                for (Object appArchive : appArchives) {
                    FileArchive fileArchive = (FileArchive)appArchive;
                    File deployModuleFile = fileArchive.getFile(fileName);
                    if (deployModuleFile == null) continue;
                    moduleFullPaths.add(deployModuleFile.getAbsolutePath());
                    continue block3;
                }
            }
            String aPath = (String)moduleFullPaths.get(1);
            for (int i = 1; i < moduleFullPaths.size(); ++i) {
                String anotherPath = (String)moduleFullPaths.get(i);
                if (aPath.equals(anotherPath)) continue;
                return false;
            }
        }
        return true;
    }

    private void prepareCurrentSubject(Map paramsMap) {
        if (this.currentSubject == null) {
            try {
                paramsMap.put("jeus.deploy.commmand.ICommand.Subject", LoginService.getCurrentSubject());
            }
            catch (Exception exception) {}
        } else {
            paramsMap.put("jeus.deploy.commmand.ICommand.Subject", this.currentSubject);
        }
    }

    public void distribute(Target[] targets, ApplicationType config, MBeanServerConnection msFacade, JeusProgressObject po, boolean autoSrcDistribute) {
        this.distribute(targets, config, msFacade, po, autoSrcDistribute, null, null, null);
    }

    public void start(TargetModuleID[] targets, MBeanServerConnection msFacade, JeusProgressObject po) {
        this.status(CommandType.START, msFacade, targets, po);
    }

    public void stop(TargetModuleID[] targets, MBeanServerConnection msFacade, JeusProgressObject po) {
        this.status(CommandType.STOP, msFacade, targets, po);
    }

    public void undeploy(TargetModuleID[] targets, MBeanServerConnection msFacade, JeusProgressObject po) {
        this.status(CommandType.UNDEPLOY, msFacade, targets, po);
    }

    public void redeploy() {
    }

    protected void status(CommandType commandType, MBeanServerConnection msFacade, TargetModuleID[] targets, JeusProgressObject po) {
        if (targets == null || targets.length == 0) {
            return;
        }
        CommandBarrier barrier = new CommandBarrier(targets.length);
        po.addProgressListener(barrier);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("jeus.deploy.commmand.ICommand.MEJBUtiltiy", msFacade);
        paramsMap.put("jeus.deploy.commmand.ICommand.ProgressObject", po);
        paramsMap.put("jeus.deploy.commmand.ICommand.CommandType", commandType);
        this.prepareCurrentSubject(paramsMap);
        this.doWork(targets, paramsMap, barrier);
        po.setResultTargetModuleIDs(barrier.getCompletedList());
        po.removeProgressListener(barrier);
    }
}

