/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.config;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jeus.deploy.config.DConfigBeanRootSpecification;
import jeus.deploy.config.JeusDConfigBeanRoot;
import jeus.deploy.io.ConfigurationDeploymentDescriptorFile;
import jeus.deploy.io.runtime.AppClientRuntimeDDFile;
import jeus.deploy.io.runtime.ApplicationRuntimeDDFile;
import jeus.deploy.io.runtime.ConnectorRuntimeDDFile;
import jeus.deploy.io.runtime.EjbRuntimeDDFile;
import jeus.deploy.io.runtime.WebRuntimeDDFile;
import jeus.deploy.io.runtime.WebservicesRuntimeDDFile;
import jeus.service.descriptor.DescriptorFile;
import jeus.xml.util.ClasspathLocation;
import jeus.xml.util.DomProcessor;
import jeus.xml.util.ElementOrderTable;
import jeus.xml.util.ElementOrderTableSource;
import jeus.xml.util.ElementSort;
import org.w3c.dom.Document;

public class DConfigDocumentFactory {
    public static final String JEUS_APPLICATION_DD_FILENAME = "META-INF/jeus-application-dd.xml";
    public static final String JEUS_EJB_DD_FILENAME = "META-INF/jeus-ejb-dd.xml";
    public static final String JEUS_WEB_DD_FILENAME = "META-INF/jeus-web-dd.xml";
    public static final String JEUS_CONNECTOR_DD_FILENAME = "META-INF/jeus-connetor-dd.xml";
    public static final String JEUS_CLIENT_DD_FILENAME = "META-INF/jeus-client-dd.xml";
    public static final String EJB_JEUS_WEBSERVICES_DD_FILENAME = "META-INF/jeus-webservices-dd.xml";
    public static final String WAR_JEUS_WEBSERVICES_DD_FILENAME = "WEB-INF/jeus-webservices-dd.xml";
    public static final String EJB_WEBSERVICES_FILENAME = "META-INF/webservices.xml";
    public static final String WAR_WEBSERVICES_FILENAME = "WEB-INF/webservices.xml";
    private static ElementOrderTableSource xsoSource = new ElementOrderTableSource(new ClasspathLocation("jeus/xml/binding/resource"));

    public static void saveDocument(OutputStream out, JeusDConfigBeanRoot beanRoot) throws Exception {
        Document document = beanRoot.getNode().getOwnerDocument();
        ElementOrderTable t = xsoSource.getElementOrderTable(document);
        if (t != null) {
            ElementSort.sort(document, t);
        }
        DomProcessor.serialize(document, out);
    }

    public static Document createDocument(InputStream is, DConfigBeanRootSpecification specification) {
        return DConfigDocumentFactory.createDocument(is, specification.getFilename());
    }

    public static Document createDocument(DConfigBeanRootSpecification specification) {
        try {
            StringBuffer buf = new StringBuffer();
            buf.append("<?xml version=\"1.0\"?>");
            buf.append("<jeus:" + specification.getRootElement() + " xmlns:jeus=\"" + specification.getNamespace() + "\"/>");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new ByteArrayInputStream(buf.toString().getBytes()));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Document createDocument(InputStream is, String filename) {
        ConfigurationDeploymentDescriptorFile descriptor = null;
        if (filename.equals(JEUS_APPLICATION_DD_FILENAME)) {
            descriptor = new ApplicationRuntimeDDFile();
        } else if (filename.equals(JEUS_EJB_DD_FILENAME)) {
            descriptor = new EjbRuntimeDDFile();
        } else if (filename.equals(JEUS_WEB_DD_FILENAME)) {
            descriptor = new WebRuntimeDDFile(null);
        } else if (filename.equals(JEUS_CONNECTOR_DD_FILENAME)) {
            descriptor = new ConnectorRuntimeDDFile();
        } else if (filename.equals(JEUS_CLIENT_DD_FILENAME)) {
            descriptor = new AppClientRuntimeDDFile();
        } else if (filename.equals(EJB_JEUS_WEBSERVICES_DD_FILENAME)) {
            descriptor = new WebservicesRuntimeDDFile("META-INF");
        } else if (filename.equals(WAR_JEUS_WEBSERVICES_DD_FILENAME)) {
            descriptor = new WebservicesRuntimeDDFile("WEB-INF");
        }
        if (descriptor == null) {
            return null;
        }
        try {
            InputStream xsInputStream = ((DescriptorFile)descriptor).getSchemaBasedStream(is);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(xsInputStream);
        }
        catch (Exception e) {
            return null;
        }
    }
}

