/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.exceptions.DDBeanCreateException;
import javax.enterprise.deploy.shared.ModuleType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.io.AppClientDeploymentDescriptorFile;
import jeus.deploy.io.ApplicationDeploymentDescriptorFile;
import jeus.deploy.io.ConnectorDeploymentDescriptorFile;
import jeus.deploy.io.DeploymentDescriptorFile;
import jeus.deploy.io.EjbDeploymentDescriptorFile;
import jeus.deploy.io.WebDeploymentDescriptorFile;
import jeus.deploy.io.WebservicesDeploymentDescriptorFile;
import jeus.deploy.model.JeusDDBean;
import jeus.deploy.model.JeusDeployableObject;
import jeus.deploy.util.ModuleTypeResolver;
import jeus.service.descriptor.DescriptorFile;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JeusDDBeanRoot
extends JeusDDBean
implements DDBeanRoot {
    private static final Map ROOT_VERSIONS = new HashMap();
    private JeusDeployableObject deployObject;
    private String filename;
    private ModuleType moduleType;

    public JeusDDBeanRoot(JeusDeployableObject deployObject, String filename) throws DDBeanCreateException {
        this.deployObject = deployObject;
        this.filename = filename;
        this.xPath = "/";
        this.ddBeanRoot = this;
        try {
            this.moduleType = ModuleTypeResolver.getModuleType(deployObject.getArchive());
            this.prepareDocument(deployObject);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void prepareDocument(JeusDeployableObject jarObj) throws DDBeanCreateException, IOException {
        InputStream deployInst = null;
        try {
            AbstractArchive myArch = jarObj.getArchive();
            DeploymentDescriptorFile descriptor = null;
            if (this.moduleType == ModuleType.EJB) {
                descriptor = this.filename.endsWith("webservices.xml") ? new WebservicesDeploymentDescriptorFile("META-INF") : new EjbDeploymentDescriptorFile();
            } else if (this.moduleType == ModuleType.WAR) {
                descriptor = this.filename.endsWith("webservices.xml") ? new WebservicesDeploymentDescriptorFile("META-INF") : new WebDeploymentDescriptorFile();
            } else if (this.moduleType == ModuleType.RAR) {
                descriptor = new ConnectorDeploymentDescriptorFile();
            } else if (this.moduleType == ModuleType.CAR) {
                descriptor = new AppClientDeploymentDescriptorFile();
            } else if (this.moduleType == ModuleType.EAR) {
                descriptor = new ApplicationDeploymentDescriptorFile();
            }
            deployInst = ((DescriptorFile)descriptor).getSchemaBasedStream(descriptor.getDescriptorStream(myArch));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.node = builder.parse(deployInst).getDocumentElement();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DDBeanCreateException(e.getMessage());
        }
        finally {
            if (deployInst != null) {
                deployInst.close();
                deployInst = null;
            }
        }
    }

    public ModuleType getType() {
        return this.moduleType;
    }

    public DeployableObject getDeployableObject() {
        return this.deployObject;
    }

    public String getModuleDTDVersion() {
        return null;
    }

    public String getDDBeanRootVersion() {
        NamedNodeMap attrs = this.node.getAttributes();
        Node version = attrs.getNamedItemNS(this.node.getNamespaceURI(), "version");
        if (version != null) {
            return version.getNodeValue();
        }
        return (String)ROOT_VERSIONS.get(this.node.getLocalName());
    }

    public String getFilename() {
        return this.filename;
    }

    static {
        ROOT_VERSIONS.put("application", "1.4");
        ROOT_VERSIONS.put("ejb-jar", "1.4");
        ROOT_VERSIONS.put("web-app", "2.4");
        ROOT_VERSIONS.put("connector", "1.5");
        ROOT_VERSIONS.put("application-client", "1.4");
        ROOT_VERSIONS.put("webservices", "1.1");
    }
}

