/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.status;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import jeus.deploy.status.DeploymentStatusImpl;

public class JeusProgressObject
implements ProgressObject {
    protected DeploymentStatusImpl deploymentStatus;
    protected Set completedModuleIDSet = Collections.synchronizedSet(new HashSet());
    protected Vector deliveredEvents = new Vector();
    protected Vector listeners = new Vector();
    protected Object commandType;
    protected int targetNumber = 0;
    JeusProgressObject parentProgress = null;
    JeusProgressObject childProgress = null;

    public JeusProgressObject() {
        this.deploymentStatus = null;
    }

    public JeusProgressObject(Object cmdType, int targetNum) {
        this.commandType = cmdType;
        this.targetNumber = targetNum;
        this.deploymentStatus = cmdType instanceof CommandType ? new DeploymentStatusImpl(StateType.RUNNING, (CommandType)cmdType) : new DeploymentStatusImpl(StateType.RUNNING, "deploy");
    }

    public JeusProgressObject(JeusProgressObject pProgress) {
        this.parentProgress = pProgress;
        pProgress.setChildProgress(this);
        this.commandType = pProgress.getCommandType();
        this.targetNumber = pProgress.getTargetNumber();
    }

    public Object getCommandType() {
        return this.commandType;
    }

    public int getTargetNumber() {
        return this.targetNumber;
    }

    public void setChildProgress(JeusProgressObject cProgress) {
        this.childProgress = cProgress;
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.deploymentStatus;
    }

    public void setDeploymentStatus(DeploymentStatus value) {
        this.deploymentStatus = (DeploymentStatusImpl)value;
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return this.completedModuleIDSet.toArray(new TargetModuleID[this.completedModuleIDSet.size()]);
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        return null;
    }

    public boolean isCancelSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("cancel not supported");
    }

    public boolean isStopSupported() {
        return false;
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("stop not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressListener(ProgressListener pol) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(pol);
            if (this.deliveredEvents.size() > 0) {
                Iterator i = this.deliveredEvents.iterator();
                while (i.hasNext()) {
                    pol.handleProgressEvent((ProgressEvent)i.next());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressListener(ProgressListener pol) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.remove(pol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireProgressEvent(ProgressEvent progressEvent) {
        Vector vector = this.listeners;
        synchronized (vector) {
            StateType state = progressEvent.getDeploymentStatus().getState();
            if (state.equals(StateType.COMPLETED)) {
                this.completedModuleIDSet.add(progressEvent.getTargetModuleID());
                if (this.completedModuleIDSet.size() == this.targetNumber) {
                    this.deploymentStatus = this.commandType instanceof CommandType ? new DeploymentStatusImpl(StateType.COMPLETED, (CommandType)this.commandType) : new DeploymentStatusImpl(StateType.COMPLETED, "deploy");
                }
            } else if (state.equals(StateType.FAILED)) {
                this.deploymentStatus = (DeploymentStatusImpl)progressEvent.getDeploymentStatus();
            }
            this.deliveredEvents.add(progressEvent);
            Iterator listenersItr = this.listeners.iterator();
            while (listenersItr.hasNext()) {
                ((ProgressListener)listenersItr.next()).handleProgressEvent(progressEvent);
                if (this.parentProgress == null) continue;
                this.parentProgress.fireProgressEvent(progressEvent);
            }
        }
    }

    public void setResultTargetModuleIDs(List ids) {
        this.completedModuleIDSet.addAll(ids);
        if (ids.size() == this.targetNumber) {
            this.deploymentStatus = this.commandType instanceof CommandType ? new DeploymentStatusImpl(StateType.COMPLETED, (CommandType)this.commandType) : new DeploymentStatusImpl(StateType.COMPLETED, "deploy");
        }
    }
}

