/*
 * Decompiled with CFR 0.152.
 */
package jeus.descriptor.ejb;

import jeus.descriptor.ejb.EJBDescriptor;
import jeus.descriptor.ejb.MessageDestinationRefInfo;
import jeus.descriptor.ejb.ServiceRefInfo;
import jeus.util.JeusException;

public class EJBSessionDescriptor
extends EJBDescriptor {
    private boolean isStateful = false;
    private boolean isContainerManagedTX = false;
    private boolean isLocalFileDB = true;
    private String fileDBPath = new String("");
    private String fileDBName = new String("");
    private int minHole = 1000;
    private float packingRate = 0.5f;
    private String primaryFileDBName = new String("");
    private String backupFileDBName = new String("");
    private int conPoolSize = 20;
    private boolean poolingBeans = false;
    private ServiceRefInfo serviceRefInfo;
    private MessageDestinationRefInfo messageDestinationRefInfo;

    public void validate() throws JeusException {
        super.validate();
        if (this.isStateful) {
            if (this.clusterDesc != null && !this.isContainerManagedTX) {
                throw new JeusException(3572, (Object[])new String[]{this.moduleName, this.beanName});
            }
            if (this.isLocalFileDB) {
                if (this.minHole < 0) {
                    throw new JeusException(3035, (Object[])new String[]{this.moduleName, this.beanName, Integer.toString(this.minHole)});
                }
                if (!(0.0f <= this.packingRate) || !(this.packingRate <= 1.0f)) {
                    throw new JeusException(3036, (Object[])new String[]{this.moduleName, this.beanName, Float.toString(this.packingRate)});
                }
            } else if (this.primaryFileDBName.equals("")) {
                throw new JeusException(3578, (Object[])new String[]{this.moduleName, this.beanName});
            }
        }
    }

    public boolean isStateful() {
        return this.isStateful;
    }

    public void setToStateful(boolean state) {
        this.isStateful = state;
    }

    public boolean isContainerManagedTX() {
        return this.isContainerManagedTX;
    }

    public void setContainerManagedTX(boolean b) {
        this.isContainerManagedTX = b;
    }

    public boolean isLocalFileDB() {
        return this.isLocalFileDB;
    }

    public void setLocalFileDB(boolean b) {
        this.isLocalFileDB = b;
    }

    public String getFileDBPath() {
        return this.fileDBPath;
    }

    public void setFileDBPath(String s) {
        this.fileDBPath = s;
    }

    public String getFileDBName() {
        return this.fileDBName;
    }

    public void setFileDBName(String s) {
        this.fileDBName = s;
    }

    public int getMinHole() {
        return this.minHole;
    }

    public void setMinHole(int num) {
        this.minHole = num;
    }

    public float getPackingRate() {
        return this.packingRate;
    }

    public void setPackingRate(float num) {
        this.packingRate = num;
    }

    public String getPrimaryFileDBName() {
        return this.primaryFileDBName;
    }

    public void setPrimaryFileDBName(String s) {
        this.primaryFileDBName = s;
    }

    public String getBackupFileDBName() {
        return this.backupFileDBName;
    }

    public void setBackupFileDBName(String s) {
        this.backupFileDBName = s;
    }

    public int getConnectionPoolSize() {
        return this.conPoolSize;
    }

    public void setConnectionPoolSize(int i) {
        this.conPoolSize = i;
    }

    public boolean isPoolingBeans() {
        return this.poolingBeans;
    }

    public void setPoolingBeans(boolean b) {
        this.poolingBeans = b;
    }

    public void setServiceRefInfo(ServiceRefInfo info) {
        this.serviceRefInfo = info;
    }

    public void setMessageDestinationRefInfo(MessageDestinationRefInfo info) {
        this.messageDestinationRefInfo = info;
    }
}

