/*
 * Decompiled with CFR 0.152.
 */
package jeus.descriptor.jeusserver;

import java.io.Serializable;
import jeus.util.JeusException;

public class ConnectorProperty
implements Serializable {
    private String name = new String("");
    private String type = new String("");
    private String value = new String("");

    public void validate() throws JeusException {
        if (this.name.equals("") || this.type.equals("")) {
            throw new JeusException("database property name or type is empty");
        }
        if (!(this.type.equals("java.lang.Boolean") || this.type.equals("java.lang.String") || this.type.equals("java.lang.Integer") || this.type.equals("java.lang.Double") || this.type.equals("java.lang.Byte") || this.type.equals("java.lang.Short") || this.type.equals("java.lang.Long") || this.type.equals("java.lang.Float") || this.type.equals("java.lang.Character") || this.type.equals("java.util.Properties"))) {
            throw new JeusException("database property type [" + this.type + "] is unknown");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String s) {
        this.type = s;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String s) {
        this.value = s;
    }

    public String stringify() {
        return this.name + "::" + this.type + "::" + this.value;
    }

    public static ConnectorProperty fromString(String s) {
        ConnectorProperty prop = new ConnectorProperty();
        prop.setName(s.substring(0, s.indexOf("::")));
        s = s.substring(s.indexOf("::") + 2);
        prop.setType(s.substring(0, s.indexOf("::")));
        prop.setValue(s.substring(s.indexOf("::") + 2));
        return prop;
    }

    public String toString() {
        return "[" + this.name + ":" + this.type + "]";
    }
}

