/*
 * Decompiled with CFR 0.152.
 */
package jeus.descriptor.jeusserver;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.descriptor.bind.SessionServerDescriptorJB;
import jeus.util.JeusException;
import jeus.util.message.JeusMessage_Session0;
import jeus.xml.binding.jeusDD.JeusNodeType;
import jeus.xml.binding.jeusDD.JeusmainSessionServerType;

public class SessionServerDescriptor
implements Serializable {
    public static final int TYPE_PRIMARY_INT = 0;
    public static final int TYPE_BACKUP_INT = 1;
    public static final int DEFAULT_TYPE_INT = 0;
    private static final String TYPE_PRIMARY = "primary";
    private static final String TYPE_BACKUP = "backup";
    private static final String DEFAULT_TYPE = "primary";
    private static final int CHECK_LEVEL_SET_INT = 0;
    private static final int CHECK_LEVEL_MODIFIED_INT = 1;
    private static final int CHECK_LEVEL_ALL_INT = 2;
    private static final int DEFAULT_CHECK_LEVEL_INT = 0;
    private static final String CHECK_LEVEL_SET = "set";
    private static final String CHECK_LEVEL_MODIFIED = "modified";
    private static final String CHECK_LEVEL_ALL = "all";
    private static final String DEFAULT_CHECK_LEVEL = "set";
    public static final int RECOVERY_MODE_ACTIVE_INT = 0;
    public static final int RECOVERY_MODE_NONE_INT = 1;
    public static final int RECOVERY_MODE_ALL_INT = 2;
    public static final int DEFAULT_RECOVERY_MODE_INT = 0;
    private static final String RECOVERY_MODE_ACTIVE = "active";
    private static final String RECOVERY_MODE_NONE = "none";
    private static final String RECOVERY_MODE_ALL = "all";
    private static final String DEFAULT_RECOVERY_MODE = "active";
    private static final AtomicBoolean MAKEUP_DESCRIPTOR = new AtomicBoolean(false);
    private static SessionServerDescriptor primarySessionServerDesc = null;
    private static SessionServerDescriptor backupSessionServerDesc = null;
    private int typeInt;
    private String type;
    private long resolution;
    private int threadPoolMinSize;
    private int threadPoolMaxSize;
    private long threadPoolResizePeriod;
    private boolean useNio;
    private long connectTimeout;
    private long readTimeout;
    private long passivationTimeout;
    private long removalTimeout;
    private String fileDbPath;
    private String fileDbName;
    private int minHole;
    private float packingRate;
    private long checkTimeout;
    private int backupTrigger;
    private int checkLevelInt;
    private String checkLevel;
    private int recoveryModeInt;
    private String recoveryMode;
    private String replicatedServer;
    private String serverName = null;
    private String backupName = null;

    public void validate() throws JeusException {
        if (this.resolution <= 0L) {
            throw new JeusException(JeusMessage_Session0._1200, (Object)String.valueOf(this.resolution));
        }
        if (this.threadPoolMinSize < 0) {
            throw new JeusException(JeusMessage_Session0._1201, (Object)String.valueOf(this.threadPoolMinSize));
        }
        if (0 >= this.threadPoolMaxSize || this.threadPoolMinSize > this.threadPoolMaxSize) {
            throw new JeusException(JeusMessage_Session0._1202, (Object)String.valueOf(this.threadPoolMaxSize));
        }
        if (this.threadPoolResizePeriod <= 0L) {
            throw new JeusException(JeusMessage_Session0._1204, (Object)String.valueOf(this.threadPoolResizePeriod));
        }
        if (this.minHole < 1) {
            throw new JeusException(JeusMessage_Session0._1029, (Object[])new String[]{Integer.toString(this.minHole)});
        }
        if (this.packingRate < 0.0f || this.packingRate > 1.0f) {
            throw new JeusException(JeusMessage_Session0._1030, (Object[])new String[]{Float.toString(this.packingRate)});
        }
        if (this.checkTimeout <= 0L) {
            throw new JeusException(JeusMessage_Session0._1031, (Object[])new String[]{Long.toString(this.checkTimeout)});
        }
        if (this.backupTrigger <= 0) {
            throw new JeusException(JeusMessage_Session0._1032, (Object[])new String[]{Long.toString(this.backupTrigger)});
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getBackupName() {
        return this.backupName;
    }

    public int getTypeInt() {
        return this.typeInt;
    }

    public String getType() {
        return this.type;
    }

    public long getResolution() {
        return this.resolution;
    }

    public int getPoolMin() {
        return this.threadPoolMinSize;
    }

    public int getPoolMax() {
        return this.threadPoolMaxSize;
    }

    public long getPoolPeriod() {
        return this.threadPoolResizePeriod;
    }

    public boolean isUseNio() {
        return this.useNio;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public long getPassivationTimeout() {
        return this.passivationTimeout;
    }

    public long getRemovalTimeout() {
        return this.removalTimeout;
    }

    public String getFileDbPath() {
        return this.fileDbPath;
    }

    public String getFileDbName() {
        return this.fileDbName;
    }

    public int getMinHole() {
        return this.minHole;
    }

    public float getPackingRate() {
        return this.packingRate;
    }

    public long getCheckTimeout() {
        return this.checkTimeout;
    }

    public int getBackupTrigger() {
        return this.backupTrigger;
    }

    public int getCheckLevelInt() {
        return this.checkLevelInt;
    }

    public String getCheckLevel() {
        return this.checkLevel;
    }

    public int getRecoveryModeInt() {
        return this.recoveryModeInt;
    }

    public String getRecoveryMode() {
        return this.recoveryMode;
    }

    public String getReplicatedServer() {
        return this.replicatedServer;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setBackupName(String backupName) {
        this.backupName = backupName;
    }

    private void setTypeInt(int typeInt) {
        this.typeInt = typeInt;
    }

    public void setType(String type) {
        if (type == null) {
            this.type = "primary";
            this.setTypeInt(0);
            return;
        }
        if (type.equalsIgnoreCase("primary")) {
            this.type = type;
            this.setTypeInt(0);
        } else if (type.equalsIgnoreCase(TYPE_BACKUP)) {
            this.type = type;
            this.setTypeInt(1);
        } else {
            this.type = "primary";
            this.setTypeInt(0);
        }
    }

    public void setResolution(long resolution) {
        this.resolution = resolution;
    }

    public void setPoolMin(int threadPoolMinSize) {
        this.threadPoolMinSize = threadPoolMinSize;
    }

    public void setPoolMax(int threadPoolMaxSize) {
        this.threadPoolMaxSize = threadPoolMaxSize;
    }

    public void setPoolPeriod(long threadPoolResizePeriod) {
        this.threadPoolResizePeriod = threadPoolResizePeriod;
    }

    public void setUseNio(boolean useNio) {
        this.useNio = useNio;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setPassivationTimeout(long passivationTimeout) {
        this.passivationTimeout = passivationTimeout;
    }

    public void setRemovalTimeout(long removalTimeout) {
        this.removalTimeout = removalTimeout;
    }

    public void setFileDbPath(String fileDbPath) {
        this.fileDbPath = fileDbPath;
    }

    public void setFileDbName(String fileDbName) {
        this.fileDbName = fileDbName;
    }

    public void setMinHole(int minHole) {
        this.minHole = minHole;
    }

    public void setPackingRate(float packingRate) {
        this.packingRate = packingRate;
    }

    public void setCheckTimeout(long checkTimeout) {
        this.checkTimeout = checkTimeout;
    }

    public void setBackupTrigger(int backupTrigger) {
        this.backupTrigger = backupTrigger;
    }

    private void setCheckLevelInt(int checkLevelInt) {
        this.checkLevelInt = checkLevelInt;
    }

    public void setCheckLevel(String checkLevel) {
        if (checkLevel == null) {
            this.checkLevel = "set";
            this.setCheckLevelInt(0);
            return;
        }
        if (checkLevel.equalsIgnoreCase("set")) {
            this.checkLevel = checkLevel;
            this.setCheckLevelInt(0);
        } else if (checkLevel.equalsIgnoreCase(CHECK_LEVEL_MODIFIED)) {
            this.checkLevel = checkLevel;
            this.setCheckLevelInt(1);
        } else if (checkLevel.equalsIgnoreCase("all")) {
            this.checkLevel = checkLevel;
            this.setCheckLevelInt(2);
        } else {
            this.checkLevel = "set";
            this.setCheckLevelInt(0);
        }
    }

    private void setRecoveryModeInt(int recoveryModeInt) {
        this.recoveryModeInt = recoveryModeInt;
    }

    public void setRecoveryMode(String recoveryMode) {
        if (recoveryMode == null) {
            this.recoveryMode = "active";
            this.setRecoveryModeInt(0);
            return;
        }
        if (recoveryMode.equalsIgnoreCase("active")) {
            this.recoveryMode = recoveryMode;
            this.setRecoveryModeInt(0);
        } else if (recoveryMode.equalsIgnoreCase("all")) {
            this.recoveryMode = recoveryMode;
            this.setRecoveryModeInt(2);
        } else if (recoveryMode.equalsIgnoreCase(RECOVERY_MODE_NONE)) {
            this.recoveryMode = recoveryMode;
            this.setRecoveryModeInt(1);
        } else {
            this.recoveryMode = "active";
            this.setRecoveryModeInt(0);
        }
    }

    public void setReplicatedServer(String replicatedServer) {
        this.replicatedServer = replicatedServer;
    }

    public static SessionServerDescriptor getPrimarySessionServerDesc() throws IOException {
        SessionServerDescriptor.makeupSessionServerDescriptor();
        return primarySessionServerDesc;
    }

    public static SessionServerDescriptor getBackupSessionServerDesc() throws IOException {
        SessionServerDescriptor.makeupSessionServerDescriptor();
        return backupSessionServerDesc;
    }

    private static void makeupSessionServerDescriptor() throws IOException {
        String replicatedServer;
        if (!MAKEUP_DESCRIPTOR.compareAndSet(false, true)) {
            return;
        }
        List nodeList = JeusMainDescriptorJB.getJeusMainDescriptor().getNode();
        block4: for (int i = 0; i < nodeList.size(); ++i) {
            JeusNodeType oneNode = (JeusNodeType)nodeList.get(i);
            JeusmainSessionServerType sessionServer = oneNode.getSessionServer();
            if (sessionServer == null) continue;
            SessionServerDescriptor sessionServerDesc = SessionServerDescriptorJB.getSessionServerDescriptor(sessionServer);
            switch (sessionServerDesc.getTypeInt()) {
                case 0: {
                    if (primarySessionServerDesc != null) {
                        throw new IOException("duplicated primary session server. you must set only one primary session server in jeus clustering system");
                    }
                    primarySessionServerDesc = sessionServerDesc;
                    primarySessionServerDesc.setServerName(oneNode.getName());
                    continue block4;
                }
                case 1: {
                    if (backupSessionServerDesc != null) {
                        throw new IOException("duplicated backup session server. you must set only one backup session server in jeus clustering system");
                    }
                    backupSessionServerDesc = sessionServerDesc;
                    backupSessionServerDesc.setServerName(oneNode.getName());
                    continue block4;
                }
                default: {
                    throw new IOException("unsupported session server type. you must set either primary or backup");
                }
            }
        }
        if (primarySessionServerDesc != null && backupSessionServerDesc != null) {
            backupSessionServerDesc.setBackupName(primarySessionServerDesc.getServerName());
            primarySessionServerDesc.setBackupName(backupSessionServerDesc.getServerName());
        }
        if (primarySessionServerDesc != null && (replicatedServer = primarySessionServerDesc.getReplicatedServer()) != null) {
            primarySessionServerDesc.setBackupName(replicatedServer);
        }
        if (backupSessionServerDesc != null && (replicatedServer = backupSessionServerDesc.getReplicatedServer()) != null) {
            backupSessionServerDesc.setBackupName(replicatedServer);
        }
    }
}

