/*
 * Decompiled with CFR 0.152.
 */
package jeus.descriptor.sessionmanager;

import java.io.IOException;
import java.io.Serializable;
import jeus.descriptor.jeusserver.SessionServerDescriptor;
import jeus.servlet.deployment.descriptor.bind.WebMainDescriptorJB;
import jeus.sessionmanager.central.CentralManagerConfig;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Session2;
import jeus.xml.binding.jeusDD.SessionServerType;

public class CentralSessionManagerDescriptor
implements Serializable,
CentralManagerConfig {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.session.central");
    private String serverName;
    private String backupName;
    private long connectTimeout;
    private long readTimeout;
    private int checkLevelInt;

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setBackupName(String backupName) {
        this.backupName = backupName;
    }

    public void setConnectionTimeout(long connectionTo) {
        this.connectTimeout = connectionTo;
    }

    public void setReplyTimeout(long replyTo) {
        this.readTimeout = replyTo;
    }

    public void setCheckLevelInt(int checkLevelInt) {
        this.checkLevelInt = checkLevelInt;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getBackupName() {
        return this.backupName;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public long getReplyTimeout() {
        return this.readTimeout;
    }

    public int getCheckLevelInt() {
        return this.checkLevelInt;
    }

    public void printDescriptor() {
        StringBuffer buf = new StringBuffer(1024);
        buf.append("\n    <<< Central Session Manager Information >>>\n");
        buf.append("        - connection timeout(msec)   : " + this.connectTimeout + "\n");
        buf.append("        - reply timeout(msec)        : " + this.readTimeout + "\n");
        buf.append("        - check level                : " + this.getCheckLevel() + "\n");
        buf.append("        - session server name        : " + this.serverName + "\n");
        buf.append("        - session backup server name : " + this.backupName + "\n");
        if (logger.isLoggable(JeusMessage_Session2._21000_LEVEL)) {
            logger.log(JeusMessage_Session2._21000_LEVEL, JeusMessage_Session2._21000, (Object)buf.toString());
        }
    }

    public String getCheckLevel() {
        switch (this.checkLevelInt) {
            case 0: {
                return "set";
            }
            case 1: {
                return "modified";
            }
            case 2: {
                return "all";
            }
        }
        return "set";
    }

    public static CentralSessionManagerDescriptor getJeusManagerConfig() {
        CentralSessionManagerDescriptor desc = null;
        try {
            SessionServerDescriptor primaryDesc = null;
            primaryDesc = SessionServerDescriptor.getPrimarySessionServerDesc();
            if (primaryDesc == null) {
                return null;
            }
            desc = new CentralSessionManagerDescriptor();
            desc.setServerName(primaryDesc.getServerName());
            desc.setBackupName(primaryDesc.getBackupName());
            desc.setConnectionTimeout(primaryDesc.getConnectTimeout());
            desc.setReplyTimeout(primaryDesc.getReadTimeout());
            desc.setCheckLevelInt(primaryDesc.getCheckLevelInt());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return desc;
    }

    public static CentralSessionManagerDescriptor getJeusManagerConfig(WebMainDescriptorJB webMainDesc) {
        if (webMainDesc == null) {
            return null;
        }
        SessionServerType servletSessionServerDesc = webMainDesc.getSessionServerType();
        if (servletSessionServerDesc == null) {
            return null;
        }
        CentralSessionManagerDescriptor desc = new CentralSessionManagerDescriptor();
        desc.setServerName(servletSessionServerDesc.getPrimaryServer());
        desc.setBackupName(servletSessionServerDesc.getBackupServer());
        desc.setConnectionTimeout(servletSessionServerDesc.getConnectTimeout());
        desc.setReplyTimeout(servletSessionServerDesc.getReadTimeout());
        desc.setCheckLevel(servletSessionServerDesc.getCheckLevel());
        return desc;
    }

    private void setCheckLevel(String checkLevel) {
        if (checkLevel == null) {
            this.setCheckLevelInt(0);
            return;
        }
        if (checkLevel.equalsIgnoreCase("set")) {
            this.setCheckLevelInt(0);
        } else if (checkLevel.equalsIgnoreCase("modified")) {
            this.setCheckLevelInt(1);
        } else if (checkLevel.equalsIgnoreCase("all")) {
            this.setCheckLevelInt(2);
        } else {
            this.setCheckLevelInt(0);
        }
    }
}

