/*
 * Decompiled with CFR 0.152.
 */
package jeus.descriptor.tool;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import jeus.descriptor.ejb.EJBDBInfo;
import jeus.descriptor.ejb.EJBDescriptor;
import jeus.descriptor.ejb.EJBEntityDescriptor;
import jeus.descriptor.ejb.EJBMessageDrivenDescriptor;
import jeus.descriptor.ejb.EJBMethodInfo;
import jeus.descriptor.ejb.EJBModDescriptor;
import jeus.descriptor.ejb.EJBRelationshipDescriptor;
import jeus.descriptor.ejb.EJBSessionDescriptor;
import jeus.descriptor.ejb.JNDIInfo;
import jeus.descriptor.ejb.RoleInfo;
import jeus.descriptor.ejb.TransactionInfo;
import jeus.descriptor.tool.AssemblyDescriptor;
import jeus.descriptor.tool.BeanDescriptor;
import jeus.descriptor.tool.CmpField;
import jeus.descriptor.tool.ContainerTransaction;
import jeus.descriptor.tool.DependentsDescriptor;
import jeus.descriptor.tool.Descriptor;
import jeus.descriptor.tool.EJBGeneralDescriptor;
import jeus.descriptor.tool.EJBReference;
import jeus.descriptor.tool.EJBRelation;
import jeus.descriptor.tool.EJBRelationshipRole;
import jeus.descriptor.tool.EntityDescriptor;
import jeus.descriptor.tool.EnvironEntry;
import jeus.descriptor.tool.MessageDrivenDescriptor;
import jeus.descriptor.tool.Method;
import jeus.descriptor.tool.RelationshipsDescriptor;
import jeus.descriptor.tool.ResourceEnvironReference;
import jeus.descriptor.tool.ResourceReference;
import jeus.descriptor.tool.SecurityIdentity;
import jeus.descriptor.tool.SecurityRole;
import jeus.descriptor.tool.SecurityRoleReference;
import jeus.descriptor.tool.SessionDescriptor;
import jeus.tool.deployment.EJBModule;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusException;

public class EJBModuleDescriptor
extends Descriptor
implements Serializable {
    private SessionDescriptor[] sessionDescriptors = null;
    private EntityDescriptor[] entityDescriptors = null;
    private MessageDrivenDescriptor[] messageDrivenDescriptors = null;
    private Vector descriptorList = new Vector();
    private DependentsDescriptor dependentsDescriptor = null;
    private RelationshipsDescriptor relationshipsDescriptor = null;
    private AssemblyDescriptor assemblyDescriptor = null;
    private String ejbClientJar = null;
    private HashMap uncompletedLocalLinkTable;

    public void setDescriptorList(Vector list) {
        this.descriptorList = list;
    }

    public Vector getDescriptorList() {
        return this.descriptorList;
    }

    public void setSessionDescriptors(SessionDescriptor[] paramSessions) {
        this.sessionDescriptors = paramSessions;
    }

    public void setEntityDescriptors(EntityDescriptor[] paramEntities) {
        this.entityDescriptors = paramEntities;
    }

    public void setMessageDrivenDescriptors(MessageDrivenDescriptor[] messageDrivenDescriptors) {
        this.messageDrivenDescriptors = messageDrivenDescriptors;
    }

    public void setDependentsDescriptor(DependentsDescriptor dependentsDescriptor) {
        this.dependentsDescriptor = dependentsDescriptor;
    }

    public void setRelationshipsDescriptor(RelationshipsDescriptor relationshipsDescriptor) {
        this.relationshipsDescriptor = relationshipsDescriptor;
    }

    public void setAssemblyDescriptor(AssemblyDescriptor paramAssembly) {
        this.assemblyDescriptor = paramAssembly;
    }

    public void setEJBClientJar(String paramClient) {
        this.ejbClientJar = paramClient;
    }

    public AssemblyDescriptor getAssemblyDescriptor() {
        return this.assemblyDescriptor;
    }

    public SessionDescriptor[] getSessionDescriptors() {
        return this.sessionDescriptors;
    }

    public EntityDescriptor[] getEntityDescriptors() {
        return this.entityDescriptors;
    }

    public MessageDrivenDescriptor[] getMessageDrivenDescriptors() {
        return this.messageDrivenDescriptors;
    }

    public DependentsDescriptor getDependentsDescriptor() {
        return this.dependentsDescriptor;
    }

    public RelationshipsDescriptor getRelationshipsDescriptor() {
        return this.relationshipsDescriptor;
    }

    public String getEJBClientJar() {
        return this.ejbClientJar;
    }

    public BeanDescriptor getBeanDescriptor(String beanName) {
        int i;
        for (i = 0; i < this.sessionDescriptors.length; ++i) {
            if (!beanName.equals(this.sessionDescriptors[i].getEJBName())) continue;
            return this.sessionDescriptors[i];
        }
        for (i = 0; i < this.entityDescriptors.length; ++i) {
            if (!beanName.equals(this.entityDescriptors[i].getEJBName())) continue;
            return this.entityDescriptors[i];
        }
        for (i = 0; i < this.messageDrivenDescriptors.length; ++i) {
            if (!beanName.equals(this.messageDrivenDescriptors[i].getEJBName())) continue;
            return this.messageDrivenDescriptors[i];
        }
        return null;
    }

    public EJBModDescriptor toEJBModDescriptor(String moduleName) throws Exception {
        EJBModDescriptor desc = this.toEJBModDescriptor(null, moduleName);
        return desc;
    }

    public void fillDescriptorWithRefNew(Vector refBeanList, Vector beanList, String moduleName) {
        block4: {
            Vector allDescList;
            block3: {
                allDescList = this.getDescriptorList();
                if (refBeanList == null || refBeanList.size() == 0) break block3;
                boolean found = false;
                if (allDescList == null) break block4;
                for (int i = 0; i < allDescList.size(); ++i) {
                    BeanDescriptor myDesc = (BeanDescriptor)allDescList.get(i);
                    found = false;
                    Enumeration e = refBeanList.elements();
                    while (e.hasMoreElements()) {
                        EJBDescriptor descriptor = (EJBDescriptor)e.nextElement();
                        if (myDesc.getEJBName().trim().compareTo(descriptor.getBeanName()) != 0) continue;
                        beanList.addElement(this.toEJBDescriptor(descriptor, moduleName));
                        found = true;
                    }
                    if (found) continue;
                    beanList.addElement(this.toEJBDescriptor(myDesc, moduleName));
                }
                break block4;
            }
            for (int i = 0; i < allDescList.size(); ++i) {
                BeanDescriptor myDesc = (BeanDescriptor)allDescList.get(i);
                beanList.addElement(this.toEJBDescriptor(myDesc, moduleName));
            }
        }
    }

    public void fillDescriptorWithRefOld(Vector refBeanList, Vector beanList, String moduleName) {
        block15: {
            MessageDrivenDescriptor[] messageDrivens;
            EntityDescriptor[] entities;
            block14: {
                MessageDrivenDescriptor[] messageDrivens2;
                EntityDescriptor[] entities2;
                if (refBeanList == null || refBeanList.size() == 0) break block14;
                SessionDescriptor[] sessions = this.getSessionDescriptors();
                boolean found = false;
                if (sessions != null) {
                    for (int i = 0; i < sessions.length; ++i) {
                        found = false;
                        Enumeration e = refBeanList.elements();
                        while (e.hasMoreElements()) {
                            EJBDescriptor descriptor = (EJBDescriptor)e.nextElement();
                            if (sessions[i].getEJBName().trim().compareTo(descriptor.getBeanName()) != 0 || !(descriptor instanceof EJBSessionDescriptor)) continue;
                            beanList.addElement(this.toEJBDescriptor(descriptor, moduleName));
                            found = true;
                        }
                        if (found) continue;
                        beanList.addElement(this.toEJBDescriptor(sessions[i], moduleName));
                    }
                }
                if ((entities2 = this.getEntityDescriptors()) != null) {
                    for (int i = 0; i < entities2.length; ++i) {
                        found = false;
                        Enumeration e = refBeanList.elements();
                        while (e.hasMoreElements()) {
                            EJBDescriptor descriptor = (EJBDescriptor)e.nextElement();
                            if (entities2[i].getEJBName().trim().compareTo(descriptor.getBeanName()) != 0 || !(descriptor instanceof EJBEntityDescriptor)) continue;
                            beanList.addElement(this.toEJBDescriptor(descriptor, moduleName));
                            found = true;
                        }
                        if (found) continue;
                        beanList.addElement(this.toEJBDescriptor(entities2[i], moduleName));
                    }
                }
                if ((messageDrivens2 = this.getMessageDrivenDescriptors()) == null) break block15;
                for (int i = 0; i < messageDrivens2.length; ++i) {
                    found = false;
                    Enumeration e = refBeanList.elements();
                    while (e.hasMoreElements()) {
                        EJBDescriptor descriptor = (EJBDescriptor)e.nextElement();
                        if (messageDrivens2[i].getEJBName().trim().compareTo(descriptor.getBeanName()) != 0 || !(descriptor instanceof EJBMessageDrivenDescriptor)) continue;
                        beanList.addElement(this.toEJBDescriptor(descriptor, moduleName));
                        found = true;
                    }
                    if (found) continue;
                    beanList.addElement(this.toEJBDescriptor(messageDrivens2[i], moduleName));
                }
                break block15;
            }
            SessionDescriptor[] sessions = this.getSessionDescriptors();
            if (sessions != null) {
                for (int i = 0; i < sessions.length; ++i) {
                    beanList.addElement(this.toEJBDescriptor(sessions[i], moduleName));
                }
            }
            if ((entities = this.getEntityDescriptors()) != null) {
                for (int i = 0; i < entities.length; ++i) {
                    beanList.addElement(this.toEJBDescriptor(entities[i], moduleName));
                }
            }
            if ((messageDrivens = this.getMessageDrivenDescriptors()) != null) {
                for (int i = 0; i < messageDrivens.length; ++i) {
                    beanList.addElement(this.toEJBDescriptor(messageDrivens[i], moduleName));
                }
            }
        }
    }

    public EJBModDescriptor toEJBModDescriptor(EJBModDescriptor modDescriptor, String moduleName, boolean refFile) throws Exception {
        if (modDescriptor == null) {
            modDescriptor = new EJBModDescriptor();
        }
        modDescriptor.setModuleName(moduleName);
        Vector refBeanList = modDescriptor.getBeanList();
        Vector beanList = new Vector();
        int moduleBeanSize = this.sessionDescriptors.length + this.entityDescriptors.length + this.messageDrivenDescriptors.length;
        if (moduleBeanSize < refBeanList.size()) {
            String message = ErrorMsgManager.getLocalizedString((int)12084);
            throw new Exception(message);
        }
        this.fillDescriptorWithRefOld(refBeanList, beanList, moduleName);
        modDescriptor.setBeanList(beanList);
        if (this.getAssemblyDescriptor() == null) {
            return modDescriptor;
        }
        Vector<RoleInfo> roles = new Vector<RoleInfo>();
        SecurityRole[] securityRoles = this.getAssemblyDescriptor().getSecurityRoles();
        if (securityRoles != null) {
            for (int i = 0; i < securityRoles.length; ++i) {
                RoleInfo roleInfo = new RoleInfo(securityRoles[i].getRoleName(), securityRoles[i].getDescription());
                roles.addElement(roleInfo);
            }
        }
        modDescriptor.setRoles(roles);
        Vector rpTable = new Vector();
        Vector uncheckList = new Vector();
        Vector<RoleInfo> ruTable = modDescriptor.getRUTable();
        if (ruTable == null) {
            ruTable = new Vector<RoleInfo>();
            modDescriptor.setRUTable(ruTable);
        }
        if ((securityRoles = this.getAssemblyDescriptor().getSecurityRoles()) != null) {
            for (int i = 0; i < securityRoles.length; ++i) {
                SecurityRole securityRole = securityRoles[i];
                RoleInfo roleInfo = this.getRoleInfo(ruTable, securityRole.getRoleName());
                if (roleInfo != null) continue;
                roleInfo = new RoleInfo(securityRole.getRoleName(), new Vector());
                ruTable.addElement(roleInfo);
            }
        }
        Vector<TransactionInfo> txTable = new Vector<TransactionInfo>();
        ContainerTransaction[] containerTransactions = this.getAssemblyDescriptor().getContainerTransaction();
        if (containerTransactions != null) {
            for (int i = 0; i < containerTransactions.length; ++i) {
                ContainerTransaction containerTransaction = containerTransactions[i];
                int type = 0;
                String transAttr = containerTransaction.getTransAttribute();
                if (transAttr.equals("NotSupported")) {
                    type = 0;
                } else if (transAttr.equals("Supports")) {
                    type = 2;
                } else if (transAttr.equals("Required")) {
                    type = 1;
                } else if (transAttr.equals("RequiresNew")) {
                    type = 3;
                } else if (transAttr.equals("Mandatory")) {
                    type = 4;
                } else if (transAttr.equals("Never")) {
                    type = 5;
                }
                Method[] methods = containerTransaction.getMethods();
                for (int methodCount = 0; methodCount < methods.length; ++methodCount) {
                    Method method = methods[methodCount];
                    TransactionInfo transactionInfo = new TransactionInfo(this.makeEJBMethodInfo(method), type);
                    if (txTable.contains(transactionInfo)) continue;
                    txTable.addElement(transactionInfo);
                }
            }
        }
        modDescriptor.setTxTable(txTable);
        Vector relationList = new Vector();
        RelationshipsDescriptor relationDesc = this.getRelationshipsDescriptor();
        if (relationDesc != null) {
            Vector ejbRelations = relationDesc.getEJBRelations();
            Enumeration e = ejbRelations.elements();
            while (e.hasMoreElements()) {
                EJBRelation ejbRelation = (EJBRelation)e.nextElement();
                Vector relationRoles = ejbRelation.getEJBRelationshipRoles();
                Vector<EJBRelationshipDescriptor> relationRoleList = new Vector<EJBRelationshipDescriptor>();
                for (int i = 0; i < relationRoles.size() && i < 2; ++i) {
                    EJBRelationshipRole relationRole = (EJBRelationshipRole)relationRoles.get(i);
                    EJBRelationshipDescriptor desc = relationRole.toEJBRelationshipDescriptor();
                    relationRoleList.add(desc);
                }
                relationList.add(relationRoleList);
            }
        }
        modDescriptor.setRelations(relationList);
        if (this.ejbClientJar == null) {
            modDescriptor.setClientJarName("");
        } else {
            modDescriptor.setClientJarName(this.ejbClientJar);
        }
        return modDescriptor;
    }

    public static EJBModDescriptor toEJBModDescriptorFromJar(EJBModDescriptor modDescriptor, String ejbJarPath, String moduleName) throws Exception {
        EJBModule ejbJarModule = new EJBModule(ejbJarPath);
        ejbJarModule.openPackage();
        EJBModuleDescriptor desc = (EJBModuleDescriptor)ejbJarModule.getDescriptor();
        ejbJarModule.deleteDeployedFiles();
        return desc.toEJBModDescriptor(modDescriptor, moduleName);
    }

    public static EJBModDescriptor toEJBModDescriptorFromJarWithDD(String ejbJarPath) throws Exception {
        EJBModule ejbJarModule = new EJBModule(ejbJarPath);
        EJBModuleDescriptor desc = ejbJarModule.getEJBDescriptorFromZip();
        EJBModDescriptor jeusDD = ejbJarModule.getJeusDescriptoFromZip();
        String moduleName = jeusDD.getModuleName();
        if (moduleName == null) {
            throw new Exception("Module Name is not set");
        }
        return desc.toEJBModDescriptor(jeusDD, moduleName);
    }

    public void fillDescriptorNew(Vector refBeanList, Vector beanList, String moduleName) {
        Vector allDescList = this.getDescriptorList();
        if (allDescList != null) {
            for (int i = 0; i < allDescList.size(); ++i) {
                BeanDescriptor myDesc = (BeanDescriptor)allDescList.get(i);
                beanList.addElement(this.toEJBDescriptor(myDesc, moduleName));
            }
        }
    }

    public void fillDescriptorOld(Vector refBeanList, Vector beanList, String moduleName) {
        MessageDrivenDescriptor[] messageDrivens;
        EntityDescriptor[] entities;
        this.uncompletedLocalLinkTable = new HashMap();
        SessionDescriptor[] sessions = this.getSessionDescriptors();
        if (sessions != null) {
            for (int i = 0; i < sessions.length; ++i) {
                beanList.addElement(this.toEJBDescriptor(sessions[i], moduleName));
            }
        }
        if ((entities = this.getEntityDescriptors()) != null) {
            for (int i = 0; i < entities.length; ++i) {
                beanList.addElement(this.toEJBDescriptor(entities[i], moduleName));
            }
        }
        if ((messageDrivens = this.getMessageDrivenDescriptors()) != null) {
            for (int i = 0; i < messageDrivens.length; ++i) {
                beanList.addElement(this.toEJBDescriptor(messageDrivens[i], moduleName));
            }
        }
        this.setUncompletedLink(beanList);
    }

    private void setUncompletedLink(Vector beanList) {
        for (int i = 0; i < beanList.size(); ++i) {
            EJBDescriptor ejbDesc = (EJBDescriptor)beanList.get(i);
            ArrayList linkList = (ArrayList)this.uncompletedLocalLinkTable.get(ejbDesc.getBeanName());
            if (linkList != null) {
                for (int j = 0; j < linkList.size(); ++j) {
                    Object[] refName_refVector = (Object[])linkList.get(j);
                    String refName = (String)refName_refVector[0];
                    Vector jndiVector = (Vector)refName_refVector[1];
                    JNDIInfo jndiInfo = new JNDIInfo(refName, ejbDesc.getLocalExportName());
                    jndiVector.addElement(jndiInfo);
                }
                continue;
            }
            if (!ejbDesc.getEJBLocalObjectClassName().equals("")) continue;
            ejbDesc.setLocalExportName("");
        }
    }

    public EJBModDescriptor toEJBModDescriptor(EJBModDescriptor modDescriptor, String moduleName) throws Exception {
        RelationshipsDescriptor relationDesc;
        if (modDescriptor == null) {
            modDescriptor = new EJBModDescriptor();
        }
        modDescriptor.setModuleName(moduleName);
        Vector refBeanList = modDescriptor.getBeanList();
        Vector<EJBDescriptor> beanList = new Vector<EJBDescriptor>();
        int moduleBeanSize = this.sessionDescriptors.length + this.entityDescriptors.length + this.messageDrivenDescriptors.length;
        if (moduleBeanSize < refBeanList.size()) {
            String message = ErrorMsgManager.getLocalizedString((int)12084);
            throw new Exception(message);
        }
        if (refBeanList != null && refBeanList.size() != 0) {
            this.uncompletedLocalLinkTable = new HashMap();
            for (int i = 0; i < refBeanList.size(); ++i) {
                EJBDescriptor descriptor = (EJBDescriptor)refBeanList.get(i);
                beanList.addElement(this.toEJBDescriptor(descriptor, moduleName));
            }
            modDescriptor.setBeanList(beanList);
            this.setUncompletedLink(beanList);
        } else {
            this.fillDescriptorOld(refBeanList, beanList, moduleName);
            modDescriptor.setBeanList(beanList);
        }
        if (this.ejbClientJar == null) {
            modDescriptor.setClientJarName("");
        } else {
            modDescriptor.setClientJarName(this.ejbClientJar);
        }
        Vector relationList = modDescriptor.getRelations();
        if (relationList == null) {
            relationList = new Vector();
        }
        if ((relationDesc = this.getRelationshipsDescriptor()) != null) {
            Vector ejbRelations = relationDesc.getEJBRelations();
            Enumeration e = ejbRelations.elements();
            while (e.hasMoreElements()) {
                EJBRelation ejbRelation = (EJBRelation)e.nextElement();
                String relationName = ejbRelation.getEJBRelationName();
                Vector relationRoles = ejbRelation.getEJBRelationshipRoles();
                if (ejbRelation.fillRelationList(relationList) || relationRoles == null || relationRoles.size() < 2) continue;
                Vector<EJBRelationshipDescriptor> relationRoleList = new Vector<EJBRelationshipDescriptor>();
                EJBRelationshipRole firstRole = (EJBRelationshipRole)relationRoles.get(0);
                EJBRelationshipRole secondRole = (EJBRelationshipRole)relationRoles.get(1);
                EJBRelationshipDescriptor desc1 = firstRole.toEJBRelationshipDescriptor();
                EJBRelationshipDescriptor desc2 = secondRole.toEJBRelationshipDescriptor();
                relationRoleList.add(desc1);
                relationRoleList.add(desc2);
                relationList.add(relationRoleList);
            }
        }
        String msg = null;
        Enumeration re = relationList.elements();
        while (re.hasMoreElements()) {
            Vector relationItem = (Vector)re.nextElement();
            if (relationItem == null || relationItem.size() != 2) {
                msg = "No more than 2 jeus-relationship-roles exist for one ejb-relation-map";
                throw new JeusException(12510, (Object)msg);
            }
            Enumeration reEnum = relationItem.elements();
            while (reEnum.hasMoreElements()) {
                EJBRelationshipDescriptor redesc = (EJBRelationshipDescriptor)reEnum.nextElement();
                if (redesc.getEJBName() != null && !redesc.getEJBName().trim().equals("")) continue;
                String relationName = redesc.getRelationName();
                String roleName = redesc.getRelationshipRoleName();
                msg = "Can't find  ejb-relation with ejb-relation-name = " + relationName + ", ejb-relationship-role-name" + roleName;
                throw new JeusException(12510, (Object)msg);
            }
        }
        modDescriptor.setRelations(relationList);
        if (this.getAssemblyDescriptor() == null) {
            return modDescriptor;
        }
        Vector<RoleInfo> roles = new Vector<RoleInfo>();
        SecurityRole[] securityRoles = this.getAssemblyDescriptor().getSecurityRoles();
        if (securityRoles != null) {
            for (int i = 0; i < securityRoles.length; ++i) {
                RoleInfo roleInfo = new RoleInfo(securityRoles[i].getRoleName(), securityRoles[i].getDescription());
                roles.addElement(roleInfo);
            }
        }
        modDescriptor.setRoles(roles);
        Vector rpTable = new Vector();
        Vector uncheckList = new Vector();
        Vector<TransactionInfo> txTable = new Vector<TransactionInfo>();
        ContainerTransaction[] containerTransactions = this.getAssemblyDescriptor().getContainerTransaction();
        if (containerTransactions != null) {
            for (int i = 0; i < containerTransactions.length; ++i) {
                ContainerTransaction containerTransaction = containerTransactions[i];
                int type = 0;
                String transAttr = containerTransaction.getTransAttribute();
                if (transAttr.equals("NotSupported")) {
                    type = 0;
                } else if (transAttr.equals("Supports")) {
                    type = 2;
                } else if (transAttr.equals("Required")) {
                    type = 1;
                } else if (transAttr.equals("RequiresNew")) {
                    type = 3;
                } else if (transAttr.equals("Mandatory")) {
                    type = 4;
                } else if (transAttr.equals("Never")) {
                    type = 5;
                }
                Method[] methods = containerTransaction.getMethods();
                for (int methodCount = 0; methodCount < methods.length; ++methodCount) {
                    Method method = methods[methodCount];
                    TransactionInfo transactionInfo = new TransactionInfo(this.makeEJBMethodInfo(method), type);
                    if (txTable.contains(transactionInfo)) continue;
                    txTable.addElement(transactionInfo);
                }
            }
        }
        modDescriptor.setTxTable(txTable);
        return modDescriptor;
    }

    private EJBMethodInfo makeEJBMethodInfo(Method method) {
        EJBMethodInfo methodInfo = new EJBMethodInfo();
        methodInfo.setBeanName(method.getEJBName());
        methodInfo.setMethodName(method.getMethodFullName());
        return methodInfo;
    }

    public EJBDescriptor toEJBDescriptor(String beanName, String moduleName) {
        BeanDescriptor descriptor = this.getBeanDescriptor(beanName);
        if (descriptor == null) {
            return null;
        }
        return this.toEJBDescriptor(descriptor, moduleName);
    }

    public EJBDescriptor toEJBDescriptor(BeanDescriptor descriptor, String moduleName) {
        EJBDescriptor ejbDescriptor = descriptor instanceof SessionDescriptor ? new EJBSessionDescriptor() : (descriptor instanceof EntityDescriptor ? new EJBEntityDescriptor() : new EJBMessageDrivenDescriptor());
        this.fillEJBDescriptor(ejbDescriptor, descriptor, moduleName);
        return ejbDescriptor;
    }

    public EJBDescriptor toEJBDescriptor(EJBDescriptor ejbDescriptor, String moduleName) {
        BeanDescriptor descriptor = this.getBeanDescriptor(ejbDescriptor.getBeanName());
        if (descriptor == null) {
            return null;
        }
        if (ejbDescriptor instanceof EJBGeneralDescriptor) {
            EJBGeneralDescriptor myDesc = (EJBGeneralDescriptor)ejbDescriptor;
            ejbDescriptor = myDesc.getEJBDescriptor(descriptor);
        }
        this.fillEJBDescriptor(ejbDescriptor, descriptor, moduleName);
        return ejbDescriptor;
    }

    private void fillEJBDescriptor(EJBDescriptor ejbDescriptor, BeanDescriptor descriptor, String moduleName) {
        ResourceEnvironReference[] resourceEnvRefs;
        Vector<JNDIInfo> resEnvRefs;
        ResourceReference[] resourceRefs;
        Vector<JNDIInfo> resRefs;
        EJBReference[] ejbLocalReferences;
        EJBReference[] ejbReferences;
        Vector<JNDIInfo> ejbRefs;
        EnvironEntry[] environs;
        ejbDescriptor.setModuleName(moduleName);
        ejbDescriptor.setBeanName(descriptor.getEJBName());
        ejbDescriptor.setEJBBeanClassName(descriptor.getEJBClass());
        String remoteInterface = descriptor.getRemoteInterface();
        if (remoteInterface == null) {
            remoteInterface = "";
            ejbDescriptor.setExportName("");
        }
        ejbDescriptor.setEJBObjectClassName(remoteInterface);
        String homeInterface = descriptor.getHomeInterface();
        if (homeInterface == null) {
            homeInterface = "";
        }
        ejbDescriptor.setEJBHomeClassName(homeInterface);
        String localInterface = descriptor.getLocalInterface();
        if (localInterface == null) {
            localInterface = "";
            ejbDescriptor.setLocalExportName("");
        }
        ejbDescriptor.setEJBLocalObjectClassName(localInterface);
        String localHomeInterface = descriptor.getLocalHomeInterface();
        if (localHomeInterface == null) {
            localHomeInterface = "";
        }
        ejbDescriptor.setEJBLocalHomeClassName(localHomeInterface);
        if (descriptor instanceof SessionDescriptor) {
            EJBSessionDescriptor sessionDescriptor = (EJBSessionDescriptor)ejbDescriptor;
            if (((SessionDescriptor)descriptor).getSessionType().equals("Stateless")) {
                sessionDescriptor.setToStateful(false);
            } else {
                sessionDescriptor.setToStateful(true);
            }
            if (((SessionDescriptor)descriptor).getTransactionType().equals("Container")) {
                sessionDescriptor.setContainerManagedTX(true);
            } else {
                sessionDescriptor.setContainerManagedTX(false);
            }
        } else if (descriptor instanceof EntityDescriptor) {
            EJBEntityDescriptor entityDescriptor = (EJBEntityDescriptor)ejbDescriptor;
            if (((EntityDescriptor)descriptor).getReentrant().equalsIgnoreCase("True")) {
                entityDescriptor.setIsReentrant(true);
            } else {
                entityDescriptor.setIsReentrant(false);
            }
            if (((EntityDescriptor)descriptor).getPersistenceType().equals("Bean")) {
                entityDescriptor.setIsConManaged(false);
                entityDescriptor.setSubEngineType(-1);
                String pkeyClass = ((EntityDescriptor)descriptor).getPrimKeyClass();
                if (pkeyClass == null || pkeyClass.trim().equals("")) {
                    entityDescriptor.setPkeyClassName("java.lang.Object");
                } else {
                    entityDescriptor.setPkeyClassName(pkeyClass);
                }
            } else {
                String primKeyField;
                CmpField[] cmFields;
                entityDescriptor.setIsConManaged(true);
                entityDescriptor.setCMPVersion(((EntityDescriptor)descriptor).getCmpVersionInt());
                entityDescriptor.setSchemaName(((EntityDescriptor)descriptor).getAbstractSchemaName());
                EJBDBInfo dbInfo = entityDescriptor.getEJBDBInfo();
                if (dbInfo == null) {
                    dbInfo = new EJBDBInfo();
                    entityDescriptor.setEJBDBInfo(dbInfo);
                }
                if (entityDescriptor.getCMPVersion() == 2) {
                    ArrayList ejbJarMethods = ((EntityDescriptor)descriptor).getFindMethods();
                    ArrayList ejbJarSQLs = ((EntityDescriptor)descriptor).getFindSQLs();
                    ArrayList jeusQLMethods = dbInfo.findMethods;
                    ArrayList jeusQLSQLs = dbInfo.findSQLs;
                    ArrayList jeusUpdates = dbInfo.includeUpdates;
                    ArrayList<String> finalMethods = new ArrayList<String>();
                    ArrayList finalSQLs = new ArrayList();
                    ArrayList finalUpdates = new ArrayList();
                    for (int i = 0; i < ejbJarMethods.size(); ++i) {
                        String methodString = (String)ejbJarMethods.get(i);
                        int foundIndex = -1;
                        for (int j = 0; j < jeusQLMethods.size(); ++j) {
                            String jeusQLString = (String)jeusQLMethods.get(j);
                            if (!methodString.equals(jeusQLString)) continue;
                            foundIndex = j;
                        }
                        if (foundIndex != -1) {
                            finalMethods.add(methodString);
                            if (jeusQLSQLs.get(foundIndex) != null && !((String)jeusQLSQLs.get(foundIndex)).trim().equals("")) {
                                finalSQLs.add(jeusQLSQLs.get(foundIndex));
                            } else {
                                finalSQLs.add(ejbJarSQLs.get(i));
                            }
                            finalUpdates.add(jeusUpdates.get(foundIndex));
                            continue;
                        }
                        finalMethods.add(methodString);
                        finalSQLs.add(ejbJarSQLs.get(i));
                        finalUpdates.add("false");
                    }
                    dbInfo.findMethods = finalMethods;
                    dbInfo.findSQLs = finalSQLs;
                    dbInfo.includeUpdates = finalUpdates;
                    dbInfo.setEJBQLReturnTypes(((EntityDescriptor)descriptor).getResultTypes());
                }
                if ((cmFields = ((EntityDescriptor)descriptor).getCmpFields()) != null) {
                    for (int k = 0; k < cmFields.length; ++k) {
                        String cmField = cmFields[k].getFieldName();
                        if (dbInfo.cmFields == null) {
                            dbInfo.cmFields = new ArrayList();
                        }
                        if (dbInfo.cmFieldColNames == null) {
                            dbInfo.cmFieldColNames = new ArrayList();
                        }
                        if (dbInfo.cmFieldTypes == null) {
                            dbInfo.cmFieldTypes = new ArrayList();
                        }
                        if (dbInfo.cmExcludeList != null && dbInfo.cmExcludeList.contains(cmField) || dbInfo.cmFields.contains(cmField)) continue;
                        dbInfo.cmFields.add(cmFields[k].getFieldName());
                        dbInfo.cmFieldColNames.add("");
                        dbInfo.cmFieldTypes.add("");
                    }
                }
                if ((primKeyField = ((EntityDescriptor)descriptor).getPrimKeyField()) != null) {
                    if (dbInfo.cmPkeyFields == null) {
                        dbInfo.cmPkeyFields = new ArrayList();
                    }
                    if (!dbInfo.cmPkeyFields.contains(primKeyField)) {
                        dbInfo.cmPkeyFields.add(primKeyField);
                    }
                }
                dbInfo.cmNPkeyFields = new ArrayList();
                dbInfo.pkeyClassFields = new ArrayList();
                String pkeyClass = ((EntityDescriptor)descriptor).getPrimKeyClass();
                String pkeyField = ((EntityDescriptor)descriptor).getPrimKeyField();
                entityDescriptor.setPkeyClassName(pkeyClass);
                if (pkeyField == null) {
                    entityDescriptor.getEJBDBInfo().setIsPkeyField(false);
                } else {
                    entityDescriptor.getEJBDBInfo().setIsPkeyField(true);
                }
            }
        } else {
            EJBMessageDrivenDescriptor messageDrivenDescriptor = (EJBMessageDrivenDescriptor)ejbDescriptor;
            if (((MessageDrivenDescriptor)descriptor).getDurability().equals("Durable")) {
                messageDrivenDescriptor.setDurable(true);
            } else {
                messageDrivenDescriptor.setDurable(false);
            }
            if (((MessageDrivenDescriptor)descriptor).getTransactionType().equals("Container")) {
                messageDrivenDescriptor.setContainerManagedTX(true);
            } else {
                messageDrivenDescriptor.setContainerManagedTX(false);
            }
            String ackMode = ((MessageDrivenDescriptor)descriptor).getAcknowledgeMode();
            int ack = 1;
            if (ackMode.equals("Auto-acknowledge")) {
                ack = 1;
            } else if (ackMode.equals("Dups-ok-acknowledge")) {
                ack = 3;
            }
            messageDrivenDescriptor.setAckMode(ack);
            String messageSelector = ((MessageDrivenDescriptor)descriptor).getMessageSelector();
            if (messageSelector == null) {
                messageSelector = "";
            }
            messageDrivenDescriptor.setMessageSelector(messageSelector);
        }
        Vector<JNDIInfo> envs = ejbDescriptor.getEnvs();
        if (envs == null) {
            envs = new Vector<JNDIInfo>();
            ejbDescriptor.setEnvs(envs);
        }
        if ((environs = descriptor.getEnvironEntries()) != null) {
            for (int i = 0; i < environs.length; ++i) {
                String name = environs[i].getName();
                String type = environs[i].getType();
                Object value = null;
                if (type.equals("int") || type.equals("Integer") || type.equals("java.lang.Integer")) {
                    value = Integer.valueOf(environs[i].getValue());
                } else if (type.equals("long") || type.equals("Long") || type.equals("java.lang.Long")) {
                    value = Long.valueOf(environs[i].getValue());
                } else if (type.equals("float") || type.equals("Float") || type.equals("java.lang.Float")) {
                    value = Float.valueOf(environs[i].getValue());
                } else if (type.equals("boolean") || type.equals("Boolean") || type.equals("java.lang.Boolean")) {
                    value = Boolean.valueOf(environs[i].getValue());
                } else if (type.equals("double") || type.equals("Double") || type.equals("java.lang.Double")) {
                    value = Double.valueOf(environs[i].getValue());
                } else if (type.equals("byte") || type.equals("Byte") || type.equals("java.lang.Byte")) {
                    value = Byte.valueOf(environs[i].getValue());
                } else if (type.equals("short") || type.equals("Short") || type.equals("java.lang.Short")) {
                    value = Short.valueOf(environs[i].getValue());
                } else if (type.equals("char") || type.equals("Char") || type.equals("java.lang.Character")) {
                    char[] carray = environs[i].getValue().toCharArray();
                    value = new Character(carray[0]);
                } else {
                    value = environs[i].getValue();
                }
                if (this.IsExistingJNDIInfo(envs, name)) continue;
                JNDIInfo jndiInfo = new JNDIInfo(name, value);
                envs.addElement(jndiInfo);
            }
        }
        if ((ejbRefs = ejbDescriptor.getEJBRefs()) == null) {
            ejbRefs = new Vector<JNDIInfo>();
            ejbDescriptor.setEJBRefs(ejbRefs);
        }
        if ((ejbReferences = descriptor.getEJBReferences()) != null) {
            for (int i = 0; i < ejbReferences.length; ++i) {
                String name = ejbReferences[i].getName();
                String ejbLink = ejbReferences[i].getEJBLink();
                if (ejbLink != null && !ejbLink.equals("")) {
                    ejbLink = "link : " + ejbLink;
                }
                if (this.IsExistingJNDIInfo(ejbRefs, name)) continue;
                JNDIInfo jndiInfo = new JNDIInfo(name, ejbLink);
                ejbRefs.addElement(jndiInfo);
            }
        }
        if ((ejbLocalReferences = descriptor.getEJBLocalReferences()) != null) {
            for (int i = 0; i < ejbLocalReferences.length; ++i) {
                String name = ejbLocalReferences[i].getName();
                String ejbLink = ejbLocalReferences[i].getEJBLink();
                if (this.IsExistingJNDIInfo(ejbRefs, name)) continue;
                ArrayList<Object[]> linkList = (ArrayList<Object[]>)this.uncompletedLocalLinkTable.get(ejbLink);
                if (linkList == null) {
                    linkList = new ArrayList<Object[]>();
                    this.uncompletedLocalLinkTable.put(ejbLink, linkList);
                }
                linkList.add(new Object[]{name, ejbRefs});
            }
        }
        if ((resRefs = ejbDescriptor.getResourceRefs()) == null) {
            resRefs = new Vector<JNDIInfo>();
            ejbDescriptor.setResourceRefs(resRefs);
        }
        if ((resourceRefs = descriptor.getResourceReferences()) != null) {
            for (int i = 0; i < resourceRefs.length; ++i) {
                String name = resourceRefs[i].getName();
                if (!this.IsExistingJNDIInfo(resRefs, name)) {
                    JNDIInfo jndiInfo = new JNDIInfo(name, null);
                    jndiInfo.setResourceAuth(resourceRefs[i].getAuthority());
                    jndiInfo.setResourceSharingScope(resourceRefs[i].getSharingScope());
                    resRefs.addElement(jndiInfo);
                    continue;
                }
                JNDIInfo selectedOne = this.getExistingJNDIInfo(resRefs, name);
                selectedOne.setResourceAuth(resourceRefs[i].getAuthority());
                selectedOne.setResourceSharingScope(resourceRefs[i].getSharingScope());
            }
        }
        if ((resEnvRefs = ejbDescriptor.getResourceEnvRefs()) == null) {
            resEnvRefs = new Vector<JNDIInfo>();
            ejbDescriptor.setResourceEnvRefs(resEnvRefs);
        }
        if ((resourceEnvRefs = descriptor.getResourceEnvrionReferences()) != null) {
            for (int i = 0; i < resourceEnvRefs.length; ++i) {
                String name = resourceEnvRefs[i].getName();
                if (this.IsExistingJNDIInfo(resEnvRefs, name)) continue;
                JNDIInfo jndiInfo = new JNDIInfo(name, null);
                resEnvRefs.addElement(jndiInfo);
            }
        }
        Vector<RoleInfo> roleLinkTable = new Vector<RoleInfo>();
        SecurityRoleReference[] securityRefs = descriptor.getSecurityRoleReferences();
        if (securityRefs != null) {
            for (int i = 0; i < securityRefs.length; ++i) {
                SecurityRoleReference securityRef = securityRefs[i];
                RoleInfo roleInfo = new RoleInfo(securityRef.getRoleLink(), securityRef.getRoleName());
                roleLinkTable.addElement(roleInfo);
            }
        }
        ejbDescriptor.setRoleLinkTable(roleLinkTable);
        SecurityIdentity securityIdentity = descriptor.getSecurityIdentity();
        if (securityIdentity != null) {
            SecurityRole runAsSpecifiedIdentity = securityIdentity.getRunAsSpecifiedIdentity();
            if (runAsSpecifiedIdentity != null) {
                ejbDescriptor.setRunAsRole(runAsSpecifiedIdentity.getRoleName());
            } else {
                ejbDescriptor.setRunAsRole("");
            }
        } else {
            ejbDescriptor.setRunAsRole("");
        }
    }

    private JNDIInfo getExistingJNDIInfo(Vector jndiInfos, String name) {
        if (jndiInfos == null) {
            return null;
        }
        for (int i = 0; i < jndiInfos.size(); ++i) {
            JNDIInfo jndiInfo = (JNDIInfo)jndiInfos.get(i);
            if (!jndiInfo.getRefName().equals(name)) continue;
            return jndiInfo;
        }
        return null;
    }

    private boolean IsExistingJNDIInfo(Vector jndiInfos, String name) {
        if (jndiInfos == null) {
            return false;
        }
        for (int i = 0; i < jndiInfos.size(); ++i) {
            JNDIInfo jndiInfo = (JNDIInfo)jndiInfos.get(i);
            if (!jndiInfo.getRefName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean getJNDIInfoFromRemote(Vector jndiInfos, String name) {
        if (jndiInfos == null) {
            return false;
        }
        for (int i = 0; i < jndiInfos.size(); ++i) {
            JNDIInfo jndiInfo = (JNDIInfo)jndiInfos.get(i);
            if (!jndiInfo.getRefName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private RoleInfo getRoleInfo(Vector roleInfos, String name) {
        if (roleInfos == null) {
            return null;
        }
        for (int i = 0; i < roleInfos.size(); ++i) {
            RoleInfo roleInfo = (RoleInfo)roleInfos.get(i);
            if (!roleInfo.getRole().equals(name)) continue;
            return roleInfo;
        }
        return null;
    }
}

