/*
 * Decompiled with CFR 0.152.
 */
package jeus.descriptor.tool;

import java.io.Serializable;
import java.util.StringTokenizer;

public class Method
implements Serializable {
    private String description = null;
    private String ejbName = null;
    private String methodIntf = null;
    private String methodName = null;
    private String[] methodParams = null;

    public String toString() {
        String toString = this.ejbName;
        if (this.methodIntf != null && !this.methodIntf.equals("")) {
            toString = toString + "(" + this.methodIntf + ")";
        }
        if (this.ejbName == null || this.ejbName.equals("")) {
            toString = "";
            toString = toString + this.methodName;
        } else {
            toString = toString + ":" + this.methodName;
        }
        if (this.methodParams != null) {
            for (int i = 0; i < this.methodParams.length; ++i) {
                if (i == 0) {
                    toString = toString + "(";
                }
                toString = toString + this.methodParams[i] + ",";
            }
            int index = toString.lastIndexOf(44);
            if (index >= 0) {
                toString = toString.substring(0, toString.lastIndexOf(44)) + ")";
            }
        }
        return toString;
    }

    public String getMethodFullName() {
        String methodFullName = this.methodName;
        if (this.methodParams != null) {
            for (int i = 0; i < this.methodParams.length; ++i) {
                if (i == 0) {
                    methodFullName = methodFullName + "(";
                }
                methodFullName = methodFullName + this.methodParams[i] + ",";
            }
            int index = methodFullName.lastIndexOf(44);
            if (index >= 0) {
                methodFullName = methodFullName.substring(0, methodFullName.lastIndexOf(44)) + ")";
            }
        } else if (this.methodParams == null && methodFullName.indexOf("*") == -1) {
            methodFullName = methodFullName + "()";
        }
        if (this.methodIntf != null) {
            if (this.methodIntf.compareToIgnoreCase("Home") == 0) {
                methodFullName = methodFullName + "RH";
            } else if (this.methodIntf.compareToIgnoreCase("Remote") == 0) {
                methodFullName = methodFullName + "R";
            } else if (this.methodIntf.compareToIgnoreCase("LocalHome") == 0) {
                methodFullName = methodFullName + "LH";
            } else if (this.methodIntf.compareToIgnoreCase("Local") == 0) {
                methodFullName = methodFullName + "L";
            }
        }
        return methodFullName;
    }

    public Method() {
    }

    public Method(String ejbName, String methodIntf, String methodFullName) {
        this.ejbName = ejbName;
        this.methodIntf = methodIntf;
        int startIndex = methodFullName.indexOf("(");
        if (startIndex < 0) {
            this.methodName = methodFullName;
        } else {
            this.methodName = methodFullName.substring(0, startIndex);
            String params = methodFullName.substring(methodFullName.indexOf("(") + 1, methodFullName.lastIndexOf(")"));
            StringTokenizer strTok = new StringTokenizer(params, ",");
            this.methodParams = new String[strTok.countTokens()];
            int index = 0;
            while (strTok.hasMoreTokens()) {
                this.methodParams[index++] = strTok.nextToken();
            }
        }
    }

    public void setDescription(String paramDescription) {
        this.description = paramDescription;
    }

    public void setEJBName(String paramEJBName) {
        this.ejbName = paramEJBName;
    }

    public void setMethodIntf(String paramMethodIntf) {
        this.methodIntf = paramMethodIntf;
    }

    public void setMethodName(String paramMethodName) {
        this.methodName = paramMethodName;
    }

    public void setMethodParams(String[] paramMethodParams) {
        this.methodParams = paramMethodParams;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEJBName() {
        return this.ejbName;
    }

    public String getMethodIntf() {
        return this.methodIntf;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String[] getMethodParams() {
        return this.methodParams;
    }
}

