/*
 * Decompiled with CFR 0.152.
 */
package jeus.descriptor.tool;

import java.io.Serializable;
import java.util.ArrayList;

public class QueryDescriptor
implements Serializable {
    private String description = null;
    private String methodName = null;
    private String[] methodParams = null;
    private String ejbQL = null;
    private String resultTypeMapping = null;

    public void setDescription(String description) {
        this.description = description;
    }

    public void setQueryMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setQueryMethodParams(String[] methodParams) {
        this.methodParams = methodParams;
    }

    public void setEJBQL(String ejbQL) {
        this.ejbQL = ejbQL;
    }

    public void setResultTypeMapping(String mapping) {
        this.resultTypeMapping = mapping;
    }

    public String getDescription() {
        return this.description;
    }

    public String getQueryMethodName() {
        return this.methodName;
    }

    public String[] getQueryMethodParams() {
        return this.methodParams;
    }

    public String getEJBQL() {
        return this.ejbQL;
    }

    public String getResultTypeMapping() {
        return this.resultTypeMapping;
    }

    public String toString() {
        return this.methodName + " : " + this.ejbQL;
    }

    public String getFindMethod() {
        return QueryDescriptor.getMethodFullString(this.methodName, this.methodParams);
    }

    public static String getMethodFullString(String methodName, String[] methodParams) {
        if (methodParams == null || methodParams.length == 0) {
            return methodName + "()";
        }
        StringBuffer stBuffer = new StringBuffer(methodName);
        stBuffer.append("(");
        for (int i = 0; i < methodParams.length; ++i) {
            if (i != 0) {
                stBuffer.append(",");
            }
            stBuffer.append(methodParams[i]);
        }
        stBuffer.append(")");
        return stBuffer.toString();
    }

    public static ArrayList getMethodParams(String fullMethod) {
        ArrayList<String> param = new ArrayList<String>();
        if (fullMethod == null || fullMethod.trim().equals("")) {
            return param;
        }
        if (fullMethod.indexOf("()") >= 0) {
            return param;
        }
        String paramString = fullMethod.substring(fullMethod.indexOf("(") + 1, fullMethod.indexOf(")"));
        while (paramString.length() != 0) {
            int nextIndex = paramString.indexOf(",");
            if (nextIndex == -1) {
                param.add(paramString);
                paramString = "";
                continue;
            }
            param.add(paramString.substring(0, nextIndex));
            paramString = paramString.substring(nextIndex + 1);
        }
        return param;
    }

    public boolean getResultTypeBoolean() {
        return this.resultTypeMapping != null && this.resultTypeMapping.equals("Remote");
    }
}

