/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.bind.JAXBException;
import jeus.deploy.JeusDeploymentException;
import jeus.deploy.archivist.FileArchive;
import jeus.descriptor.ejb.TransactionInfo;
import jeus.ejb.BeanContainer;
import jeus.ejb.EJBDeploymentException;
import jeus.ejb.EJBEngine;
import jeus.ejb.EJBLoggers;
import jeus.ejb.EJBStatus;
import jeus.ejb.compiler.EJBPkeyGenerator;
import jeus.ejb.compiler.EJBSourceGenerator;
import jeus.ejb.container.BeanContainerFactory;
import jeus.ejb.ejbserver.EJBServerException;
import jeus.ejb.ejbserver.FailedBeanInfo;
import jeus.ejb.generator.EJBCodeBuilder;
import jeus.ejb.metadata.BeanInfo;
import jeus.ejb.metadata.EntityBeanInfo;
import jeus.ejb.metadata.InterceptorInfo;
import jeus.ejb.metadata.ModuleInfo;
import jeus.ejb.metadata.SessionBeanInfo;
import jeus.ejb.schema.BeanSchema;
import jeus.ejb.schema.EJBSQLGeneratorException;
import jeus.ejb.schema.ModuleSchema;
import jeus.ejb.util.EJBCompiler;
import jeus.ejb.util.LeftTime;
import jeus.management.j2ee.DeploymentContext;
import jeus.management.j2ee.EJBModule;
import jeus.security.base.Policy;
import jeus.security.container.ejb.EJBSecurity;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.util.JeusRootClassLoader;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB11;
import jeus.util.message.JeusMessage_EJB7;
import jeus.util.message.JeusMessage_EJB8;
import jeus.webservices.spi.EWSProvider;
import jeus.xml.binding.ejbHelper.BeanPair;
import jeus.xml.binding.ejbHelper.CMEntityBeanPair;
import jeus.xml.binding.ejbHelper.EJBDescriptorValidationException;
import jeus.xml.binding.ejbHelper.EntityBeanPair;
import jeus.xml.binding.j2ee.ContainerTransactionType;
import jeus.xml.binding.j2ee.EjbJarType;
import jeus.xml.binding.j2ee.JavaTypeType;
import jeus.xml.binding.j2ee.MethodIntfType;
import jeus.xml.binding.j2ee.MethodParamsType;
import jeus.xml.binding.j2ee.MethodType;
import jeus.xml.binding.j2ee.TransAttributeType;
import jeus.xml.binding.jeusDD.EjbComponentType;
import jeus.xml.binding.jeusDD.EjbEngineType;
import jeus.xml.binding.jeusDD.InvokeHttpType;
import jeus.xml.binding.jeusDD.JeusEjbDdType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJB3Module {
    private static final JeusLogger logger = EJBLoggers.logger;
    protected String moduleName;
    protected EJBEngine ejbEngine;
    protected ModuleInfo moduleInfo;
    protected String moduleDomain;
    protected boolean moduleDomainCreated;
    protected final AtomicReference<EJBStatus> status = new AtomicReference<EJBStatus>(EJBStatus.PREDEPLOYMENT);
    protected Map<String, BeanContainer> containerList;
    protected EJBModule ejbModuleMBean;
    protected HashMap successList;

    private EJB3Module(String moduleName) {
        this.moduleName = moduleName;
        this.ejbEngine = EJBEngine.getDefaultEngine();
    }

    public EJBStatus getStatus() {
        return this.status.get();
    }

    public static EJB3Module createAndDeploy() throws JeusDeploymentException {
        DeploymentContext dc = DeploymentContext.currentContext();
        assert (dc != null);
        EJB3Module module = new EJB3Module(dc.getJ2EEModule().getUniqueModuleName());
        module.create();
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create() throws JeusDeploymentException {
        block52: {
            EJBModule module;
            if (!this.status.compareAndSet(EJBStatus.PREDEPLOYMENT, EJBStatus.DEPLOYING)) {
                throw new EJBDeploymentException("EJBModule " + this.moduleName + " is not pre-deploy state");
            }
            DeploymentContext dc = DeploymentContext.currentContext();
            this.ejbModuleMBean = module = (EJBModule)dc.getJ2EEModule();
            FileArchive moduleHome = module.getRootArchive();
            boolean fastDeploy = module.isFastDeploy();
            boolean isKeepGenerated = module.isKeepGenerated();
            ArchiveArrayClassLoader loader = (ArchiveArrayClassLoader)module.getClassLoader();
            String appName = dc.getApplicationName();
            boolean isOnlyGenerating = dc.isCompileOnlyMode();
            FileArchive clientViewHome = dc.getClientViewHome();
            Policy appPolicy = module.getAppPolicy();
            EjbJarType ejbJar = dc.getEjbJar();
            JeusEjbDdType ejbDD = dc.getJeusEjbDD();
            boolean compileAllBeans = dc.isCompileOnlyMode();
            String securityDomainName = dc.getSecurityDomainName();
            EjbComponentType ejbComponent = dc.getEjbComponentType();
            if (ejbComponent.isSetKeepGenerated()) {
                isKeepGenerated = ejbComponent.isKeepGenerated();
            }
            if (logger.isLoggable(JeusMessage_EJB8._5103_LEVEL)) {
                logger.log(JeusMessage_EJB8._5103_LEVEL, JeusMessage_EJB8._5103);
            }
            if (!isOnlyGenerating) {
                if (logger.isLoggable(JeusMessage_EJB8._5099_LEVEL)) {
                    logger.logp(JeusMessage_EJB8._5099_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5099, new Object[]{moduleHome.getArchiveUri(), appName});
                }
            } else if (logger.isLoggable(JeusMessage_EJB8._5398_LEVEL)) {
                logger.logp(JeusMessage_EJB8._5398_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5398, (Object)this.moduleName);
            }
            Object exception = null;
            int failedStep = 0;
            List<FailedBeanInfo> failedBeans = new ArrayList<FailedBeanInfo>();
            if (logger.isLoggable(JeusMessage_EJB8._5104_LEVEL)) {
                logger.logp(JeusMessage_EJB8._5104_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5104);
            }
            if (!isOnlyGenerating) {
                this.ejbEngine.addDeployingModule(this);
            }
            try {
                if (logger.isLoggable(JeusMessage_EJB8._5112_LEVEL)) {
                    logger.logp(JeusMessage_EJB8._5103_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5103);
                    if (logger.isLoggable(JeusMessage_EJB8._5112_LEVEL)) {
                        logger.logp(JeusMessage_EJB8._5112_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5112, (Object)this.moduleName);
                    }
                }
                this.moduleDomain = "_" + this.moduleName;
                boolean validate = true;
                this.moduleInfo = ModuleInfo.create(this.moduleName, moduleHome, loader, ejbJar, ejbDD, this.moduleDomain, securityDomainName);
                if (validate) {
                    this.validateModuleInfo(this.moduleInfo);
                }
                if (this.moduleInfo.isFastDeploy()) {
                    fastDeploy = true;
                }
                if (this.moduleInfo.isKeepGenerated()) {
                    isKeepGenerated = true;
                }
                EJBCompiler compiler = null;
                if (!fastDeploy) {
                    compiler = new EJBCompiler();
                    compiler.init(moduleHome.getArchiveUri() + File.pathSeparator + clientViewHome.getArchiveUri() + File.pathSeparator + JeusRootClassLoader.getRootClassPaths(loader), clientViewHome.getArchiveUri(), isKeepGenerated, loader);
                }
                List<BeanInfo> beanlist = this.moduleInfo.getBeanList();
                List<BeanPair> beanPairList = this.moduleInfo.getBeanPairList();
                LinkedHashMap<String, BeanContainer> containerList = new LinkedHashMap<String, BeanContainer>(beanlist.size() * 2);
                try {
                    this.processWebserviceServiceRefs(beanlist, ejbDD, clientViewHome, fastDeploy, isKeepGenerated);
                    this.processWebserviceEndpoint(moduleHome, loader, fastDeploy, isKeepGenerated);
                    HashMap<String, HashMap<String, Integer>> transactionInfo = new HashMap<String, HashMap<String, Integer>>();
                    if (exception == null) {
                        this.makeSecurityPolicy(isOnlyGenerating, ejbJar, ejbDD, appPolicy, loader);
                        this.makeTransactionInfoForEntity(transactionInfo);
                    }
                    if (exception == null) {
                        this.handleUnknownPK(beanlist, loader, moduleHome, clientViewHome, fastDeploy, compiler);
                    }
                    ModuleSchema mSchema = null;
                    if (exception == null && beanPairList.size() > 0) {
                        if (logger.isLoggable(JeusMessage_EJB8._5133_LEVEL)) {
                            logger.logp(JeusMessage_EJB8._5133_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5133);
                        }
                        try {
                            mSchema = new ModuleSchema(this.moduleName, moduleHome, clientViewHome, loader);
                            failedBeans = mSchema.generateModuleSchema(beanPairList, this.moduleInfo.getRelationPairList(), fastDeploy, compileAllBeans, isOnlyGenerating, compiler);
                        }
                        catch (Throwable ex) {
                            if (logger.isLoggable(JeusMessage_EJB8._5134_LEVEL)) {
                                logger.logp(JeusMessage_EJB8._5134_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5134, (Object)this.moduleName, ex);
                            }
                            failedStep = 3;
                            exception = new EJBServerException(JeusMessage_EJB8._5134, this.moduleName, ex);
                        }
                        if (logger.isLoggable(JeusMessage_EJB8._5135_LEVEL)) {
                            logger.logp(JeusMessage_EJB8._5135_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5135);
                        }
                    }
                    if (exception == null) {
                        EjbEngineType desc = this.ejbEngine.getEjbEngineDescriptor();
                        InvokeHttpType invokeHttpType = null;
                        if (desc != null) {
                            invokeHttpType = desc.getInvokeHttp();
                        }
                        for (BeanInfo beanInfo : beanlist) {
                            String beanName = beanInfo.getBeanName();
                            try {
                                if (logger.isLoggable(JeusMessage_EJB8._5136_LEVEL)) {
                                    logger.logp(JeusMessage_EJB8._5136_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5136, (Object)beanName);
                                }
                                if (invokeHttpType != null && !beanInfo.isInvocationWithHttp()) {
                                    beanInfo.setInvocationWithHttp(invokeHttpType.getUrl(), invokeHttpType.getHttpPort());
                                }
                                BeanContainer container = this.deployBean(this.moduleDomain, beanInfo, fastDeploy, transactionInfo, mSchema, moduleHome, clientViewHome, loader, isOnlyGenerating, securityDomainName, compiler);
                                if (isOnlyGenerating) continue;
                                containerList.put(beanName, container);
                            }
                            catch (Throwable ex) {
                                failedBeans.add(new FailedBeanInfo(beanName, ex));
                                failedStep = 4;
                                exception = ex;
                                break;
                            }
                        }
                    }
                    if (exception == null) {
                        if (compiler != null) {
                            compiler.compile();
                        }
                        loader.registerClasses();
                        if (logger.isLoggable(JeusMessage_EJB8._5139_LEVEL)) {
                            logger.logp(JeusMessage_EJB8._5139_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5139);
                        }
                        this.setContainerList(containerList);
                        this.ejbEngine.addDeployedModule(this);
                        this.status.set(EJBStatus.DEPLOYED);
                        if (logger.isLoggable(JeusMessage_EJB8._5140_LEVEL)) {
                            logger.logp(JeusMessage_EJB8._5140_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5140);
                        }
                    }
                }
                catch (Throwable t) {
                    exception = t;
                }
                if (exception == null) {
                    if (!isOnlyGenerating) {
                        if (logger.isLoggable(JeusMessage_EJB8._5142_LEVEL)) {
                            logger.logp(JeusMessage_EJB8._5142_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5142, (Object)this.moduleName);
                        }
                    } else if (logger.isLoggable(JeusMessage_EJB8._5202_LEVEL)) {
                        logger.logp(JeusMessage_EJB8._5202_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5202, (Object)this.moduleName);
                    }
                    if (logger.isLoggable(JeusMessage_EJB8._5103_LEVEL)) {
                        logger.logp(JeusMessage_EJB8._5103_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5103);
                    }
                    break block52;
                }
                switch (failedStep) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.stopAndDestroyContainers(containerList);
                    }
                }
                if (logger.isLoggable(JeusMessage_EJB8._5143_LEVEL)) {
                    logger.logp(JeusMessage_EJB8._5143_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5143, new Object[]{this.moduleName, exception.getMessage()}, exception);
                    if (logger.isLoggable(JeusMessage_EJB8._5103_LEVEL)) {
                        logger.logp(JeusMessage_EJB8._5103_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5103);
                    }
                }
                this.status.set(EJBStatus.DEPLOYMENT_FAILED);
                if (exception instanceof JeusDeploymentException) {
                    throw (JeusDeploymentException)exception;
                }
                throw new JeusDeploymentException((Throwable)exception);
            }
            finally {
                if (!isOnlyGenerating) {
                    this.ejbEngine.removeDeployingModule(this);
                }
            }
        }
    }

    private void validateModuleInfo(ModuleInfo moduleInfo) throws EJBDeploymentException {
        if (moduleInfo.getBeanList().size() == 0) {
            throw new EJBDeploymentException("There is no defined EJB", moduleInfo.getModuleName(), "");
        }
        if (logger.isLoggable(JeusMessage_EJB11._8101_LEVEL)) {
            for (InterceptorInfo interceptor : moduleInfo.getInterceptorInfos()) {
                if (interceptor.isBound()) continue;
                String name = interceptor.getInterceptorClass().getName();
                logger.logp(JeusMessage_EJB11._8101_LEVEL, "EJBServer", "deploy", JeusMessage_EJB11._8101, (Object)name);
            }
        }
    }

    private void makeSecurityPolicy(boolean onlyGenerating, EjbJarType ejbJar, JeusEjbDdType ejbDD, Policy appPolicy, ArchiveArrayClassLoader loader) throws EJBServerException {
        try {
            if (!onlyGenerating) {
                if (logger.isLoggable(JeusMessage_EJB8._5123_LEVEL)) {
                    logger.logp(JeusMessage_EJB8._5123_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5123);
                }
                EJBSecurity.addEJBPolicyToApp(this.moduleInfo, appPolicy);
                if (logger.isLoggable(JeusMessage_EJB8._5124_LEVEL)) {
                    logger.logp(JeusMessage_EJB8._5124_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5124);
                }
            }
        }
        catch (Throwable e) {
            if (logger.isLoggable(JeusMessage_EJB8._5125_LEVEL)) {
                logger.logp(JeusMessage_EJB8._5125_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5125, e);
            }
            throw new EJBServerException("add EJB Policy failed", e);
        }
    }

    private void makeTransactionInfoForEntity(Map<String, HashMap<String, Integer>> transactionInfo) {
        List<ContainerTransactionType> containerTransactions = this.moduleInfo.getContainerTransaction();
        if (containerTransactions != null) {
            if (logger.isLoggable(JeusMessage_EJB8._5126_LEVEL)) {
                logger.logp(JeusMessage_EJB8._5126_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5126);
            }
            for (ContainerTransactionType containerTransactionType : containerTransactions) {
                TransAttributeType attrType = containerTransactionType.getTransAttribute();
                int type = 0;
                String transAttr = attrType.getValue();
                if (transAttr.equals("NotSupported")) {
                    type = 0;
                } else if (transAttr.equals("Supports")) {
                    type = 2;
                } else if (transAttr.equals("Required")) {
                    type = 1;
                } else if (transAttr.equals("RequiresNew")) {
                    type = 3;
                } else if (transAttr.equals("Mandatory")) {
                    type = 4;
                } else if (transAttr.equals("Never")) {
                    type = 5;
                }
                List methods = containerTransactionType.getMethod();
                for (MethodType methodType : methods) {
                    String ejbName = methodType.getEjbName().getValue();
                    HashMap<String, Integer> list = transactionInfo.get(ejbName);
                    if (list == null) {
                        list = new HashMap();
                        transactionInfo.put(ejbName, list);
                    }
                    String methodFullName = this.getMethodFullName(methodType);
                    if (logger.isLoggable(JeusMessage_EJB8._5127_LEVEL)) {
                        logger.logp(JeusMessage_EJB8._5127_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5127, new Object[]{methodFullName, ejbName, TransactionInfo.state[type]});
                    }
                    list.put(methodFullName, type);
                }
            }
        }
        if (logger.isLoggable(JeusMessage_EJB8._5128_LEVEL)) {
            logger.logp(JeusMessage_EJB8._5128_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5128);
        }
    }

    private void processWebserviceServiceRefs(List<BeanInfo> beanlist, JeusEjbDdType ejbDD, FileArchive clientViewHome, boolean fastDeploy, boolean keepGenerated) throws EJBDescriptorValidationException, IOException, JAXBException, JeusDeploymentException {
        if (this.moduleInfo.getEjbVersion() >= 3.0) {
            return;
        }
        for (BeanInfo bp : beanlist) {
            EWSProvider provider;
            ArrayList svcRefPairs = new ArrayList();
            if (bp.getServiceRefs() == null || (provider = EWSProvider.getProvider()) == null) continue;
            provider.processServiceRefs(this.ejbModuleMBean, fastDeploy, keepGenerated, ejbDD, this.moduleInfo.getStandardDD(), bp, clientViewHome);
        }
    }

    private void processWebserviceEndpoint(FileArchive moduleHome, ArchiveArrayClassLoader loader, boolean fastDeploy, boolean keepGenerated) throws JeusDeploymentException {
        if (this.moduleInfo.getEjbVersion() >= 3.0) {
            return;
        }
        EWSProvider provider = EWSProvider.getProvider();
        if (provider != null) {
            provider.preDeploy(this.ejbModuleMBean, this.moduleInfo, fastDeploy, keepGenerated);
        }
    }

    private void handleUnknownPK(List<BeanInfo> beanlist, ArchiveArrayClassLoader loader, FileArchive moduleHome, FileArchive clientViewHome, boolean fastDeploy, EJBCompiler compiler) throws EJBSQLGeneratorException {
        if (logger.isLoggable(JeusMessage_EJB8._5129_LEVEL)) {
            logger.logp(JeusMessage_EJB8._5129_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5129);
        }
        for (BeanInfo desc : beanlist) {
            try {
                CMEntityBeanPair BeanInfo2;
                if (!(desc instanceof EntityBeanInfo)) continue;
                EntityBeanPair beanInfo = ((EntityBeanInfo)desc).getBeanPair();
                this.checkPrimaryKeyClass(beanInfo, loader);
                if (!(beanInfo instanceof CMEntityBeanPair) || !(BeanInfo2 = (CMEntityBeanPair)beanInfo).isAutoKeyGenerator()) continue;
                BeanInfo2.setPkeyClassName("java.lang.Integer");
                if (BeanInfo2.getCMPkeyFields().size() != 0) continue;
                if (logger.isLoggable(JeusMessage_EJB8._5130_LEVEL)) {
                    logger.logp(JeusMessage_EJB8._5130_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5130, (Object)BeanInfo2.getBeanName());
                }
                new EJBPkeyGenerator(this.moduleName, moduleHome, clientViewHome, loader, compiler).generate(BeanInfo2, fastDeploy);
            }
            catch (Throwable t) {
                if (logger.isLoggable(JeusMessage_EJB8._5131_LEVEL)) {
                    logger.logp(JeusMessage_EJB8._5131_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5131, (Object)this.moduleName, t);
                }
                throw new EJBSQLGeneratorException(JeusMessage_EJB8._5131, this.moduleName, t);
            }
        }
        if (logger.isLoggable(JeusMessage_EJB8._5132_LEVEL)) {
            logger.logp(JeusMessage_EJB8._5132_LEVEL, "EJBServer", "deploy", JeusMessage_EJB8._5132);
        }
    }

    private void checkPrimaryKeyClass(EntityBeanPair beanPair, ClassLoader loader) throws EJBSQLGeneratorException {
        String pkeyClassName = beanPair.getPkeyClassName();
        if (pkeyClassName != null) {
            if (logger.isLoggable(JeusMessage_EJB8._5144_LEVEL)) {
                logger.logp(JeusMessage_EJB8._5144_LEVEL, "EJBServer", "checkPrimaryKeyClass", JeusMessage_EJB8._5144, (Object)pkeyClassName);
            }
            try {
                Class<?> pkeyClass = loader.loadClass(pkeyClassName);
                try {
                    pkeyClass.getDeclaredMethod("hashCode", new Class[0]);
                    pkeyClass.getDeclaredMethod("equals", Object.class);
                }
                catch (NoSuchMethodException e) {
                    if (logger.isLoggable(JeusMessage_EJB8._5145_LEVEL)) {
                        logger.logp(JeusMessage_EJB8._5145_LEVEL, "EJBServer", "checkPrimaryKeyClass", JeusMessage_EJB8._5145, (Object)pkeyClassName);
                    }
                    throw new EJBSQLGeneratorException("The primary key class should override hashCode and equals methods");
                }
            }
            catch (ClassNotFoundException ex) {
                if (logger.isLoggable(JeusMessage_EJB8._5146_LEVEL)) {
                    logger.logp(JeusMessage_EJB8._5146_LEVEL, "EJBServer", "checkPrimaryKeyClass", JeusMessage_EJB8._5146, (Object)pkeyClassName, (Throwable)ex);
                }
                throw new EJBSQLGeneratorException(JeusMessage_EJB8._5146, pkeyClassName, (Throwable)ex);
            }
            if (logger.isLoggable(JeusMessage_EJB8._5147_LEVEL)) {
                logger.logp(JeusMessage_EJB8._5147_LEVEL, "EJBServer", "checkPrimaryKeyClass", JeusMessage_EJB8._5147);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws EJBServerException {
        if (logger.isLoggable(JeusMessage_EJB8._5156_LEVEL)) {
            logger.logp(JeusMessage_EJB8._5156_LEVEL, "EJBServer", "undeploy", JeusMessage_EJB8._5156, (Object)this.moduleName);
        }
        AtomicReference<EJBStatus> atomicReference = this.status;
        synchronized (atomicReference) {
            boolean destroyable;
            EJBStatus st = this.status.get();
            if (st == EJBStatus.UNDEPLOYING || st == EJBStatus.UNDEPLOYED) {
                return;
            }
            if (st == EJBStatus.DEPLOYING) {
                return;
            }
            boolean bl = destroyable = st == EJBStatus.DEPLOYED || st == EJBStatus.DEPLOYMENT_FAILED || st == EJBStatus.START_FAILED || st == EJBStatus.RUNNING || st == EJBStatus.SUSPENDED;
            if (!destroyable) {
                throw new EJBServerException("Could not undeploy - EJBModule '" + this.moduleName + "' is in " + (Object)((Object)this.status.get()) + " state");
            }
            this.status.set(EJBStatus.UNDEPLOYING);
        }
        this.stopContainers(this.containerList);
    }

    public void destroy(long gracefulTimeout) throws EJBServerException {
        assert (this.status.get() == EJBStatus.UNDEPLOYING);
        this.destroyContainers(this.containerList, gracefulTimeout);
        this.destroyModule();
        this.ejbEngine.removeDeployedModule(this);
        this.status.set(EJBStatus.UNDEPLOYED);
        if (logger.isLoggable(JeusMessage_EJB8._5158_LEVEL)) {
            logger.logp(JeusMessage_EJB8._5158_LEVEL, "EJBServer", "undeploy", JeusMessage_EJB8._5158, (Object)this.moduleName);
        }
    }

    public Map<String, BeanContainer> getContainerList() {
        return this.containerList;
    }

    public void setContainerList(Map<String, BeanContainer> containerList) {
        this.containerList = containerList;
    }

    public ModuleInfo getModuleInfo() {
        return this.moduleInfo;
    }

    public void start() throws Exception {
        if (!this.status.compareAndSet(EJBStatus.DEPLOYED, EJBStatus.STARTING)) {
            throw new Exception("EJBModule " + this.moduleName + " is not deployed state");
        }
        this.prepareModule();
        for (BeanContainer container : this.containerList.values()) {
            try {
                container.start();
            }
            catch (Throwable e) {
                this.status.set(EJBStatus.START_FAILED);
                if (e instanceof Exception) {
                    throw (Exception)e;
                }
                throw new Exception(e);
            }
        }
        EWSProvider provider = EWSProvider.getProvider();
        if (provider != null) {
            try {
                provider.postDeploy(this.ejbModuleMBean, this.containerList.values());
            }
            catch (Exception e) {
                this.status.set(EJBStatus.START_FAILED);
                throw e;
            }
        }
        this.status.set(EJBStatus.RUNNING);
    }

    protected void prepareModule() throws Exception {
    }

    protected void destroyModule() {
        block4: {
            try {
                if (logger.isLoggable(JeusMessage_EJB8._5168_LEVEL)) {
                    logger.logp(JeusMessage_EJB8._5168_LEVEL, "EJBServer", "undeployContainers", JeusMessage_EJB8._5168);
                }
                InitialContext initial = this.getLocalInitialContext();
                initial.destroySubcontext(this.moduleDomain);
                initial.close();
                if (logger.isLoggable(JeusMessage_EJB8._5169_LEVEL)) {
                    logger.logp(JeusMessage_EJB8._5169_LEVEL, "EJBServer", "undeployContainers", JeusMessage_EJB8._5169);
                }
            }
            catch (Throwable ex) {
                if (!logger.isLoggable(JeusMessage_EJB8._5170_LEVEL)) break block4;
                logger.logp(JeusMessage_EJB8._5170_LEVEL, "EJBServer", "undeployContainers", JeusMessage_EJB8._5170, ex);
            }
        }
    }

    public void resume() {
        if (!this.status.compareAndSet(EJBStatus.SUSPENDED, EJBStatus.RESUMING)) {
            return;
        }
        for (BeanContainer beanContainer : this.containerList.values()) {
            beanContainer.resume();
        }
        this.status.set(EJBStatus.RUNNING);
        if (logger.isLoggable(JeusMessage_EJB7._4952_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4952_LEVEL, "EJBModule", "resume", JeusMessage_EJB7._4952, (Object)this.moduleName);
        }
    }

    public void suspend() {
        if (!this.status.compareAndSet(EJBStatus.RUNNING, EJBStatus.SUSPENDING)) {
            return;
        }
        for (BeanContainer beanContainer : this.containerList.values()) {
            beanContainer.suspend();
        }
        this.status.set(EJBStatus.SUSPENDED);
        if (logger.isLoggable(JeusMessage_EJB7._4953_LEVEL)) {
            logger.logp(JeusMessage_EJB7._4953_LEVEL, "EJBModule", "suspend", JeusMessage_EJB7._4953, (Object)this.moduleName);
        }
    }

    public synchronized void passivate(long timeStamp) {
        if (this.status.get() != EJBStatus.RUNNING) {
            return;
        }
        for (BeanContainer container : this.containerList.values()) {
            if (!container.isRunning()) continue;
            try {
                container.passivate(timeStamp);
            }
            catch (Throwable th) {
                if (!logger.isLoggable(JeusMessage_EJB7._4954_LEVEL)) continue;
                logger.logp(JeusMessage_EJB7._4954_LEVEL, "EJBModule", "passivate", JeusMessage_EJB7._4954, (Object)container.getEJBId(), th);
            }
        }
    }

    public EJBModule getEJBModuleMBean() {
        return this.ejbModuleMBean;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    protected BeanContainer deployBean(String moduleDomain, BeanInfo beanInfo, boolean fastDeploy, Map<String, HashMap<String, Integer>> transactionInfo, ModuleSchema mSchema, FileArchive moduleHome, FileArchive tempHome, ArchiveArrayClassLoader loader, boolean isOnlyGenerating, String securityDomain, EJBCompiler compiler) throws JeusDeploymentException {
        String beanName = beanInfo.getBeanName();
        try {
            if (logger.isLoggable(JeusMessage_EJB8._5184_LEVEL)) {
                logger.logp(JeusMessage_EJB8._5184_LEVEL, "EJBServer", "deployBean", JeusMessage_EJB8._5184, new Object[]{beanName, moduleDomain.substring(1)});
            }
            BeanContainer container = null;
            HashMap<String, Integer> beanTransactionInfo = transactionInfo.get(beanName);
            switch (beanInfo.getEJBType()) {
                case SESSION: {
                    SessionBeanInfo sessionInfo = (SessionBeanInfo)beanInfo;
                    EJBCodeBuilder generator = new EJBCodeBuilder(tempHome, loader, compiler);
                    generator.generateSessionCodes(sessionInfo, fastDeploy);
                    break;
                }
                case MESSAGE_DRIVEN: {
                    break;
                }
                case ENTITY: {
                    CMEntityBeanPair cmBeanPair;
                    EntityBeanPair beanPair = ((EntityBeanInfo)beanInfo).getBeanPair();
                    EJBSourceGenerator generator = beanPair instanceof CMEntityBeanPair ? ((cmBeanPair = (CMEntityBeanPair)beanPair).getCMPVersion() == 2 ? ((BeanSchema)mSchema.entitiesCMP2.get((Object)beanInfo.getBeanName())).sourceGen : ((BeanSchema)mSchema.entitiesCMP1.get((Object)beanInfo.getBeanName())).sourceGen) : new EJBSourceGenerator(moduleHome, tempHome, moduleDomain.substring(1), loader, compiler);
                    if (logger.isLoggable(JeusMessage_EJB8._5185_LEVEL)) {
                        logger.logp(JeusMessage_EJB8._5185_LEVEL, "EJBServer", "deployBean", JeusMessage_EJB8._5185);
                    }
                    generator.generateCode(moduleDomain, beanPair, fastDeploy, beanTransactionInfo);
                    if (!logger.isLoggable(JeusMessage_EJB8._5186_LEVEL)) break;
                    logger.logp(JeusMessage_EJB8._5186_LEVEL, "EJBServer", "deployBean", JeusMessage_EJB8._5186);
                    break;
                }
                default: {
                    throw new EJBDeploymentException("Undefined EJB type - " + (Object)((Object)beanInfo.getEJBType()));
                }
            }
            if (!isOnlyGenerating) {
                container = BeanContainerFactory.createBeanContainer(beanInfo, loader, securityDomain, beanTransactionInfo);
                if (logger.isLoggable(JeusMessage_EJB8._5187_LEVEL)) {
                    logger.logp(JeusMessage_EJB8._5187_LEVEL, "EJBServer", "deployBean", JeusMessage_EJB8._5187, new Object[]{beanName, moduleDomain.substring(1)});
                } else if (logger.isLoggable(JeusMessage_EJB8._5201_LEVEL)) {
                    logger.logp(JeusMessage_EJB8._5201_LEVEL, "EJBServer", "deployBean", JeusMessage_EJB8._5201, new Object[]{beanName, moduleDomain.substring(1)});
                }
            }
            return container;
        }
        catch (JeusDeploymentException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new EJBDeploymentException(ex);
        }
    }

    private void stopAndDestroyContainers(Map<String, BeanContainer> containerList) {
        this.stopContainers(containerList);
        this.destroyContainers(containerList, 0L);
    }

    private void stopContainers(Map<String, BeanContainer> containerList) {
        for (String beanName : containerList.keySet()) {
            BeanContainer container = containerList.get(beanName);
            if (container == null) continue;
            try {
                container.stop();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    private void destroyContainers(Map<String, BeanContainer> containerList, long gracefulTimeout) {
        LeftTime leftTime = new LeftTime(gracefulTimeout);
        for (String beanName : containerList.keySet()) {
            BeanContainer container = containerList.get(beanName);
            if (container == null) continue;
            try {
                container.destroy(leftTime.leftTime());
                if (logger.isLoggable(JeusMessage_EJB8._5191_LEVEL)) {
                    logger.log(JeusMessage_EJB8._5191_LEVEL, JeusMessage_EJB8._5191, (Object)container.getEJBId());
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            leftTime.check();
        }
        containerList.clear();
    }

    private String getMethodFullName(MethodType method) {
        String methodFullName = method.getMethodName().getValue();
        if (logger.isLoggable(JeusMessage_EJB8._5148_LEVEL)) {
            logger.logp(JeusMessage_EJB8._5148_LEVEL, "EJBServer", "getMethodFullName", JeusMessage_EJB8._5148, (Object)methodFullName);
        }
        if (methodFullName.equals("*")) {
            return methodFullName;
        }
        MethodParamsType params = method.getMethodParams();
        if (params != null) {
            List methodParams = params.getMethodParam();
            methodFullName = methodFullName + "(";
            if (methodParams.size() > 0) {
                methodFullName = methodFullName + ((JavaTypeType)methodParams.get(0)).getValue();
                for (int i = 1; i < methodParams.size(); ++i) {
                    methodFullName = methodFullName + "," + ((JavaTypeType)methodParams.get(i)).getValue();
                }
            }
            methodFullName = methodFullName + ")";
        } else {
            methodFullName = methodFullName + "()";
        }
        MethodIntfType intf = method.getMethodIntf();
        if (intf != null) {
            String interfaceType = intf.getValue();
            if (interfaceType.equalsIgnoreCase("Home")) {
                methodFullName = methodFullName + "RH";
            } else if (interfaceType.equalsIgnoreCase("Remote")) {
                methodFullName = methodFullName + "R";
            } else if (interfaceType.equalsIgnoreCase("LocalHome")) {
                methodFullName = methodFullName + "LH";
            } else if (interfaceType.equalsIgnoreCase("Local")) {
                methodFullName = methodFullName + "L";
            } else if (interfaceType.equalsIgnoreCase("ServiceEndpoint")) {
                methodFullName = methodFullName + "S";
            }
        }
        if (logger.isLoggable(JeusMessage_EJB8._5149_LEVEL)) {
            logger.logp(JeusMessage_EJB8._5149_LEVEL, "EJBServer", "getMethodFullName", JeusMessage_EJB8._5149, new Object[]{methodFullName, methodFullName});
        }
        return methodFullName;
    }

    private InitialContext getLocalInitialContext() throws NamingException {
        Hashtable<String, String> envs = new Hashtable<String, String>();
        envs.put("jeus.jndi.jns.localbindings", "true");
        envs.put("jeus.jndi.jns.forcedbindings", "true");
        InitialContext ctx = new InitialContext(envs);
        return ctx;
    }
}

