/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.baseimpl;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBException;
import jeus.ejb.baseimpl.RemoteExporter;
import jeus.ejb.baseimpl.RemoteInvocationManager;
import jeus.ejb.baseimpl.RemoteInvokerHandler;
import jeus.ejb.client.rmi.RemoteInvocation;
import jeus.ejb.client.rmi.RemoteInvocationResponse;
import jeus.ejb.client.rmi.RemoteInvocationResponseImpl;
import jeus.ejb.client.rmi.RemoteInvoker;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.container.ejb.EJBSecurity;
import jeus.security.util.LoginUtil;
import jeus.transaction.ContextSenderReceiver;
import jeus.transaction.ServerContextSenderReceiver;
import jeus.transaction.ThreadContexts;
import jeus.transaction.client.TMContextCarrier;
import jeus.util.trace.GID;
import jeus.workarea.WorkAreaServiceHelper;

public class RemoteInvokerServer
implements RemoteInvoker {
    private RemoteInvokerHandler handler;
    private RemoteInvoker stub;
    private final RemoteExporter exporter;
    private final RemoteInvocationManager invocationManager;
    private static final String IVM_TICKET = "IVM_TICKET";
    private static final String LOGIN = "LOGON";
    private static final String READTX_TYPE = "READTX_TYPE";

    public RemoteInvokerServer(RemoteInvokerHandler handler, RemoteInvocationManager invocationManager, RemoteExporter exporter) {
        this.handler = handler;
        this.invocationManager = invocationManager;
        this.exporter = exporter;
    }

    public synchronized boolean isExported() {
        return this.stub != null;
    }

    public synchronized RemoteInvoker export() throws RemoteException {
        if (this.stub == null) {
            this.stub = (RemoteInvoker)this.exporter.export(this);
        }
        return this.stub;
    }

    public synchronized void unexport(boolean force) {
        if (this.stub != null) {
            try {
                this.exporter.unexport(this, force);
            }
            catch (NoSuchObjectException e) {
                e.printStackTrace();
            }
            this.stub = null;
        }
    }

    public synchronized RemoteInvoker getStub() {
        if (this.stub == null) {
            try {
                this.export();
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
        return this.stub;
    }

    public RemoteInvocationResponse invoke(RemoteInvocation invocation) throws Exception {
        try {
            this.preInvoke(invocation);
            Object result = this.handler.invoke(invocation.getInterface(), invocation.getSignature(), invocation.getArgs());
            RemoteInvocationResponseImpl response = new RemoteInvocationResponseImpl();
            response.setResult(result);
            this.postInvoke(invocation, response);
            RemoteInvocationResponseImpl remoteInvocationResponseImpl = response;
            return remoteInvocationResponseImpl;
        }
        catch (Exception ex) {
            this.handleException(invocation, ex);
            throw ex;
        }
        finally {
            this.handleFinally(invocation);
        }
    }

    public void preInvoke(RemoteInvocation invocation) throws Exception {
        byte[] txctx;
        ThreadContexts.initNextTimeout();
        this.invocationManager.beforeInvoke();
        invocation.setTransientContext(IVM_TICKET, true);
        byte[] securityCtx = invocation.getSecuritySubject();
        if (securityCtx != null) {
            try {
                EJBSecurity.loginEJBSubject(securityCtx);
                invocation.setTransientContext(LOGIN, true);
            }
            catch (SecurityException ex) {
                throw new EJBAccessException("The subject is not allowed to login this system");
            }
            catch (ServiceException ex) {
                throw new EJBException("Internal exception during checking security", (Exception)ex);
            }
        }
        if ((txctx = invocation.getTxContext()) != null) {
            int returnTxCtx = ContextSenderReceiver.readTMCtx(txctx);
            invocation.setTransientContext(READTX_TYPE, returnTxCtx);
        }
        if (invocation.getGID() != null) {
            GID.setCurrentGID(invocation.getGID());
        }
        WorkAreaServiceHelper.setPropagatedContext(invocation.getContext("jeus.workarea.context"));
    }

    public void postInvoke(RemoteInvocation invocation, RemoteInvocationResponseImpl response) throws Exception {
        Integer returnTxCtx = (Integer)invocation.getTransientContext(READTX_TYPE);
        if (returnTxCtx != null) {
            if (returnTxCtx == 2) {
                ServerContextSenderReceiver.checkRegistration();
            } else if (returnTxCtx == 1) {
                response.setTxContext(ContextSenderReceiver.getPropagationContext());
            }
        }
        if (GID.useGID) {
            response.setGID(GID.getCurrentGIDBytes());
        }
    }

    public void handleException(RemoteInvocation invocation, Exception ex) throws Exception {
        Integer returnTxCtx = (Integer)invocation.getTransientContext(READTX_TYPE);
        if (returnTxCtx != null && returnTxCtx == 1) {
            throw new TMContextCarrier(ex, ContextSenderReceiver.getPropagationContext());
        }
    }

    private void handleFinally(RemoteInvocation invocation) {
        if (invocation.getTransientContext(LOGIN) != null) {
            try {
                LoginUtil.logoutWithRuntimeException();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (invocation.getTransientContext(IVM_TICKET) != null) {
            this.invocationManager.afterInvoke();
        }
        WorkAreaServiceHelper.clearUserWorkArea();
        GID.setCurrentGID((GID)null);
    }
}

