/*
 * Decompiled with CFR 0.152.
 */
package jeus.ejb.baseimpl;

import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.SessionContext;
import javax.persistence.EntityManager;
import javax.security.jacc.EJBRoleRefPermission;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPMessage;
import jeus.ejb.BeanState;
import jeus.ejb.baseimpl.BusinessObjectHandler;
import jeus.ejb.baseimpl.EJBContextImpl;
import jeus.ejb.baseimpl.EJBLocalObjectBase;
import jeus.ejb.baseimpl.EJBObjectBase;
import jeus.ejb.baseimpl.EJBSessionIfObject;
import jeus.ejb.container3.BaseBeanContainer;
import jeus.ejb.interceptor.Invocation;
import jeus.persistence.container.PersistenceUnit;
import jeus.security.base.SecurityException;
import jeus.security.container.ejb.EJBSecurity;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusRuntimeException;
import jeus.util.message.JeusMessage_EJB0;
import jeus.webservices.spi.EWSProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionContextImpl
extends EJBContextImpl
implements SessionContext {
    protected static final int OP_getMessageContext = 2001;
    protected static final int OP_getBusinessObject = 2002;
    protected static final int OP_getInvokedBusinessInterface = 2003;
    private boolean isStateless;
    private String sessionID;
    private transient boolean toBeRemoved;
    protected transient EJBObjectBase ejbObjectImpl;
    protected transient EJBLocalObjectBase ejbLocalObject;
    protected transient BusinessObjectHandler businessObjectHandler;
    protected transient Map<PersistenceUnit, EntityManager> extendedPersistenceContextMap;
    protected transient Map<EntityManager, AtomicInteger> extendedPersistenceContextRefCountMap;
    private boolean isStatefulClustered = false;

    public SessionContextImpl(BaseBeanContainer container, boolean isStateless, boolean isStatefulClustered) {
        super(container);
        this.isStateless = isStateless;
        this.isStatefulClustered = isStatefulClustered;
    }

    public boolean isStateful() {
        return !this.isStateless;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public boolean isToBeRemoved() {
        return this.toBeRemoved;
    }

    public void setToBeRemoved(boolean b) {
        this.toBeRemoved = b;
    }

    public boolean canBePassivated() {
        return this.state == BeanState.READY && this.tx == null && !this.hasExtendedPC();
    }

    public void setEJBLocalObject(EJBLocalObjectBase ejbLocalObject) {
        this.ejbLocalObject = ejbLocalObject;
    }

    public void setBusinessObjectHandler(BusinessObjectHandler businessObjectHandler) {
        this.businessObjectHandler = businessObjectHandler;
    }

    public void setEJBSessionIfObject(EJBSessionIfObject ifobject) {
        if (ifobject == null) {
            this.setEJBObject(null);
            this.setEJBLocalObject(null);
            this.setBusinessObjectHandler(null);
        } else {
            switch (ifobject._getIfObjectType()) {
                case EJBOBJECT: {
                    this.setEJBObject((EJBObjectBase)((Object)ifobject));
                    break;
                }
                case EJBLOCALOBJECT: {
                    this.setEJBLocalObject((EJBLocalObjectBase)((Object)ifobject));
                    break;
                }
                case BUSINESSOBJECT: {
                    this.setBusinessObjectHandler((BusinessObjectHandler)ifobject);
                }
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.setEJBSessionIfObject(null);
        this.extendedPersistenceContextMap = null;
        this.extendedPersistenceContextRefCountMap = null;
    }

    public void setEJBObject(EJBObjectBase ejbobj) {
        if (logger.isLoggable(JeusMessage_EJB0._1003_LEVEL)) {
            logger.logp(JeusMessage_EJB0._1003_LEVEL, "EJBContextImpl", "setEJBObject", JeusMessage_EJB0._1003, new Object[]{this, ejbobj});
        }
        this.ejbObjectImpl = ejbobj;
    }

    public EJBObject getEJBObject() throws IllegalStateException {
        this.checkOperationsAllowed(1011);
        if (this.ejbObjectImpl == null) {
            this.ejbObjectImpl = this.container.getEJBObjectHandler(this.sessionID);
        }
        if (this.ejbObjectImpl != null) {
            return this.ejbObjectImpl;
        }
        throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB0._1255));
    }

    public EJBObjectBase getEJBObjectHandler() {
        return this.ejbObjectImpl;
    }

    public MessageContext getMessageContext() throws IllegalStateException {
        this.checkOperationsAllowed(2001);
        EWSProvider provider = EWSProvider.getProvider();
        return provider != null ? provider.getMessageContext() : null;
    }

    public <T> T getBusinessObject(Class<T> businessInterface) throws IllegalStateException {
        this.checkOperationsAllowed(2002);
        if (this.businessObjectHandler == null) {
            this.businessObjectHandler = this.container.getBusinessObjectHandler(this.sessionID);
        }
        if (this.businessObjectHandler != null) {
            try {
                return (T)this.businessObjectHandler.getClientProxy(businessInterface);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalStateException(ex.getMessage());
            }
            catch (Exception ex) {
                throw new EJBException("Internal error occurred", ex);
            }
        }
        throw new IllegalStateException("Session context is not associated with business object");
    }

    public BusinessObjectHandler getBusinessObjectHandler() {
        return this.businessObjectHandler;
    }

    public Class getInvokedBusinessInterface() throws IllegalStateException {
        Invocation invocation;
        this.checkOperationsAllowed(2003);
        if (this.businessObjectHandler == null) {
            this.businessObjectHandler = this.container.getBusinessObjectHandler(this.sessionID);
        }
        Class interfaze = null;
        if (this.businessObjectHandler != null && (invocation = BaseBeanContainer.getCurrentInvocation()) != null) {
            interfaze = invocation.getInvokedInterface();
        }
        if (interfaze == null) {
            throw new IllegalStateException("bean has not been invoked through a business interface");
        }
        return interfaze;
    }

    public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
        this.checkOperationsAllowed(1010);
        if (this.ejbLocalObject == null) {
            this.ejbLocalObject = this.container.getEJBLocalObjectHandler(this.sessionID);
        }
        if (this.ejbLocalObject != null) {
            return this.ejbLocalObject;
        }
        throw new IllegalStateException("Session context is not associated with EJBLocalObject");
    }

    public EJBLocalObjectBase getEJBLocalObjectHandler() {
        return this.ejbLocalObject;
    }

    @Override
    public boolean isCallerInRole(String role) {
        this.checkOperationsAllowed(1004);
        try {
            SOAPMessage soapMessage;
            EWSProvider provider = EWSProvider.getProvider();
            SOAPMessage sOAPMessage = soapMessage = provider != null ? provider.getSOAPMessage() : null;
            if (soapMessage == null) {
                if (logger.isLoggable(JeusMessage_EJB0._1271_LEVEL)) {
                    logger.logp(JeusMessage_EJB0._1271_LEVEL, "SessionContextImpl", "isCallerInRole", JeusMessage_EJB0._1271);
                }
                EJBSecurity.setEJBSecurityContext(this.container.getSecurityPolicyID(), this.bean, null_objects, null);
            } else {
                if (logger.isLoggable(JeusMessage_EJB0._1272_LEVEL)) {
                    logger.logp(JeusMessage_EJB0._1272_LEVEL, "SessionContextImpl", "isCallerInRole", JeusMessage_EJB0._1272);
                }
                EJBSecurity.setEJBSecurityContext(this.container.getSecurityPolicyID(), this.bean, null, soapMessage);
            }
        }
        catch (Throwable e) {
            if (logger.isLoggable(JeusMessage_EJB0._1273_LEVEL)) {
                logger.logp(JeusMessage_EJB0._1273_LEVEL, "SessionContextImpl", "isCallerInRole", JeusMessage_EJB0._1273, (Object)role, e);
            }
            throw new JeusRuntimeException(JeusMessage_EJB0._1273, (Object)role, e);
        }
        try {
            if (this.container.getRunAsSubject() == null) {
                EJBSecurity.checkEJBCallerInRole(new EJBRoleRefPermission(this.ejbName, role));
            } else {
                EJBSecurity.checkEJBRunasCallerInRole(new EJBRoleRefPermission(this.ejbName, role));
            }
            boolean e = true;
            return e;
        }
        catch (SecurityException ex) {
            boolean bl = false;
            return bl;
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_EJB0._1276_LEVEL)) {
                logger.logp(JeusMessage_EJB0._1276_LEVEL, "SessionContextImpl", "isCallerInRole", JeusMessage_EJB0._1276, (Object)role, ex);
            }
            throw new JeusRuntimeException(ErrorMsgManager.getLocalizedString((int)JeusMessage_EJB0._1276, (Object)role) + ex, ex);
        }
        finally {
            EJBSecurity.clearEJBSecurityContext();
        }
    }

    @Override
    public String toString() {
        return "SessionContextImpl:[" + super.toString() + "],sessionID=" + this.sessionID;
    }

    @Override
    public void checkOperationsAllowed(int opnum) throws IllegalStateException {
        boolean bmt = this.container.isBeanManagedTx();
        if (bmt) {
            if (opnum == 1007 || opnum == 1006) {
                throw new IllegalStateException("Not allowed in bean-managed transaction EJB");
            }
        } else if (opnum == 1100 || opnum == 1005) {
            throw new IllegalStateException("UserTransaction operations are not allowed in container-managed transaction EJB");
        }
        if (this.isStateless) {
            block0 : switch (this.state) {
                case DEP_INJECTION: {
                    switch (opnum) {
                        case 1001: 
                        case 1002: 
                        case 1009: {
                            return;
                        }
                    }
                    break;
                }
                case POST_CONSTRUCT: 
                case PRE_DESTROY: {
                    switch (opnum) {
                        case 1001: 
                        case 1002: 
                        case 1008: 
                        case 1009: 
                        case 1010: 
                        case 1011: 
                        case 2002: {
                            return;
                        }
                        case 1005: {
                            return;
                        }
                    }
                    break;
                }
                case READY: {
                    switch (opnum) {
                        case 1005: 
                        case 1100: {
                            return;
                        }
                        case 2001: {
                            break block0;
                        }
                    }
                    return;
                }
                case WEBENDPOINT: {
                    switch (opnum) {
                        case 1005: 
                        case 1100: {
                            return;
                        }
                        case 2003: {
                            break block0;
                        }
                        case 2001: {
                            return;
                        }
                    }
                    return;
                }
                case TIMEOUT: {
                    switch (opnum) {
                        case 1005: 
                        case 1100: {
                            return;
                        }
                        case 2003: {
                            break block0;
                        }
                        case 2001: {
                            break block0;
                        }
                    }
                    return;
                }
            }
        } else {
            block28 : switch (this.state) {
                case DEP_INJECTION: {
                    switch (opnum) {
                        case 1001: 
                        case 1002: 
                        case 1009: {
                            return;
                        }
                    }
                    break;
                }
                case POST_CONSTRUCT: 
                case PRE_DESTROY: 
                case POST_ACTIVATE: 
                case PRE_PASSIVATE: {
                    switch (opnum) {
                        case 1001: 
                        case 1002: 
                        case 1003: 
                        case 1004: 
                        case 1009: 
                        case 1010: 
                        case 1011: 
                        case 2002: {
                            return;
                        }
                        case 1005: 
                        case 1100: {
                            return;
                        }
                    }
                    break;
                }
                case READY: {
                    switch (opnum) {
                        case 1005: 
                        case 1100: {
                            return;
                        }
                        case 2001: {
                            break block28;
                        }
                    }
                    return;
                }
                case AFTER_BEGIN: 
                case BEFORE_COMPLETION: {
                    switch (opnum) {
                        case 1001: 
                        case 1002: 
                        case 1003: 
                        case 1004: 
                        case 1006: 
                        case 1007: 
                        case 1009: 
                        case 1010: 
                        case 1011: 
                        case 1200: 
                        case 2002: {
                            return;
                        }
                    }
                    break;
                }
                case AFTER_COMPLETION: {
                    switch (opnum) {
                        case 1001: 
                        case 1002: 
                        case 1003: 
                        case 1004: 
                        case 1009: 
                        case 1010: 
                        case 1011: 
                        case 2002: {
                            return;
                        }
                    }
                    break;
                }
            }
        }
        throw new IllegalStateException(this.getCheckOperationsAllowedErrorMessage());
    }

    public boolean hasExtendedPC() {
        return this.extendedPersistenceContextMap != null && this.extendedPersistenceContextMap.size() != 0;
    }

    public Map<PersistenceUnit, EntityManager> getExtendedPersistenceContextMap() {
        return this.extendedPersistenceContextMap;
    }

    public void addExtendedPersistenceContext(PersistenceUnit pu, EntityManager pc) {
        if (this.extendedPersistenceContextMap == null) {
            this.extendedPersistenceContextMap = new HashMap<PersistenceUnit, EntityManager>();
        }
        this.extendedPersistenceContextMap.put(pu, pc);
    }

    public EntityManager getExtendedPersistenceContext(PersistenceUnit pu) {
        if (this.extendedPersistenceContextMap == null) {
            return null;
        }
        return this.extendedPersistenceContextMap.get(pu);
    }

    public Collection<EntityManager> getExtendedPersistenceContexts() {
        if (this.extendedPersistenceContextMap == null) {
            return null;
        }
        return this.extendedPersistenceContextMap.values();
    }

    public void addExtendedPersistenceContextRefCount(EntityManager pc, AtomicInteger refCount) {
        if (this.extendedPersistenceContextRefCountMap == null) {
            this.extendedPersistenceContextRefCountMap = new IdentityHashMap<EntityManager, AtomicInteger>();
        }
        this.extendedPersistenceContextRefCountMap.put(pc, refCount);
    }

    public AtomicInteger getExtendedPersistenceContextRefCount(EntityManager pc) {
        if (pc == null || this.extendedPersistenceContextRefCountMap == null) {
            return null;
        }
        return this.extendedPersistenceContextRefCountMap.get(pc);
    }

    public boolean isStatefulClustered() {
        return this.isStatefulClustered;
    }
}

